/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.operators.ExchangeOperator;
import dr.evomodel.operators.FNPR;
import dr.evomodel.operators.NNI;
import dr.evomodel.operators.SubtreeSlideOperator;
import dr.evomodel.operators.WilsonBalding;
import dr.evomodel.tree.ConditionalCladeFrequency;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.MathUtils;
import java.util.ArrayList;

@Deprecated
public class ImportanceSubtreeSwap
extends AbstractTreeOperator {
    public final int SAMPLE_EVERY = 10;
    private final TreeModel tree;
    private final int samples;
    private int sampleCount = 0;
    private boolean burnin = false;
    private final ConditionalCladeFrequency probabilityEstimater;
    private final OperatorSchedule schedule;

    public ImportanceSubtreeSwap(TreeModel treeModel, double d, int n, int n2) {
        this.tree = treeModel;
        this.setWeight(d);
        this.samples = n;
        this.sampleCount = 0;
        this.probabilityEstimater = new ConditionalCladeFrequency(treeModel, n2);
        this.schedule = this.getOperatorSchedule(treeModel);
    }

    public ImportanceSubtreeSwap(TreeModel treeModel, double d, int n) {
        this.tree = treeModel;
        this.setWeight(d);
        this.samples = n;
        this.sampleCount = 0;
        double d2 = 1.0 - Math.pow(0.5, 1.0 / (double)n);
        this.probabilityEstimater = new ConditionalCladeFrequency(treeModel, d2);
        this.schedule = this.getOperatorSchedule(treeModel);
    }

    private OperatorSchedule getOperatorSchedule(TreeModel treeModel) {
        ExchangeOperator exchangeOperator = new ExchangeOperator(0, treeModel, 10.0);
        ExchangeOperator exchangeOperator2 = new ExchangeOperator(1, treeModel, 3.0);
        SubtreeSlideOperator subtreeSlideOperator = new SubtreeSlideOperator(treeModel, 10.0, 1.0, true, false, false, false, AdaptationMode.ADAPTATION_ON, 0.234);
        NNI nNI = new NNI(treeModel, 10.0);
        WilsonBalding wilsonBalding = new WilsonBalding(treeModel, 3.0);
        FNPR fNPR = new FNPR(treeModel, 5.0);
        SimpleOperatorSchedule simpleOperatorSchedule = new SimpleOperatorSchedule();
        simpleOperatorSchedule.addOperator(exchangeOperator);
        simpleOperatorSchedule.addOperator(exchangeOperator2);
        simpleOperatorSchedule.addOperator(subtreeSlideOperator);
        simpleOperatorSchedule.addOperator(nNI);
        simpleOperatorSchedule.addOperator(wilsonBalding);
        simpleOperatorSchedule.addOperator(fNPR);
        return simpleOperatorSchedule;
    }

    @Override
    public double doOperation() {
        if (!this.burnin) {
            if (this.sampleCount < this.samples * 10) {
                ++this.sampleCount;
                if (this.sampleCount % 10 == 0) {
                    this.probabilityEstimater.addTree(this.tree);
                }
                this.setAcceptCount(0L);
                this.setRejectCount(0L);
                this.setTransitions(0L);
                return this.doUnguidedOperation();
            }
            return this.importanceExchange();
        }
        return this.doUnguidedOperation();
    }

    private double doUnguidedOperation() {
        int n = this.schedule.getNextOperatorIndex();
        SimpleMCMCOperator simpleMCMCOperator = (SimpleMCMCOperator)this.schedule.getOperator(n);
        return simpleMCMCOperator.doOperation();
    }

    private double importanceExchange() {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        NodeRef nodeRef3;
        NodeRef nodeRef4;
        int n;
        NodeRef nodeRef5;
        int n2 = this.tree.getNodeCount();
        NodeRef nodeRef6 = this.tree.getRoot();
        while (nodeRef6 == (nodeRef5 = this.tree.getNode(n = MathUtils.nextInt(n2))) || this.tree.getParent(nodeRef5) == nodeRef6 && this.tree.getNodeHeight(nodeRef5) > this.tree.getNodeHeight(this.getOtherChild(this.tree, this.tree.getParent(nodeRef5), nodeRef5))) {
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        NodeRef nodeRef7 = this.tree.getParent(nodeRef5);
        double d = 0.0;
        double d2 = this.calculateTreeProbability(this.tree);
        int n3 = (int)(-d2);
        d2 = Math.exp(d2 + (double)n3);
        this.tree.beginTreeEdit();
        for (int i = 0; i < n2; ++i) {
            nodeRef4 = this.tree.getNode(i);
            if (nodeRef4 == nodeRef6 || nodeRef7 == (nodeRef3 = this.tree.getParent(nodeRef4)) || nodeRef5 == nodeRef3 || nodeRef4 == nodeRef7 || !(this.tree.getNodeHeight(nodeRef4) < this.tree.getNodeHeight(nodeRef7)) || !(this.tree.getNodeHeight(nodeRef5) < this.tree.getNodeHeight(nodeRef3))) continue;
            arrayList.add(i);
            this.swap(this.tree, this.tree.getNode(n), this.tree.getNode(i));
            double d3 = Math.exp(this.calculateTreeProbability(this.tree) + (double)n3);
            arrayList2.add(d3);
            this.swap(this.tree, this.tree.getNode(n), this.tree.getNode(i));
            d += d3;
        }
        double d4 = MathUtils.nextDouble() * d;
        int n4 = 0;
        while (d4 > 0.0) {
            d4 -= ((Double)arrayList2.get(n4)).doubleValue();
            ++n4;
        }
        nodeRef4 = this.tree.getNode((Integer)arrayList.get(--n4));
        nodeRef3 = this.tree.getParent(nodeRef4);
        double d5 = 0.0;
        int n5 = (Integer)arrayList.get(n4);
        for (int i = 0; i < n2; ++i) {
            nodeRef2 = this.tree.getNode(i);
            if (nodeRef2 == nodeRef6 || nodeRef3 == (nodeRef = this.tree.getParent(nodeRef2)) || nodeRef4 == nodeRef || nodeRef2 == nodeRef3 || !(this.tree.getNodeHeight(nodeRef2) < this.tree.getNodeHeight(nodeRef3)) || !(this.tree.getNodeHeight(nodeRef4) < this.tree.getNodeHeight(nodeRef))) continue;
            this.swap(this.tree, this.tree.getNode(n5), this.tree.getNode(i));
            double d6 = Math.exp(this.calculateTreeProbability(this.tree) + (double)n3);
            d5 += d6;
            this.swap(this.tree, this.tree.getNode(n5), this.tree.getNode(i));
        }
        this.swap(this.tree, nodeRef5, nodeRef4);
        double d7 = (Double)arrayList2.get(n4);
        nodeRef7 = this.tree.getParent(nodeRef5);
        double d8 = 0.0;
        for (int i = 0; i < n2; ++i) {
            nodeRef4 = this.tree.getNode(i);
            if (nodeRef4 == nodeRef6 || nodeRef7 == (nodeRef3 = this.tree.getParent(nodeRef4)) || nodeRef5 == nodeRef3 || nodeRef4 == nodeRef7 || !(this.tree.getNodeHeight(nodeRef4) < this.tree.getNodeHeight(nodeRef7)) || !(this.tree.getNodeHeight(nodeRef5) < this.tree.getNodeHeight(nodeRef3))) continue;
            this.swap(this.tree, this.tree.getNode(n), this.tree.getNode(i));
            double d9 = Math.exp(this.calculateTreeProbability(this.tree) + (double)n3);
            d8 += d9;
            this.swap(this.tree, this.tree.getNode(n), this.tree.getNode(i));
        }
        double d10 = 0.0;
        nodeRef4 = this.tree.getNode((Integer)arrayList.get(n4));
        nodeRef3 = this.tree.getParent(nodeRef4);
        for (int i = 0; i < n2; ++i) {
            nodeRef2 = this.tree.getNode(i);
            if (nodeRef2 == nodeRef6 || nodeRef3 == (nodeRef = this.tree.getParent(nodeRef2)) || nodeRef4 == nodeRef || nodeRef2 == nodeRef3 || !(this.tree.getNodeHeight(nodeRef2) < this.tree.getNodeHeight(nodeRef3)) || !(this.tree.getNodeHeight(nodeRef4) < this.tree.getNodeHeight(nodeRef))) continue;
            this.swap(this.tree, this.tree.getNode(n5), this.tree.getNode(i));
            double d11 = Math.exp(this.calculateTreeProbability(this.tree) + (double)n3);
            d10 += d11;
            this.swap(this.tree, this.tree.getNode(n5), this.tree.getNode(i));
        }
        this.tree.endTreeEdit();
        try {
            this.tree.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            throw new RuntimeException(invalidTreeException.getMessage());
        }
        double d12 = d7 / d + d7 / d5;
        double d13 = d2 / d8 + d2 / d10;
        double d14 = Math.log(d13 / d12);
        return d14;
    }

    private void swap(TreeModel treeModel, NodeRef nodeRef, NodeRef nodeRef2) {
        NodeRef nodeRef3 = treeModel.getParent(nodeRef);
        NodeRef nodeRef4 = treeModel.getParent(nodeRef2);
        treeModel.removeChild(nodeRef3, nodeRef);
        treeModel.removeChild(nodeRef4, nodeRef2);
        treeModel.addChild(nodeRef4, nodeRef);
        treeModel.addChild(nodeRef3, nodeRef2);
    }

    private double calculateTreeProbability(Tree tree) {
        return this.probabilityEstimater.getTreeProbability(tree);
    }

    public void setBurnin(boolean bl) {
        this.burnin = bl;
    }

    @Override
    public String getOperatorName() {
        return "ImportanceSubtreeSwap";
    }

    public String getPerformanceSuggestion() {
        return "";
    }
}

