/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.util.Taxon;
import dr.evomodel.tree.HiddenLinkageModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class MoveLinkageGroup
extends SimpleMCMCOperator {
    HiddenLinkageModel hlm;
    int readCount;
    int groupCount;

    public MoveLinkageGroup(HiddenLinkageModel hiddenLinkageModel, double d) {
        this.hlm = hiddenLinkageModel;
        this.readCount = hiddenLinkageModel.getData().getReadsTaxa().getTaxonCount();
        this.groupCount = hiddenLinkageModel.getLinkageGroupCount();
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        int n = MathUtils.nextInt(this.readCount);
        Taxon taxon = this.hlm.getData().getReadsTaxa().getTaxon(n);
        int n2 = this.hlm.getLinkageGroupId(taxon);
        int n3 = MathUtils.nextInt(this.groupCount);
        this.hlm.moveReadGroup(taxon, n2, n3);
        double d = 0.0;
        return d;
    }

    @Override
    public String getOperatorName() {
        return "moveLinkageGroup(" + this.hlm.getId() + ")";
    }

    public String getPerformanceSuggestion() {
        return "Ask Aaron Darling to write a better operator";
    }
}

