/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tipstatesmodel;

import dr.evolution.util.TaxonList;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Arrays;
import java.util.List;

public class SequenceErrorModel
extends TipStatesModel
implements Citable {
    private final ErrorType errorType;
    private final Parameter baseErrorRateParameter;
    private final Parameter ageRelatedErrorRateParameter;
    private final Parameter indicatorParameter;

    public SequenceErrorModel(TaxonList taxonList, TaxonList taxonList2, ErrorType errorType, Parameter parameter, Parameter parameter2, Parameter parameter3) {
        super("sequenceErrorModel", taxonList, taxonList2);
        this.errorType = errorType;
        if (parameter != null) {
            this.baseErrorRateParameter = parameter;
            this.addVariable(this.baseErrorRateParameter);
        } else {
            this.baseErrorRateParameter = null;
        }
        if (parameter2 != null) {
            this.ageRelatedErrorRateParameter = parameter2;
            this.addVariable(parameter2);
        } else {
            this.ageRelatedErrorRateParameter = null;
        }
        if (parameter3 != null) {
            this.indicatorParameter = parameter3;
            this.addVariable(parameter3);
        } else {
            this.indicatorParameter = null;
        }
        if (parameter3 != null) {
            this.addStatistic(new TaxonHasErrorsStatistic());
        }
    }

    @Override
    protected void taxaChanged() {
        if (this.indicatorParameter != null && this.indicatorParameter.getDimension() <= 1) {
            this.indicatorParameter.setDimension(this.tree.getExternalNodeCount());
        }
    }

    @Override
    public TipStatesModel.Type getModelType() {
        return TipStatesModel.Type.PARTIALS;
    }

    @Override
    public void getTipStates(int n, int[] nArray) {
        throw new IllegalArgumentException("This model emits only tip partials");
    }

    @Override
    public void getTipPartials(int n, double[] dArray) {
        int[] nArray = this.states[n];
        if (this.indicatorParameter == null || this.indicatorParameter.getParameterValue(n) > 0.0) {
            double d = 1.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (!this.excluded[n]) {
                if (this.baseErrorRateParameter != null) {
                    d -= this.baseErrorRateParameter.getParameterValue(0);
                }
                if (this.ageRelatedErrorRateParameter != null) {
                    double d4 = this.ageRelatedErrorRateParameter.getParameterValue(0);
                    double d5 = this.tree.getNodeHeight(this.tree.getExternalNode(n));
                    d *= Math.exp(-d4 * d5);
                }
                if (this.errorType == ErrorType.ALL_SUBSTITUTIONS) {
                    d3 = d2 = (1.0 - d) / 3.0;
                } else if (this.errorType == ErrorType.TRANSITIONS_ONLY) {
                    d2 = 1.0 - d;
                    d3 = 0.0;
                } else {
                    throw new IllegalArgumentException("only TRANSITIONS_ONLY and ALL_SUBSTITUTIONS are supported");
                }
            }
            int n2 = 0;
            for (int i = 0; i < this.patternCount; ++i) {
                switch (nArray[i]) {
                    case 0: {
                        dArray[n2] = d;
                        dArray[n2 + 1] = d3;
                        dArray[n2 + 2] = d2;
                        dArray[n2 + 3] = d3;
                        break;
                    }
                    case 1: {
                        dArray[n2] = d3;
                        dArray[n2 + 1] = d;
                        dArray[n2 + 2] = d3;
                        dArray[n2 + 3] = d2;
                        break;
                    }
                    case 2: {
                        dArray[n2] = d2;
                        dArray[n2 + 1] = d3;
                        dArray[n2 + 2] = d;
                        dArray[n2 + 3] = d3;
                        break;
                    }
                    case 3: {
                        dArray[n2] = d3;
                        dArray[n2 + 1] = d2;
                        dArray[n2 + 2] = d3;
                        dArray[n2 + 3] = d;
                        break;
                    }
                    default: {
                        dArray[n2] = 1.0;
                        dArray[n2 + 1] = 1.0;
                        dArray[n2 + 2] = 1.0;
                        dArray[n2 + 3] = 1.0;
                    }
                }
                n2 += this.stateCount;
            }
        } else {
            int n3 = 0;
            for (int i = 0; i < this.patternCount; ++i) {
                switch (nArray[i]) {
                    case 0: {
                        dArray[n3] = 1.0;
                        dArray[n3 + 1] = 0.0;
                        dArray[n3 + 2] = 0.0;
                        dArray[n3 + 3] = 0.0;
                        break;
                    }
                    case 1: {
                        dArray[n3] = 0.0;
                        dArray[n3 + 1] = 1.0;
                        dArray[n3 + 2] = 0.0;
                        dArray[n3 + 3] = 0.0;
                        break;
                    }
                    case 2: {
                        dArray[n3] = 0.0;
                        dArray[n3 + 1] = 0.0;
                        dArray[n3 + 2] = 1.0;
                        dArray[n3 + 3] = 0.0;
                        break;
                    }
                    case 3: {
                        dArray[n3] = 0.0;
                        dArray[n3 + 1] = 0.0;
                        dArray[n3 + 2] = 0.0;
                        dArray[n3 + 3] = 1.0;
                        break;
                    }
                    default: {
                        dArray[n3] = 1.0;
                        dArray[n3 + 1] = 1.0;
                        dArray[n3 + 2] = 1.0;
                        dArray[n3 + 3] = 1.0;
                    }
                }
                n3 += this.stateCount;
            }
        }
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Sequence error model";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("A", "Rambaut"), new Author("SYW", "Ho"), new Author("AJ", "Drummond"), new Author("B", "Shapiro")}, "Accommodating the effect of ancient DNA damage on inferences of demographic histories", 2008, "Mol Biol Evol", 26, 245, 248, "10.1093/molbev/msn256"), new Citation(new Author[]{new Author("J", "Felsenstein")}, "Inferring Phylogenies", 2004, "Sinauer Associates", ""));
    }

    public class TaxonHasErrorsStatistic
    extends Statistic.Abstract {
        public TaxonHasErrorsStatistic() {
            super("hasErrors");
        }

        @Override
        public int getDimension() {
            if (SequenceErrorModel.this.indicatorParameter == null) {
                return 0;
            }
            return SequenceErrorModel.this.indicatorParameter.getDimension();
        }

        @Override
        public String getDimensionName(int n) {
            return (String)SequenceErrorModel.this.taxonMap.get(n);
        }

        @Override
        public double getStatisticValue(int n) {
            return SequenceErrorModel.this.indicatorParameter.getParameterValue(n);
        }
    }

    public static enum ErrorType {
        TYPE_1_TRANSITIONS("type1Transitions"),
        TYPE_2_TRANSITIONS("type2Transitions"),
        TRANSITIONS_ONLY("transitionsOnly"),
        ALL_SUBSTITUTIONS("allSubstitutions");

        final String label;

        private ErrorType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }
}

