/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TransformableTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeTransform;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class TransformedTreeModel
extends AbstractModel
implements MutableTreeModel,
TransformableTree,
Citable {
    private final TreeTransform treeTransform;
    private final MutableTreeModel treeModel;

    public TransformedTreeModel(String string, MutableTreeModel mutableTreeModel, TreeTransform treeTransform) {
        super(string);
        this.treeModel = mutableTreeModel;
        this.treeTransform = treeTransform;
        this.addModel(mutableTreeModel);
        this.addModel(treeTransform);
        Logger logger = Logger.getLogger("dr.evomodel.tree");
        logger.info("Creating a transform tree.");
    }

    @Override
    public String toString() {
        return TreeUtils.newick(this);
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return this.treeTransform.transform(this.treeModel, nodeRef, this.treeModel.getNodeHeight(nodeRef));
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
        if (nodeRef2 == null) {
            return 0.0;
        }
        return this.getNodeHeight(nodeRef2) - this.getNodeHeight(nodeRef);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeTransform) {
            this.fireModelChanged(new TreeChangedEvent.WholeTree());
        } else if (model == this.treeModel) {
            this.fireModelChanged(object, n);
        } else {
            throw new IllegalArgumentException("Illegal model");
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public NodeRef getRoot() {
        return this.treeModel.getRoot();
    }

    @Override
    public int getNodeCount() {
        return this.treeModel.getNodeCount();
    }

    @Override
    public NodeRef getNode(int n) {
        return this.treeModel.getNode(n);
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.treeModel.getInternalNode(n);
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.treeModel.getExternalNode(n);
    }

    @Override
    public int getExternalNodeCount() {
        return this.treeModel.getExternalNodeCount();
    }

    @Override
    public int getInternalNodeCount() {
        return this.treeModel.getInternalNodeCount();
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return this.treeModel.getNodeTaxon(nodeRef);
    }

    @Override
    public boolean hasNodeHeights() {
        return this.treeModel.hasNodeHeights();
    }

    @Override
    public boolean hasBranchLengths() {
        return this.treeModel.hasBranchLengths();
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        return this.treeModel.getNodeRate(nodeRef);
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        return this.treeModel.getNodeAttribute(nodeRef, string);
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        return this.treeModel.getNodeAttributeNames(nodeRef);
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return this.treeModel.isExternal(nodeRef);
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return this.treeModel.isRoot(nodeRef);
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        return this.treeModel.getChildCount(nodeRef);
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return this.treeModel.getChild(nodeRef, n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return this.treeModel.getParent(nodeRef);
    }

    @Override
    public Tree getCopy() {
        return this.treeModel.getCopy();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double[] getMultivariateNodeTrait(NodeRef nodeRef, String string) {
        return this.treeModel.getMultivariateNodeTrait(nodeRef, string);
    }

    @Override
    public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
        this.treeModel.setMultivariateTrait(nodeRef, string, dArray);
    }

    @Override
    public boolean beginTreeEdit() {
        return this.treeModel.beginTreeEdit();
    }

    @Override
    public void endTreeEdit() {
        this.treeModel.endTreeEdit();
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.treeModel.addChild(nodeRef, nodeRef2);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.treeModel.removeChild(nodeRef, nodeRef2);
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        this.treeModel.replaceChild(nodeRef, nodeRef2, nodeRef3);
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        this.treeModel.setRoot(nodeRef);
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        this.treeModel.setNodeHeight(nodeRef, d);
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        this.treeModel.setNodeRate(nodeRef, d);
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        this.treeModel.setBranchLength(nodeRef, d);
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        this.treeModel.setNodeAttribute(nodeRef, string, object);
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
        this.treeModel.addMutableTreeListener(mutableTreeListener);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.treeModel.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        return this.treeModel.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.treeModel.getAttributeNames();
    }

    @Override
    public int addTaxon(Taxon taxon) {
        return this.treeModel.addTaxon(taxon);
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        return this.treeModel.removeTaxon(taxon);
    }

    @Override
    public void setTaxonId(int n, String string) {
        this.treeModel.setTaxonId(n, string);
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        this.treeModel.setTaxonAttribute(n, string, object);
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
        this.treeModel.addMutableTaxonListListener(mutableTaxonListListener);
    }

    @Override
    public int getTaxonCount() {
        return this.treeModel.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.treeModel.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.treeModel.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        return this.treeModel.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        return this.treeModel.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        return this.treeModel.asList();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        return this.treeModel.getTaxonAttribute(n, string);
    }

    @Override
    public Iterator<Taxon> iterator() {
        return this.treeModel.iterator();
    }

    @Override
    public Units.Type getUnits() {
        return this.treeModel.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.treeModel.setUnits(type);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Bayesian estimation of Pagel's lambda";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.VRANCKEN_2015_SIMULTANEOUSLY);
    }

    @Override
    public NodeRef getOriginalNode(NodeRef nodeRef) {
        return nodeRef;
    }

    @Override
    public NodeRef getTransformedNode(NodeRef nodeRef) {
        return nodeRef;
    }

    @Override
    public Tree getOriginalTree() {
        return this.treeModel;
    }
}

