/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.RepeatedMeasuresTraitDataModel;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.inference.model.MatrixParameterInterface;
import dr.math.distributions.WishartSufficientStatistics;
import dr.math.interfaces.ConjugateWishartStatisticsProvider;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class RepeatedMeasuresWishartStatistics
implements ConjugateWishartStatisticsProvider {
    private final RepeatedMeasuresTraitDataModel traitModel;
    private final Tree tree;
    private final TreeTrait tipTrait;
    private final String traitName;
    private final ContinuousExtensionDelegate extensionDelegate;
    private final ContinuousDataLikelihoodDelegate likelihoodDelegate;
    private final double[] outerProduct;
    private final int dimTrait;
    private final int nTaxa;
    private final double[] buffer;
    private boolean forceResample;
    private static final boolean DEBUG = false;
    private static final String RM_WISHART_STATISTICS = "repeatedMeasuresWishartStatistics";
    private static final String FORCE_RESAMPLE = "forceResample";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(RepeatedMeasuresTraitDataModel.class), new ElementRule(TreeDataLikelihood.class), AttributeRule.newBooleanRule("forceResample", true)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            RepeatedMeasuresTraitDataModel repeatedMeasuresTraitDataModel = (RepeatedMeasuresTraitDataModel)xMLObject.getChild(RepeatedMeasuresTraitDataModel.class);
            boolean bl = xMLObject.getAttribute(RepeatedMeasuresWishartStatistics.FORCE_RESAMPLE, true);
            return new RepeatedMeasuresWishartStatistics(repeatedMeasuresTraitDataModel, treeDataLikelihood, bl);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return null;
        }

        @Override
        public String getParserName() {
            return RepeatedMeasuresWishartStatistics.RM_WISHART_STATISTICS;
        }
    };

    public RepeatedMeasuresWishartStatistics(RepeatedMeasuresTraitDataModel repeatedMeasuresTraitDataModel, TreeDataLikelihood treeDataLikelihood, boolean bl) {
        this.traitModel = repeatedMeasuresTraitDataModel;
        this.traitName = repeatedMeasuresTraitDataModel.getTraitName();
        this.tree = treeDataLikelihood.getTree();
        this.tipTrait = treeDataLikelihood.getTreeTrait("tip." + this.traitName);
        this.likelihoodDelegate = (ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate();
        this.extensionDelegate = repeatedMeasuresTraitDataModel.getExtensionDelegate(this.likelihoodDelegate, this.tipTrait, this.tree);
        this.dimTrait = repeatedMeasuresTraitDataModel.getTraitDimension();
        this.nTaxa = this.tree.getExternalNodeCount();
        this.outerProduct = new double[this.dimTrait * this.dimTrait];
        this.buffer = new double[this.nTaxa * this.dimTrait];
        this.forceResample = bl;
    }

    @Override
    public MatrixParameterInterface getPrecisionParameter() {
        return this.traitModel.getExtensionPrecision();
    }

    @Override
    public WishartSufficientStatistics getWishartStatistics() {
        if (this.forceResample) {
            this.likelihoodDelegate.fireModelChanged();
        }
        double[] dArray = (double[])this.tipTrait.getTrait(this.tree, null);
        double[] dArray2 = this.extensionDelegate.getExtendedValues(dArray);
        DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(this.nTaxa, this.dimTrait, this.buffer);
        DenseMatrix64F denseMatrix64F2 = DenseMatrix64F.wrap(this.nTaxa, this.dimTrait, dArray);
        DenseMatrix64F denseMatrix64F3 = DenseMatrix64F.wrap(this.nTaxa, this.dimTrait, dArray2);
        CommonOps.subtract((D1Matrix64F)denseMatrix64F2, (D1Matrix64F)denseMatrix64F3, (D1Matrix64F)denseMatrix64F);
        DenseMatrix64F denseMatrix64F4 = DenseMatrix64F.wrap(this.dimTrait, this.dimTrait, this.outerProduct);
        CommonOps.multTransA(denseMatrix64F, denseMatrix64F, denseMatrix64F4);
        return new WishartSufficientStatistics(this.nTaxa, this.outerProduct);
    }

    public void setForceResample(Boolean bl) {
        this.forceResample = bl;
    }
}

