/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.util.Location;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class LocationParser
extends AbstractXMLObjectParser {
    public static final String DESCRIPTION = "description";
    public static final String LONGITUDE = "longitude";
    public static final String LATITUDE = "latitude";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("description", true, "A description of this location"), AttributeRule.newStringRule("longitude", true, "The longitude in degrees, minutes, seconds or decimal degrees"), AttributeRule.newStringRule("latitude", true, "The latitude in degrees, minutes, seconds or decimal degrees")};

    @Override
    public String getParserName() {
        return "location";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        if (xMLObject.getChildCount() > 0) {
            throw new XMLParseException("No child elements allowed in location element.");
        }
        String string = xMLObject.getAttribute(DESCRIPTION, "");
        double d = this.parseLongLat(xMLObject.getAttribute(LONGITUDE, ""));
        double d2 = this.parseLongLat(xMLObject.getAttribute(LATITUDE, ""));
        return Location.newLocation(xMLObject.getId(), string, d, d2);
    }

    private double parseLongLat(String string) throws XMLParseException {
        double d = 0.0;
        if (string != null && string.length() > 0) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    @Override
    public String getParserDescription() {
        return "Specifies a location with an optional longitude and latitude";
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Class getReturnType() {
        return Location.class;
    }
}

