/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.AbstractPolygon2D;
import dr.geo.Lattice;
import dr.geo.Polygon2D;
import dr.geo.ViewTransform;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.List;

public class KMLRenderer
implements Lattice {
    BufferedImage image;
    int[][] lattice;
    Rectangle2D bounds;
    List<AbstractPolygon2D> polygons;
    List<Shape> shapes;
    ViewTransform viewTransform;
    Color shapeColor;
    Color background;

    public KMLRenderer(String string, Color color, Color color2) {
        this.polygons = Polygon2D.readKMLFile(string);
        this.shapeColor = color;
        this.background = color2;
        System.out.println("Read " + this.polygons.size() + " polygons");
        System.out.println("Converting polygons to shapes");
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        this.shapes = new ArrayList<Shape>();
        for (AbstractPolygon2D abstractPolygon2D : this.polygons) {
            Shape shape = abstractPolygon2D.getShape();
            this.bounds = shape.getBounds();
            if (this.bounds.getMinX() < d) {
                d = this.bounds.getMinX();
            }
            if (this.bounds.getMaxX() > d2) {
                d2 = this.bounds.getMaxX();
            }
            if (this.bounds.getMinY() < d3) {
                d3 = this.bounds.getMinY();
            }
            if (this.bounds.getMaxY() > d4) {
                d4 = this.bounds.getMaxY();
            }
            this.shapes.add(shape);
            System.out.print(".");
            System.out.flush();
        }
        this.bounds = new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        System.out.println();
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public BufferedImage render(int n) {
        int n2;
        int n3;
        if (this.bounds.getHeight() > this.bounds.getWidth()) {
            n3 = n;
            n2 = (int)((double)n3 * this.bounds.getWidth() / this.bounds.getHeight());
        } else {
            n2 = n;
            n3 = (int)((double)n2 * this.bounds.getHeight() / this.bounds.getWidth());
        }
        return this.render(n2, n3);
    }

    public BufferedImage render(int n, int n2) {
        this.image = new BufferedImage(n, n2, 2);
        this.render(this.image);
        Raster raster = this.image.getData();
        this.lattice = new int[n][n2];
        int[] nArray = new int[4];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                raster.getPixel(i, j, nArray);
                this.lattice[i][j] = this.colorDistanceSquared(nArray, this.shapeColor) < this.colorDistanceSquared(nArray, this.background) ? 1 : 0;
            }
        }
        return this.image;
    }

    private double colorDistanceSquared(int[] nArray, Color color) {
        double[] dArray = new double[]{Math.abs(nArray[0] - color.getAlpha()), Math.abs(nArray[1] - color.getRed()), Math.abs(nArray[2] - color.getGreen()), Math.abs(nArray[3] - color.getBlue())};
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2 * d2;
        }
        return d;
    }

    public void render(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(this.background);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.viewTransform = new ViewTransform(this.bounds, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.shapeColor);
        AffineTransform affineTransform = this.viewTransform.getTransform();
        for (Shape shape : this.shapes) {
            GeneralPath generalPath = new GeneralPath(shape);
            generalPath.transform(affineTransform);
            graphics2D.fill(generalPath);
        }
    }

    @Override
    public int latticeWidth() {
        return this.lattice.length;
    }

    @Override
    public int latticeHeight() {
        return this.lattice[0].length;
    }

    public void setState(int n, int n2, int n3) {
        this.lattice[n][n2] = n3;
    }

    @Override
    public int getState(int n, int n2) {
        return this.lattice[n][n2];
    }

    @Override
    public void paintLattice(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }
}

