/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.InverseGaussianDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InverseGaussianDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            System.out.println("just checking if this ever gets used anyways... probably have to change the getLowerBound in LogNormalDistributionModel if it does");
            return InverseGaussianDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Parameter meanParameter;
    private final Parameter stdevParameter;
    private final Parameter shapeParameter;
    private final double offset;

    public InverseGaussianDistributionModel(Parameter parameter, Parameter parameter2, double d, boolean bl) {
        super("inverseGaussianDistributionModel");
        if (bl) {
            this.shapeParameter = parameter2;
            this.stdevParameter = null;
            this.addVariable(this.shapeParameter);
            this.shapeParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        } else {
            this.stdevParameter = parameter2;
            this.shapeParameter = null;
            this.addVariable(this.stdevParameter);
            this.stdevParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        this.meanParameter = parameter;
        this.addVariable(parameter);
        this.offset = d;
        this.meanParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public final double getS() {
        if (this.stdevParameter == null) {
            return Math.sqrt(InverseGaussianDistribution.variance(this.getM(), this.getShape()));
        }
        return this.stdevParameter.getParameterValue(0);
    }

    public final void setS(double d) {
        if (this.stdevParameter == null) {
            throw new RuntimeException("Standard deviation parameter is not being used");
        }
        this.stdevParameter.setParameterValue(0, d);
    }

    public final Parameter getSParameter() {
        if (this.stdevParameter == null) {
            throw new RuntimeException("Standard deviation parameter is not being used");
        }
        return this.stdevParameter;
    }

    public final double getShape() {
        if (this.shapeParameter == null) {
            double d = this.getM() * this.getM() * this.getM() / (this.getS() * this.getS());
            return d;
        }
        return this.shapeParameter.getParameterValue(0);
    }

    public final void setShape(double d) {
        if (this.shapeParameter == null) {
            throw new RuntimeException("Shape parameter is not being used");
        }
        this.shapeParameter.setParameterValue(0, d);
    }

    public final Parameter getShapeParameter() {
        if (this.shapeParameter == null) {
            throw new RuntimeException("Shape parameter is not being used");
        }
        return this.shapeParameter;
    }

    public final double getM() {
        return this.meanParameter.getParameterValue(0);
    }

    public final void setM(double d) {
        this.meanParameter.setParameterValue(0, d);
    }

    public final Parameter getMParameter() {
        return this.meanParameter;
    }

    @Override
    public double pdf(double d) {
        if (d - this.offset <= 0.0) {
            return 0.0;
        }
        return InverseGaussianDistribution.pdf(d - this.offset, this.getM(), this.getShape());
    }

    @Override
    public double logPdf(double d) {
        if (d - this.offset <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return InverseGaussianDistribution.logPdf(d - this.offset, this.getM(), this.getShape());
    }

    @Override
    public double cdf(double d) {
        if (d - this.offset <= 0.0) {
            return 0.0;
        }
        return InverseGaussianDistribution.cdf(d - this.offset, this.getM(), this.getShape());
    }

    @Override
    public double quantile(double d) {
        return InverseGaussianDistribution.quantile(d, this.getM(), this.getShape()) + this.offset;
    }

    @Override
    public double mean() {
        return this.getM() + this.offset;
    }

    @Override
    public double variance() {
        return this.getS() * this.getS();
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

