/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution.shrinkage;

import dr.inference.distribution.shrinkage.BayesianBridgeDistributionModel;
import dr.inference.model.Parameter;
import dr.math.distributions.NormalDistribution;

public class JointBayesianBridgeDistributionModel
extends BayesianBridgeDistributionModel {
    private final Parameter localScale;
    private final Parameter slabWidth;

    public JointBayesianBridgeDistributionModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, int n) {
        super(parameter, parameter3, n);
        this.localScale = parameter2;
        this.slabWidth = parameter4;
        if (n != parameter2.getDimension()) {
            throw new IllegalArgumentException("Invalid dimensions");
        }
        this.addVariable(parameter2);
    }

    @Override
    public Parameter getLocalScale() {
        return this.localScale;
    }

    @Override
    public Parameter getSlabWidth() {
        return this.slabWidth;
    }

    @Override
    double[] gradientLogPdf(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = NormalDistribution.gradLogPdf(dArray[i], 0.0, this.getStandardDeviation(i));
        }
        return dArray2;
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d += NormalDistribution.logPdf(dArray[i], 0.0, this.getStandardDeviation(i));
        }
        return d;
    }

    private double getStandardDeviation(int n) {
        double d = this.globalScale.getParameterValue(0) * this.localScale.getParameterValue(n);
        if (this.slabWidth != null) {
            double d2 = d / this.slabWidth.getParameterValue(0);
            d /= Math.sqrt(1.0 + d2 * d2);
        }
        return d;
    }
}

