/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class BranchParameter
extends Parameter.Abstract
implements VariableListener,
ModelListener {
    private final CompoundParameter parameter;
    private final BranchRateModel branchRateModel;
    private final Parameter rootParameter;
    private final TreeModel tree;
    private final TreeParameterModel indexHelper;

    public BranchParameter(String string, TreeModel treeModel, BranchRateModel branchRateModel, Parameter parameter) {
        super(string);
        this.rootParameter = parameter;
        this.tree = treeModel;
        this.branchRateModel = branchRateModel;
        branchRateModel.addModelListener(this);
        this.parameter = this.constructParameter();
        this.indexHelper = new TreeParameterModel(treeModel, this.parameter, false);
    }

    private CompoundParameter constructParameter() {
        CompoundParameter compoundParameter = new CompoundParameter(this.getId() + ".parameter");
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            if (this.tree.isRoot(this.tree.getNode(i))) continue;
            BranchSpecificProxyParameter branchSpecificProxyParameter = new BranchSpecificProxyParameter(this.branchRateModel, this.tree, i);
            compoundParameter.addParameter(branchSpecificProxyParameter);
        }
        return compoundParameter;
    }

    public Parameter getRootParameter() {
        return this.rootParameter;
    }

    public BranchSpecificProxyParameter getParameter(int n) {
        return (BranchSpecificProxyParameter)this.parameter.getParameter(this.indexHelper.getParameterIndexFromNodeNumber(n));
    }

    public ArbitraryBranchRates.BranchRateTransform getTransform() {
        if (this.branchRateModel instanceof ArbitraryBranchRates) {
            return ((ArbitraryBranchRates)this.branchRateModel).getTransform();
        }
        throw new RuntimeException("Not yet implemented!");
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public double[] getParameterValues() {
        return this.parameter.getParameterValues();
    }

    @Override
    public double getParameterValue(int n) {
        if (n == this.tree.getRoot().getNumber()) {
            return this.rootParameter.getParameterValue(0);
        }
        return this.branchRateModel.getBranchRate(this.tree, this.tree.getNode(this.indexHelper.getNodeNumberFromParameterIndex(n)));
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.parameter.setParameterValue(n, d);
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.parameter.setParameterValueQuietly(n, d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.parameter.setParameterValueNotifyChangedAll(n, d);
    }

    @Override
    public String getParameterName() {
        String string = this.getId();
        if (string == null) {
            string = "BranchParameter." + this.parameter.getParameterName();
        }
        return string;
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        this.parameter.addBounds(bounds);
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.parameter.getBounds();
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Dimension should not be changed.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Dimension should not be changed.");
    }

    @Override
    protected void storeValues() {
        this.parameter.storeParameterValues();
    }

    @Override
    protected void restoreValues() {
        this.parameter.restoreParameterValues();
    }

    @Override
    protected void acceptValues() {
        this.parameter.acceptParameterValues();
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        this.parameter.adoptParameterValues(parameter);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent(n, changeType);
    }

    @Override
    public int getDimension() {
        return this.tree.getNodeCount() - 1;
    }

    public double getChainGradient(Tree tree, NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        this.fireParameterChangedEvent();
    }

    @Override
    public void modelRestored(Model model) {
    }

    private class BranchSpecificProxyParameter
    extends Parameter.Proxy {
        private BranchRateModel branchRateModel;
        private final int nodeNum;
        private Tree tree;

        private BranchSpecificProxyParameter(BranchRateModel branchRateModel, Tree tree, int n) {
            super("BranchSpecificProxyParameter." + Integer.toString(n), 1);
            this.branchRateModel = branchRateModel;
            this.nodeNum = n;
            this.tree = tree;
        }

        @Override
        public double getParameterValue(int n) {
            if (this.tree.isRoot(this.tree.getNode(this.nodeNum))) {
                return BranchParameter.this.rootParameter.getParameterValue(0);
            }
            return this.branchRateModel.getBranchRate(this.tree, this.tree.getNode(this.nodeNum));
        }

        @Override
        public void setParameterValue(int n, double d) {
            if (this.tree.isRoot(this.tree.getNode(this.nodeNum))) {
                BranchParameter.this.rootParameter.setParameterValue(0, d);
            }
        }

        @Override
        public void setParameterValueQuietly(int n, double d) {
            throw new RuntimeException("Not yet implemented!");
        }

        @Override
        public void setParameterValueNotifyChangedAll(int n, double d) {
            throw new RuntimeException("Not yet implemented!");
        }

        @Override
        public void addBounds(Bounds<Double> bounds) {
        }

        @Override
        public Bounds<Double> getBounds() {
            return null;
        }
    }
}

