/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.ThreadAwareLikelihood;
import dr.util.NumberFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class TestThreadedCompoundLikelihood
implements Likelihood {
    public static final boolean DEBUG = false;
    private String id = null;
    private LikelihoodThread[] threads;
    private final ArrayList<Likelihood> likelihoods = new ArrayList();
    private final CompoundModel compoundModel = new CompoundModel("compoundModel");
    private final List<LikelihoodCaller> likelihoodCallers = new ArrayList<LikelihoodCaller>();
    private double weightFactor = 1.0;
    private boolean isUsed = false;

    public TestThreadedCompoundLikelihood() {
    }

    public TestThreadedCompoundLikelihood(List<Likelihood> list) {
        for (Likelihood likelihood : list) {
            this.addLikelihood(likelihood);
        }
    }

    public void addLikelihood(Likelihood likelihood) {
        if (!this.likelihoods.contains(likelihood)) {
            this.likelihoods.add(likelihood);
            if (likelihood.getModel() != null) {
                this.compoundModel.addModel(likelihood.getModel());
            }
            this.likelihoodCallers.add(new LikelihoodCaller(likelihood));
        }
    }

    public int getLikelihoodCount() {
        return this.likelihoods.size();
    }

    public final Likelihood getLikelihood(int n) {
        return this.likelihoods.get(n);
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        HashSet<Likelihood> hashSet = new HashSet<Likelihood>();
        for (Likelihood likelihood : this.likelihoods) {
            hashSet.add(likelihood);
            hashSet.addAll(likelihood.getLikelihoodSet());
        }
        return hashSet;
    }

    @Override
    public Model getModel() {
        return this.compoundModel;
    }

    @Override
    public double getLogLikelihood() {
        int n;
        double d = 0.0;
        if (this.threads == null) {
            this.threads = new LikelihoodThread[this.likelihoodCallers.size()];
            for (n = 0; n < this.threads.length; ++n) {
                this.threads[n] = new LikelihoodThread();
                this.threads[n].start();
            }
        }
        for (n = 0; n < this.threads.length; ++n) {
            LikelihoodCaller likelihoodCaller = this.likelihoodCallers.get(n);
            if (likelihoodCaller.isLikelihoodKnown()) {
                this.threads[n].setReturnValue(likelihoodCaller.call());
                continue;
            }
            this.threads[n].setCaller(likelihoodCaller);
        }
        for (LikelihoodThread likelihoodThread : this.threads) {
            Double d2 = likelihoodThread.getResult();
            while (d2 == null) {
                d2 = likelihoodThread.getResult();
            }
            d += d2.doubleValue();
        }
        return d;
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    @Override
    public void makeDirty() {
        for (Likelihood likelihood : this.likelihoods) {
            likelihood.makeDirty();
        }
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    public String getDiagnosis() {
        String string = "";
        boolean bl = true;
        for (Likelihood likelihood : this.likelihoods) {
            Object object;
            if (!bl) {
                string = string + ", ";
            } else {
                bl = false;
            }
            String string2 = likelihood.getId();
            if (string2 == null || string2.trim().length() == 0) {
                object = likelihood.getClass().getName().split("\\.");
                string2 = object[((String[])object).length - 1];
            }
            string = string + string2 + "=";
            if (likelihood instanceof TestThreadedCompoundLikelihood) {
                object = ((TestThreadedCompoundLikelihood)likelihood).getDiagnosis();
                if (object == null || ((String)object).length() <= 0) continue;
                string = string + "(" + (String)object + ")";
                continue;
            }
            if (likelihood.getLogLikelihood() == Double.NEGATIVE_INFINITY) {
                string = string + "-Inf";
                continue;
            }
            if (Double.isNaN(likelihood.getLogLikelihood())) {
                string = string + "NaN";
                continue;
            }
            object = new NumberFormatter(6);
            string = string + ((NumberFormatter)object).formatDecimal(likelihood.getLogLikelihood(), 4);
        }
        return string;
    }

    public String toString() {
        return Double.toString(this.getLogLikelihood());
    }

    public void setWeightFactor(double d) {
        this.weightFactor = d;
    }

    public double getWeightFactor() {
        return this.weightFactor;
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId())};
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isUsed() {
        return this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
        for (Likelihood likelihood : this.likelihoods) {
            likelihood.setUsed();
        }
    }

    class LikelihoodThread
    extends Thread {
        private LikelihoodCaller caller = null;
        private Double result = Double.NaN;
        private boolean resultAvailable = false;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();

        public void setCaller(LikelihoodCaller likelihoodCaller) {
            this.lock.lock();
            this.resultAvailable = false;
            try {
                this.caller = likelihoodCaller;
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void run() {
            while (true) {
                this.lock.lock();
                try {
                    while (this.caller == null) {
                        this.condition.await();
                    }
                    this.result = this.caller.call();
                    this.resultAvailable = true;
                    this.caller = null;
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        public Double getResult() {
            Double d = null;
            if (!this.lock.isLocked() && this.resultAvailable) {
                this.resultAvailable = false;
                d = this.result;
            }
            return d;
        }

        public void setReturnValue(double d) {
            this.result = d;
            this.resultAvailable = true;
        }
    }

    class LikelihoodCaller {
        private final Likelihood likelihood;

        public LikelihoodCaller(Likelihood likelihood) {
            this.likelihood = likelihood;
        }

        public double call() {
            return this.likelihood.getLogLikelihood();
        }

        public boolean isLikelihoodKnown() {
            return this.likelihood instanceof ThreadAwareLikelihood && ((ThreadAwareLikelihood)((Object)this.likelihood)).isLikelihoodKnown();
        }
    }

    private class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return TestThreadedCompoundLikelihood.this.getLogLikelihood();
        }
    }
}

