/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Likelihood;
import dr.inference.operators.MCMCOperator;
import java.util.ArrayDeque;
import java.util.Deque;

public abstract class SimpleMCMCOperator
implements MCMCOperator {
    private static final int SMOOTHED_ACCEPTANCE_WINDOW_SIZE = 100;
    private double weight = 1.0;
    private long acceptCount = 0L;
    private long rejectCount = 0L;
    private double sumDeviation = 0.0;
    private double lastDeviation = 0.0;
    private boolean operateAllowed = true;
    private long sumEvaluationTime = 0L;
    private long sumCalculationCount = 0L;
    private Deque<Integer> windowAcceptance = new ArrayDeque<Integer>();

    @Override
    public abstract String getOperatorName();

    public SimpleMCMCOperator() {
    }

    public SimpleMCMCOperator(double d) {
        this.weight = d;
    }

    @Override
    public final double getWeight() {
        return this.weight;
    }

    public void setPathParameter(double d) {
        throw new IllegalArgumentException("Path parameter has no effect on Metropolis-Hastings kernels.\nGibbs samplers need an implementation for use in power-posteriors");
    }

    @Override
    public final void setWeight(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("Weight must be a positive real, but tried to set weight to " + d);
        }
        this.weight = d;
    }

    @Override
    public void accept(double d) {
        this.lastDeviation = d;
        if (!this.operateAllowed) {
            this.operateAllowed = true;
            ++this.acceptCount;
            this.sumDeviation += d;
            this.windowAcceptance.addLast(1);
            if (this.windowAcceptance.size() > 100) {
                this.windowAcceptance.removeFirst();
            }
        } else {
            throw new RuntimeException("Accept/reject methods called twice without operate called in between!");
        }
    }

    @Override
    public void reject() {
        if (!this.operateAllowed) {
            this.operateAllowed = true;
            ++this.rejectCount;
            this.windowAcceptance.addLast(0);
            if (this.windowAcceptance.size() > 100) {
                this.windowAcceptance.removeFirst();
            }
        } else {
            throw new RuntimeException("Accept/reject methods called twice without operate called in between!");
        }
    }

    @Override
    public void reset() {
        this.operateAllowed = true;
        this.acceptCount = 0L;
        this.rejectCount = 0L;
        this.lastDeviation = 0.0;
        this.sumDeviation = 0.0;
        this.windowAcceptance.clear();
    }

    @Override
    public final long getCount() {
        return this.acceptCount + this.rejectCount;
    }

    @Override
    public final long getAcceptCount() {
        return this.acceptCount;
    }

    @Override
    public final void setAcceptCount(long l) {
        this.acceptCount = l;
    }

    @Override
    public final long getRejectCount() {
        return this.rejectCount;
    }

    @Override
    public final void setRejectCount(long l) {
        this.rejectCount = l;
    }

    @Override
    public final double getMeanDeviation() {
        return this.sumDeviation / (double)this.acceptCount;
    }

    public final double getDeviation() {
        return this.lastDeviation;
    }

    @Override
    public final double getSumDeviation() {
        return this.sumDeviation;
    }

    @Override
    public final void setSumDeviation(double d) {
        this.sumDeviation = d;
    }

    @Override
    public final double operate() {
        if (this.operateAllowed) {
            this.operateAllowed = false;
            return this.doOperation();
        }
        throw new RuntimeException("Operate called twice without accept/reject in between!");
    }

    public final double operate(Likelihood likelihood) {
        if (this.operateAllowed) {
            this.operateAllowed = false;
            return this.doOperation(likelihood);
        }
        throw new RuntimeException("Operate called twice without accept/reject in between!");
    }

    @Override
    public final double getAcceptanceProbability() {
        return (double)this.acceptCount / (double)(this.acceptCount + this.rejectCount);
    }

    @Override
    public final double getSmoothedAcceptanceProbability() {
        int n = 0;
        for (int n2 : this.windowAcceptance) {
            n += n2;
        }
        return (double)n / (double)this.windowAcceptance.size();
    }

    public double doOperation(Likelihood likelihood) {
        return 0.0;
    }

    @Override
    public double getMeanEvaluationTime() {
        return (double)this.sumEvaluationTime / (double)(this.acceptCount + this.rejectCount);
    }

    @Override
    public long getTotalEvaluationTime() {
        return this.sumEvaluationTime;
    }

    @Override
    public void addEvaluationTime(long l) {
        this.sumEvaluationTime += l;
    }

    @Override
    public double getMeanCalculationCount() {
        return (double)this.sumCalculationCount / (double)(this.acceptCount + this.rejectCount);
    }

    @Override
    public void addCalculationCount(long l) {
        this.sumCalculationCount += l;
    }

    @Override
    public long getTotalCalculationCount() {
        return this.sumCalculationCount;
    }

    public abstract double doOperation();
}

