/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.GammaFunction;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class TDistribution
implements Distribution,
GradientProvider {
    private double df;
    private double scale;
    private double center;
    private static double logSqrtPi = Math.log(Math.sqrt(Math.PI));

    public TDistribution(double d, double d2, double d3) {
        this.center = d;
        this.scale = d2;
        this.df = d3;
    }

    @Override
    public double pdf(double d) {
        return Math.exp(TDistribution.logPDF(d, this.center, this.scale, this.df));
    }

    @Override
    public double logPdf(double d) {
        return TDistribution.logPDF(d, this.center, this.scale, this.df);
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mean() {
        if (this.df > 1.0) {
            return this.center;
        }
        return Double.NaN;
    }

    @Override
    public double variance() {
        if (this.df > 2.0) {
            return this.scale * this.df / (this.df - 2.0);
        }
        return Double.NaN;
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented");
    }

    public static double logPDF(double d, double d2, double d3, double d4) {
        double d5 = d - d2;
        double d6 = GammaFunction.lnGamma((d4 + 1.0) / 2.0) - 0.5 * Math.log(d4) - logSqrtPi - 0.25 * Math.log(d3) - GammaFunction.lnGamma(d4 / 2.0) - (d4 + 1.0) / 2.0 * Math.log(1.0 + d5 * d5 / d4 / d3);
        return d6;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = TDistribution.gradLogPdf(dArray[i], this.center, this.scale, this.df);
        }
        return dArray2;
    }

    public static double gradLogPdf(double d, double d2, double d3, double d4) {
        double d5 = d - d2;
        return -(d4 + 1.0) * d5 / (d4 * d3 + d5 * d5);
    }
}

