/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.sitemodel.CategorySampleModel;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModel;
import dr.oldevomodel.substmodel.YangCodonModel;
import java.util.Vector;

public class SampleStateAndCategoryModel
extends AbstractModel
implements SiteModel,
CategorySampleModel {
    public static final double OMEGA_MAX_VALUE = 100.0;
    public static final double OMEGA_MIN_VALUE = 0.0;
    private final Parameter muParameter;
    private final int[] sitesInCategory;
    private final Parameter categoriesParameter;
    private final Vector substitutionModels;
    private final int categoryCount;

    public SampleStateAndCategoryModel(Parameter parameter, Parameter parameter2, Vector vector) {
        super("sampleStateAndCategoryModel");
        int n;
        this.substitutionModels = vector;
        for (n = 0; n < vector.size(); ++n) {
            this.addModel((SubstitutionModel)vector.elementAt(n));
        }
        this.categoryCount = vector.size();
        this.sitesInCategory = new int[this.categoryCount];
        this.muParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(1000.0, 0.0, 1));
        this.categoriesParameter = parameter2;
        this.addVariable(parameter2);
        if (this.categoryCount > 1) {
            for (n = 0; n < this.categoryCount; ++n) {
                Parameter parameter3 = (Parameter)((YangCodonModel)vector.elementAt(n)).getVariable(0);
                Parameter parameter4 = null;
                Parameter parameter5 = null;
                if (n == 0) {
                    parameter5 = (Parameter)((YangCodonModel)vector.elementAt(n + 1)).getVariable(0);
                    parameter3.addBounds(new omegaBounds(parameter4, parameter5));
                    continue;
                }
                if (n == this.categoryCount - 1) {
                    parameter4 = (Parameter)((YangCodonModel)vector.elementAt(n - 1)).getVariable(0);
                    parameter3.addBounds(new omegaBounds(parameter4, parameter5));
                    continue;
                }
                parameter5 = (Parameter)((YangCodonModel)vector.elementAt(n + 1)).getVariable(0);
                parameter4 = (Parameter)((YangCodonModel)vector.elementAt(n - 1)).getVariable(0);
                parameter3.addBounds(new omegaBounds(parameter4, parameter5));
            }
        }
    }

    @Override
    public SubstitutionModel getSubstitutionModel() {
        return null;
    }

    @Override
    public boolean integrateAcrossCategories() {
        return false;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public int getCategoryOfSite(int n) {
        return (int)this.categoriesParameter.getParameterValue(n);
    }

    @Override
    public double getRateForCategory(int n) {
        throw new RuntimeException("getRateForCategory not available in this siteModel");
    }

    @Override
    public double[] getCategoryRates() {
        throw new RuntimeException("getCategoryRates not available in this siteModel");
    }

    public double getSubstitutionsForCategory(int n, double d) {
        throw new RuntimeException("getSubstitutionsForCategory not available in this siteModel");
    }

    public void getTransitionProbabilities(double d, double[] dArray) {
        throw new RuntimeException("getTransitionProbabilities not available in this siteModel");
    }

    @Override
    public FrequencyModel getFrequencyModel() {
        return ((SubstitutionModel)this.substitutionModels.elementAt(0)).getFrequencyModel();
    }

    @Override
    public void setCategoriesParameter(int n) {
        int n2;
        int n3;
        this.categoriesParameter.setDimension(n);
        this.categoriesParameter.addBounds(new Parameter.DefaultBounds(this.categoryCount, 0.0, n));
        for (n3 = 0; n3 < n; ++n3) {
            n2 = (int)(Math.random() * (double)this.categoryCount);
            this.categoriesParameter.setParameterValue(n3, n2);
        }
        for (n3 = 0; n3 < this.categoryCount; ++n3) {
            this.sitesInCategory[n3] = 0;
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = (int)this.categoriesParameter.getParameterValue(n3);
            this.sitesInCategory[n2] = this.sitesInCategory[n2] + 1;
        }
    }

    @Override
    public void addSitesInCategoryCount(int n) {
        this.sitesInCategory[n] = this.sitesInCategory[n] + 1;
    }

    @Override
    public void subtractSitesInCategoryCount(int n) {
        this.sitesInCategory[n] = this.sitesInCategory[n] - 1;
    }

    @Override
    public int getSitesInCategoryCount(int n) {
        return this.sitesInCategory[n];
    }

    @Override
    public void toggleRandomSite() {
    }

    @Override
    public double getProportionForCategory(int n) {
        throw new IllegalArgumentException("Not integrating across categories");
    }

    @Override
    public double[] getCategoryProportions() {
        throw new IllegalArgumentException("Not integrating across categories");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.categoriesParameter) {
            this.listenerHelper.fireModelChanged(this, this, n);
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.categoryCount; ++i) {
            stringBuffer.append(this.sitesInCategory[i] + "\t");
        }
        return stringBuffer.toString();
    }

    private class omegaBounds
    implements Bounds<Double> {
        private final Parameter lowerOmega;
        private final Parameter upperOmega;

        public omegaBounds(Parameter parameter, Parameter parameter2) {
            this.lowerOmega = parameter;
            this.upperOmega = parameter2;
        }

        public omegaBounds(Parameter parameter, boolean bl) {
            if (bl) {
                this.lowerOmega = parameter;
                this.upperOmega = null;
            } else {
                this.lowerOmega = null;
                this.upperOmega = parameter;
            }
        }

        @Override
        public Double getUpperLimit(int n) {
            if (n != 0) {
                throw new RuntimeException("omega parameters have wrong dimension " + n);
            }
            if (this.upperOmega == null) {
                return 100.0;
            }
            return this.upperOmega.getParameterValue(n);
        }

        @Override
        public Double getLowerLimit(int n) {
            if (n != 0) {
                throw new RuntimeException("omega parameters have wrong dimension " + n);
            }
            if (this.lowerOmega == null) {
                return 0.0;
            }
            return this.lowerOmega.getParameterValue(n);
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }
}

