/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.OldHiddenNucleotides;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.AbstractCovarionDNAModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModelUtils;

public class CovarionHKY
extends AbstractCovarionDNAModel {
    private Parameter kappaParameter;

    public CovarionHKY(OldHiddenNucleotides oldHiddenNucleotides, Parameter parameter, Parameter parameter2, Parameter parameter3, FrequencyModel frequencyModel) {
        super("CovarionHKYModel", oldHiddenNucleotides, parameter2, parameter3, frequencyModel);
        this.kappaParameter = parameter;
        this.addVariable(parameter);
        this.setupRelativeRates();
    }

    @Override
    double[] getRelativeDNARates() {
        double d = this.kappaParameter.getParameterValue(0);
        return new double[]{1.0, d, 1.0, 1.0, d, 1.0};
    }

    public void setKappa(double d) {
        this.kappaParameter.setParameterValue(0, d);
    }

    public double getKappa() {
        return this.kappaParameter.getParameterValue(0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Covarion HKY model with ");
        stringBuilder.append(this.getHiddenClassCount()).append(" rate classes.\n");
        stringBuilder.append("Relative rates: \n");
        stringBuilder.append(SubstitutionModelUtils.toString(this.relativeRates, this.dataType, true, 2));
        return stringBuilder.toString();
    }
}

