/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.LowerTriangPackMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UnitLowerTriangPackMatrix
extends LowerTriangPackMatrix {
    public UnitLowerTriangPackMatrix(int n) {
        super(n, BLASkernel.Diag.Unit);
    }

    public UnitLowerTriangPackMatrix(Matrix A) {
        this(A, true);
    }

    public UnitLowerTriangPackMatrix(Matrix A, boolean deep) {
        super(A, deep, BLASkernel.Diag.Unit);
    }

    public void add(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.add(row, column, value);
    }

    public double get(int row, int column) {
        if (column == row) {
            return 1.0;
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.set(row, column, value);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() <= e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public UnitLowerTriangPackMatrix copy() {
        return new UnitLowerTriangPackMatrix(this);
    }
}

