/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AEAggregate
extends AEUnaryRelationalExpr {
    private AEValueExprList m_groupingList = null;
    private Map<Integer, Integer> m_groupingListOrdinals;
    private AEValueExprList m_aggregateList;
    private AEQueryScope m_queryScope;

    public AEAggregate(AERelationalExpr aERelationalExpr, AEValueExprList aEValueExprList, Map<Integer, Integer> map, AEValueExprList aEValueExprList2, AEQueryScope aEQueryScope) {
        super(aERelationalExpr);
        assert (aEValueExprList2 != null);
        if (aEValueExprList != null) {
            this.m_groupingList = aEValueExprList;
            this.m_groupingList.setParent(this);
        }
        this.m_aggregateList = aEValueExprList2;
        this.m_aggregateList.setParent(this);
        this.m_groupingListOrdinals = map;
        this.m_queryScope = aEQueryScope;
    }

    private AEAggregate(AEAggregate aEAggregate) {
        super(aEAggregate);
        AEValueExprList aEValueExprList = this.m_groupingList = aEAggregate.hasGroupingList() ? aEAggregate.m_groupingList.copy() : null;
        if (null != this.m_groupingList) {
            this.m_groupingList.setParent(this);
        }
        this.m_aggregateList = aEAggregate.m_aggregateList.copy();
        this.m_aggregateList.setParent(this);
        if (null != aEAggregate.m_groupingListOrdinals) {
            this.m_groupingListOrdinals = new HashMap<Integer, Integer>(aEAggregate.m_groupingListOrdinals);
        }
        this.m_queryScope = aEAggregate.m_queryScope;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public int getColumnCount() {
        return this.m_aggregateList.getNumChildren();
    }

    @Override
    public IColumn getColumn(int n) {
        return ((AEValueExpr)this.m_aggregateList.getChild(n)).getColumn();
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (iAENode == this) {
            return true;
        }
        if (!(iAENode instanceof AEAggregate)) {
            return false;
        }
        AEAggregate aEAggregate = (AEAggregate)iAENode;
        if (this.hasGroupingList() ? !aEAggregate.hasGroupingList() || !this.m_groupingList.isEquivalent(aEAggregate.m_groupingList) : aEAggregate.hasGroupingList()) {
            return false;
        }
        return this.getOperand().isEquivalent(aEAggregate.getOperand()) && this.m_aggregateList.isEquivalent(aEAggregate.m_aggregateList);
    }

    @Override
    public int getNumChildren() {
        if (this.hasGroupingList()) {
            return 3;
        }
        return 2;
    }

    @Override
    public AEAggregate copy() {
        return new AEAggregate(this);
    }

    public boolean hasGroupingList() {
        return this.m_groupingList != null;
    }

    @Override
    protected IAENode getChild(int n) {
        switch (n) {
            case 0: {
                return this.getOperand();
            }
            case 1: {
                return this.m_aggregateList;
            }
            case 2: {
                if (this.hasGroupingList()) {
                    return this.m_groupingList;
                }
                throw new IndexOutOfBoundsException();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public AEValueExprList getGroupingList() {
        return this.m_groupingList;
    }

    public AEValueExprList getAggregationList() {
        return this.m_aggregateList;
    }

    public AEQueryScope getQueryScope() {
        return this.m_queryScope;
    }

    public Map<Integer, Integer> getGroupingListOrdinalMap() {
        return this.m_groupingListOrdinals;
    }

    @Override
    public boolean getDataNeeded(int n) {
        if (this.m_shouldUpdateDNTracker) {
            this.m_dataNeeded = new boolean[this.m_aggregateList.getNumChildren()];
            this.m_shouldUpdateDNTracker = false;
        }
        return this.m_dataNeeded[n];
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        if (this.m_shouldUpdateDNTracker) {
            this.m_dataNeeded = new boolean[this.m_aggregateList.getNumChildren()];
            this.m_shouldUpdateDNTracker = false;
        }
        if (aERelationalExpr.equals(this)) {
            this.m_dataNeeded[n] = true;
            SetDataNeededVisitor setDataNeededVisitor = new SetDataNeededVisitor();
            ((AEValueExpr)this.m_aggregateList.getChild(n)).acceptVisitor(setDataNeededVisitor);
            return n;
        }
        this.getOperand().setDataNeeded(aERelationalExpr, n);
        return -1;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
        SetDataNeededVisitor setDataNeededVisitor = new SetDataNeededVisitor();
        if (null != this.m_groupingList) {
            this.m_groupingList.acceptVisitor(setDataNeededVisitor);
        }
        this.getOperand().setDataNeededOnChild();
    }

    private class SetDataNeededVisitor
    extends AEDefaultVisitor<Void> {
        private SetDataNeededVisitor() {
        }

        @Override
        public Void visit(AEColumnReference aEColumnReference) throws ErrorException {
            if (!aEColumnReference.isOuterReference()) {
                AEAggregate.this.getOperand().setDataNeeded(aEColumnReference.getNamedRelationalExpr(), aEColumnReference.getColumnNum());
            } else {
                aEColumnReference.getNamedRelationalExpr().setDataNeeded(aEColumnReference.getNamedRelationalExpr(), aEColumnReference.getColumnNum());
            }
            return null;
        }

        @Override
        public Void visit(AEProxyColumn aEProxyColumn) throws ErrorException {
            assert (AEAggregate.this.equals(aEProxyColumn.getRelationalExpr()));
            AEAggregate.this.setDataNeeded(aEProxyColumn.getRelationalExpr(), aEProxyColumn.getColumnNumber());
            return null;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) throws ErrorException {
            Iterator<? extends IAENode> iterator = iAENode.getChildItr();
            while (iterator.hasNext()) {
                iterator.next().acceptVisitor(this);
            }
            return null;
        }
    }
}

