/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CPlsqlBooleanAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleTypeADT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CStatement
extends OracleStatement {
    static final byte[][][] parameterDatum = null;
    static final OracleTypeADT[][] parameterOtype = null;
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    final String[] nlsStrings = new String[]{"AUTH_NLS_LXLAN", "AUTH_NLS_LXCTERRITORY", "AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", "AUTH_NLS_LXCUNIONCUR", "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_TIME_ZONE", "AL8KW_ENABLED_ROLES", "AL8KW_ERR_OVLAP", "AL8KW_EDITION", "AL8KW_AUX_SESSSTATE"};

    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SQLException, IOException {
        this.doOall8(bl, bl2, bl3, bl4, bl5, 0);
    }

    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) throws SQLException, IOException {
        int n3;
        int n4;
        int n5;
        if (bl || bl4 || !bl2) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.doOall8");
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            throw (SQLException)DatabaseError.createSqlException(439, "sqlKind = " + (Object)((Object)this.sqlKind)).fillInStackTrace();
        }
        int n6 = this.rowPrefetch;
        if (bl3) {
            if (this.maxRows > 0L && this.maxRows <= this.indexOfFirstRow + (long)(this.storedRowCount + this.rowPrefetch)) {
                n6 = (int)(this.maxRows - (this.indexOfFirstRow + (long)this.storedRowCount));
                this.isAllFetched = true;
            }
            this.rowPrefetchInLastFetch = n6;
            if (n6 == 0 && this.isAllFetched) {
                return;
            }
        }
        int n7 = this.numberOfDefinePositions;
        if (this.sqlKind.isDML()) {
            n7 = 0;
        }
        if (this.accessors != null) {
            for (n5 = 0; n5 < this.accessors.length; ++n5) {
                if (this.accessors[n5] == null) continue;
                this.accessors[n5].lastRowProcessed = n2;
            }
        }
        if (this.outBindAccessors != null) {
            for (n5 = 0; n5 < this.outBindAccessors.length; ++n5) {
                if (this.outBindAccessors[n5] == null) continue;
                this.outBindAccessors[n5].lastRowProcessed = 0;
            }
        }
        if (this.bindIndicators != null) {
            n5 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int n8 = 0;
            if (this.ibtBindChars != null) {
                n8 = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int n9 = this.bindIndicatorSubRange + 5 + 10 * i2;
                n4 = this.bindIndicators[n9 + 2] & 0xFFFF;
                if (n4 == 0) continue;
                n3 = this.bindIndicators[n9 + 9] & 0xFFFF;
                if (this.bindUseDBA) continue;
                n8 = n3 == 2 ? Math.max(n4 * this.connection.conversion.maxNCharSize, n8) : Math.max(n4 * this.connection.conversion.cMaxCharSize, n8);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[n8];
            } else if (this.tmpBindsByteArray.length < n8) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[n8];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        int[] nArray = this.definedColumnType;
        int[] nArray2 = this.definedColumnSize;
        int[] nArray3 = this.definedColumnFormOfUse;
        if (bl5 && bl4 && this.isRowidPrepended) {
            nArray = new int[this.definedColumnType.length + 1];
            System.arraycopy(this.definedColumnType, 0, nArray, 1, this.definedColumnType.length);
            nArray[0] = -8;
            nArray2 = new int[this.definedColumnSize.length + 1];
            System.arraycopy(this.definedColumnSize, 0, nArray2, 1, this.definedColumnSize.length);
            nArray3 = new int[this.definedColumnFormOfUse.length + 1];
            System.arraycopy(this.definedColumnFormOfUse, 0, nArray3, 1, this.definedColumnFormOfUse.length);
        }
        this.allocateTmpByteArray();
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        try {
            t4C8Oall.doOALL(bl, bl2, bl3, bl4, bl5, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), n6, this.outBindAccessors, this.numberOfBindPositions, this.accessors, n7, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, nArray, nArray2, nArray3, this.registration, this.bindData, this.bindDataOffsets, this.bindDataLengths, this.bindUseDBA);
            n4 = t4C8Oall.getCursorId();
            if (n4 != 0) {
                this.setCursorId(n4);
            }
            this.oacdefSent = t4C8Oall.oacdefBindsSent;
            if (this.connection.isPDBChanged) {
                this.connection.onPDBChange(this);
                this.connection.isPDBChanged = false;
            }
        }
        catch (SQLException sQLException) {
            n3 = t4C8Oall.getCursorId();
            if (n3 != 0) {
                this.setCursorId(n3);
            }
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void allocateTmpByteArray() {
        block1: {
            block0: {
                if (this.tmpByteArray != null) break block0;
                this.tmpByteArray = new byte[this.sizeTmpByteArray];
                break block1;
            }
            if (this.sizeTmpByteArray <= this.tmpByteArray.length) break block1;
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    @Override
    void releaseBuffers() {
        super.releaseBuffers();
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        if (this.t4Connection != null) {
            this.t4Connection.all8.bindChars = null;
            this.t4Connection.all8.bindBytes = null;
            this.t4Connection.all8.tmpBindsByteArray = null;
        }
    }

    @Override
    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    @Override
    protected void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n3 == -15 || n3 == -9 || n3 == -16) {
            s2 = (short)2;
        }
        if (n2 < 1) {
            throw (SQLException)DatabaseError.createSqlException(3).fillInStackTrace();
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            throw (SQLException)DatabaseError.createSqlException(28).fillInStackTrace();
        }
        int n5 = n2 - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n5) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n5] = n3;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n5) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        int n6 = this.definedColumnSize[n5] = n3 == 2005 || n3 == 2004 ? n4 : -1;
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= n5) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = nArray;
            }
        }
        this.definedColumnFormOfUse[n5] = s2;
        this.executeDoneForDefines = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.clearDefines();
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            if (this.t4Connection != null && this.t4Connection.all8 != null) {
                this.t4Connection.all8.definesAccessors = null;
            }
        }
    }

    @Override
    void doSetSnapshotSCN(long l2) throws SQLException {
        this.inScn = l2;
    }

    @Override
    protected void configureRowData() {
        this.bindData = this.rowData = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
        this.bindUseDBA = this.connection.bindUseDBA;
    }

    @Override
    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        Accessor accessor = null;
        switch (n2) {
            case 96: {
                accessor = new T4CCharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!bl) {
                    accessor = new T4CLongAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                accessor = new T4CVarcharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 2: {
                accessor = new T4CNumberAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 6: {
                accessor = new T4CVarnumAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 252: {
                accessor = new T4CPlsqlBooleanAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!bl) {
                    accessor = new T4CLongRawAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (bl && string != null) {
                    throw (SQLException)DatabaseError.createSqlException(12, "sqlType=" + n3).fillInStackTrace();
                }
                if (bl) {
                    accessor = new T4COutRawAccessor(this, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CRawAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 100: {
                accessor = new T4CBinaryFloatAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 101: {
                accessor = new T4CBinaryDoubleAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 104: 
            case 208: {
                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK || this.sqlObject.returningIntoParameterCount > 0) {
                    accessor = new T4CVarcharAccessor(this, 18, s2, n3, bl, this.t4Connection.mare);
                    accessor.definedColumnType = -8;
                    break;
                }
                accessor = new T4CRowidAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 102: {
                accessor = new T4CResultSetAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 12: {
                accessor = new T4CDateAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 113: {
                accessor = new T4CBlobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 112: {
                accessor = new T4CClobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 114: {
                accessor = new T4CBfileAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 109: {
                accessor = new T4CNamedTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 111: {
                accessor = new T4CRefTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 180: {
                accessor = new T4CTimestampAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 181: {
                accessor = new T4CTimestamptzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 231: {
                accessor = new T4CTimestampltzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 182: {
                accessor = new T4CIntervalymAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 183: {
                accessor = new T4CIntervaldsAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 995: {
                throw (SQLException)DatabaseError.createSqlException(89).fillInStackTrace();
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1)).fillInStackTrace();
            }
        }
        return accessor;
    }

    @Override
    void doDescribe(boolean bl) throws SQLException {
        if (!this.isOpen) {
            throw (SQLException)DatabaseError.createSqlException(144).fillInStackTrace();
        }
        try {
            this.t4Connection.needLine();
            this.t4Connection.describe.doODNY(this, 0, this.accessors, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals));
            this.accessors = this.t4Connection.describe.getAccessors();
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        this.describedWithNames = true;
        this.described = true;
    }

    @Override
    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.execute_for_describe");
        try {
            this.doOall8(true, true, this.definedColumnType != null, true, this.definedColumnType != null);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        finally {
            this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
            this.validRows = this.t4Connection.all8.getNumRows();
            if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
                if (this.validRows > 0L) {
                    this.calculateCheckSum();
                } else if (this.rowsProcessed > 0L) {
                    long l2;
                    this.checkSum = l2 = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
                }
            }
        }
        this.needToParse = false;
        if (this.definedColumnType == null) {
            this.implicitDefineForLobPrefetchDone = false;
        }
        this.aFetchWasDoneDuringDescribe = false;
        if (this.t4Connection.all8.aFetchWasDone) {
            this.aFetchWasDoneDuringDescribe = true;
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            this.accessors[i2].initMetadata();
        }
        this.needToPrepareDefineBuffer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean bl) throws SQLException {
        try {
            try {
                boolean bl2 = false;
                if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = false;
                } else if (this.t4Connection.useLobPrefetch && this.accessors != null && this.defaultLobPrefetchSize != -1 && !this.implicitDefineForLobPrefetchDone && !this.aFetchWasDoneDuringDescribe && this.definedColumnType == null) {
                    boolean bl3 = false;
                    int[] nArray = new int[this.accessors.length];
                    int[] nArray2 = new int[this.accessors.length];
                    int[] nArray3 = new int[this.accessors.length];
                    for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                        if (this.accessors[i2] == null) continue;
                        nArray[i2] = this.getJDBCType(this.accessors[i2].internalType);
                        nArray3[i2] = this.accessors[i2].formOfUse;
                        if (this.accessors[i2].internalType != 113 && this.accessors[i2].internalType != 112 && this.accessors[i2].internalType != 114) continue;
                        bl3 = true;
                        this.accessors[i2].setPrefetchLength(this.defaultLobPrefetchSize);
                        nArray2[i2] = this.defaultLobPrefetchSize;
                    }
                    if (bl3) {
                        this.definedColumnType = nArray;
                        this.definedColumnSize = nArray2;
                        this.definedColumnFormOfUse = nArray3;
                        bl2 = true;
                    }
                }
                this.doOall8(this.needToParse, !bl, true, false, bl2);
                this.needToParse = false;
                if (bl2) {
                    this.implicitDefineForLobPrefetchDone = true;
                }
            }
            finally {
                this.validRows = this.implicitResultSetStatements == null ? this.t4Connection.all8.getNumRows() : 0L;
                this.calculateCheckSum();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    @Override
    protected void fetch(int n2, boolean bl) throws SQLException {
        if (this.rowData != null) {
            if (bl) {
                this.rowData.setPosition(this.rowData.length());
            } else if (this.bindUseDBA) {
                this.rowData.setPosition(this.beyondBindData);
            } else {
                this.rowData.reset();
            }
        }
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        boolean bl2 = false;
        if (this.t4Connection.useLobPrefetch && this.accessors != null && this.defaultLobPrefetchSize != -1 && !this.implicitDefineForLobPrefetchDone && !this.aFetchWasDoneDuringDescribe && this.definedColumnType == null) {
            boolean bl3 = false;
            int[] nArray = new int[this.accessors.length];
            int[] nArray2 = new int[this.accessors.length];
            int[] nArray3 = new int[this.accessors.length];
            for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                if (this.accessors[i2] == null) continue;
                nArray[i2] = this.getJDBCType(this.accessors[i2].internalType);
                nArray3[i2] = this.accessors[i2].formOfUse;
                if (this.accessors[i2].internalType != 113 && this.accessors[i2].internalType != 112 && this.accessors[i2].internalType != 114) continue;
                bl3 = true;
                this.accessors[i2].setPrefetchLength(this.defaultLobPrefetchSize);
                nArray2[i2] = this.defaultLobPrefetchSize;
            }
            if (bl3) {
                this.definedColumnType = nArray;
                this.definedColumnSize = nArray2;
                this.definedColumnFormOfUse = nArray3;
                bl2 = true;
            }
        }
        try {
            this.doOall8(false, false, true, false, bl2, n2);
            if (bl2) {
                this.implicitDefineForLobPrefetchDone = true;
            }
            this.validRows = this.t4Connection.all8.getNumRows();
            if (this.validRows != -2L) {
                this.validRows -= (long)n2;
            }
            this.calculateCheckSum();
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    @Override
    void continueReadRow(int n2) throws SQLException {
        try {
            if (!this.isFetchStreams) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n2, this);
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.do_close");
        if (this.cursorId != 0) {
            this.t4Connection.closeCursor(this.cursorId);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    @Override
    void closeQuery() throws SQLException {
        this.connection.registerHeartbeat();
        this.connection.needLine();
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        if (!this.isAllFetched && this.cursorId != 0) {
            this.t4Connection.closeQuery(this.cursorId);
        }
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
        } else {
            this.md.reset();
        }
        if (this.maxRows > 0L) {
            return null;
        }
        for (String string : this.nlsStrings) {
            String string2 = (String)this.connection.sessionProperties.get(string);
            if (string2 == null) continue;
            this.md.update(string2.getBytes());
        }
        if (this.t4Connection.currentSchema != null) {
            this.md.update(this.t4Connection.currentSchema.getBytes());
        }
        this.runtimeKey = this.md.digest();
        return this.runtimeKey;
    }

    T4CStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        super(physicalConnection, 1, physicalConnection.defaultRowPrefetch, n2, n3);
        this.nbPostPonedColumns = new int[1];
        this.nbPostPonedColumns[0] = 0;
        this.indexOfPostPonedColumn = new int[1][3];
        this.t4Connection = (T4CConnection)physicalConnection;
    }

    @Override
    void closeCursorOnPlainStatement() throws SQLException {
        if (this.cursorId != 0 && this.t4Connection.isLoggedOn()) {
            this.t4Connection.closeCursor(this.cursorId);
            this.setCursorId(0);
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

