/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Former;
import cern.colt.matrix.FormerFactory;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.DoubleIHistogram3D;
import hep.aida.tdouble.bin.DoubleBinFunction1D;
import hep.aida.tdouble.bin.DoubleBinFunctions1D;

public class DoubleConverter {
    public double[] edges(DoubleIAxis doubleIAxis) {
        int n = doubleIAxis.bins();
        double[] dArray = new double[n + 1];
        for (int i = 0; i < n; ++i) {
            dArray[i] = doubleIAxis.binLowerEdge(i);
        }
        dArray[n] = doubleIAxis.upperEdge();
        return dArray;
    }

    String form(Former former, double d) {
        return former.form(d);
    }

    protected double[] toArrayErrors(DoubleIHistogram1D doubleIHistogram1D) {
        int n = doubleIHistogram1D.xAxis().bins();
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = doubleIHistogram1D.binError(n2);
        }
        return dArray;
    }

    protected double[][] toArrayErrors(DoubleIHistogram2D doubleIHistogram2D) {
        int n = doubleIHistogram2D.xAxis().bins();
        int n2 = doubleIHistogram2D.yAxis().bins();
        double[][] dArray = new double[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                dArray[n4][n3] = doubleIHistogram2D.binError(n4, n3);
            }
        }
        return dArray;
    }

    protected double[] toArrayHeights(DoubleIHistogram1D doubleIHistogram1D) {
        int n = doubleIHistogram1D.xAxis().bins();
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = doubleIHistogram1D.binHeight(n2);
        }
        return dArray;
    }

    protected double[][] toArrayHeights(DoubleIHistogram2D doubleIHistogram2D) {
        int n = doubleIHistogram2D.xAxis().bins();
        int n2 = doubleIHistogram2D.yAxis().bins();
        double[][] dArray = new double[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                dArray[n4][n3] = doubleIHistogram2D.binHeight(n4, n3);
            }
        }
        return dArray;
    }

    protected double[][][] toArrayHeights(DoubleIHistogram3D doubleIHistogram3D) {
        int n = doubleIHistogram3D.xAxis().bins();
        int n2 = doubleIHistogram3D.yAxis().bins();
        int n3 = doubleIHistogram3D.zAxis().bins();
        double[][][] dArray = new double[n][n2][n3];
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    dArray[n4][n5][n6] = doubleIHistogram3D.binHeight(n4, n5, n6);
                }
            }
        }
        return dArray;
    }

    protected static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = dArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(dArray[i]);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString(DoubleIAxis doubleIAxis) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Range: [" + doubleIAxis.lowerEdge() + "," + doubleIAxis.upperEdge() + ")");
        stringBuffer.append(", Bins: " + doubleIAxis.bins());
        stringBuffer.append(", Bin edges: " + DoubleConverter.toString(this.edges(doubleIAxis)) + "\n");
        return stringBuffer.toString();
    }

    public String toString(DoubleIHistogram1D doubleIHistogram1D) {
        String string = null;
        String string2 = null;
        DoubleBinFunction1D[] doubleBinFunction1DArray = null;
        String string3 = "%G";
        Former former = new FormerFactory().create(string3);
        String string4 = System.getProperty("line.separator");
        int[] nArray = doubleIHistogram1D.minMaxBins();
        String string5 = doubleIHistogram1D.title() + ":" + string4 + "   Entries=" + this.form(former, doubleIHistogram1D.entries()) + ", ExtraEntries=" + this.form(former, doubleIHistogram1D.extraEntries()) + string4 + "   Mean=" + this.form(former, doubleIHistogram1D.mean()) + ", Rms=" + this.form(former, doubleIHistogram1D.rms()) + string4 + "   MinBinHeight=" + this.form(former, doubleIHistogram1D.binHeight(nArray[0])) + ", MaxBinHeight=" + this.form(former, doubleIHistogram1D.binHeight(nArray[1])) + string4 + "   Axis: " + "Bins=" + this.form(former, doubleIHistogram1D.xAxis().bins()) + ", Min=" + this.form(former, doubleIHistogram1D.xAxis().lowerEdge()) + ", Max=" + this.form(former, doubleIHistogram1D.xAxis().upperEdge());
        String[] stringArray = new String[doubleIHistogram1D.xAxis().bins()];
        for (int i = 0; i < doubleIHistogram1D.xAxis().bins(); ++i) {
            stringArray[i] = this.form(former, doubleIHistogram1D.xAxis().binLowerEdge(i));
        }
        String[] stringArray2 = null;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(1, doubleIHistogram1D.xAxis().bins());
        denseDoubleMatrix2D.viewRow(0).assign(this.toArrayHeights(doubleIHistogram1D));
        return string5 + string4 + "Heights:" + string4 + new DoubleFormatter().toTitleString(denseDoubleMatrix2D, stringArray2, stringArray, string2, string, null, doubleBinFunction1DArray);
    }

    public String toString(DoubleIHistogram2D doubleIHistogram2D) {
        String string = "X";
        String string2 = "Y";
        DoubleBinFunction1D[] doubleBinFunction1DArray = new DoubleBinFunction1D[]{DoubleBinFunctions1D.sum};
        String string3 = "%G";
        Former former = new FormerFactory().create(string3);
        String string4 = System.getProperty("line.separator");
        int[] nArray = doubleIHistogram2D.minMaxBins();
        String string5 = doubleIHistogram2D.title() + ":" + string4 + "   Entries=" + this.form(former, doubleIHistogram2D.entries()) + ", ExtraEntries=" + this.form(former, doubleIHistogram2D.extraEntries()) + string4 + "   MeanX=" + this.form(former, doubleIHistogram2D.meanX()) + ", RmsX=" + this.form(former, doubleIHistogram2D.rmsX()) + string4 + "   MeanY=" + this.form(former, doubleIHistogram2D.meanY()) + ", RmsY=" + this.form(former, doubleIHistogram2D.rmsX()) + string4 + "   MinBinHeight=" + this.form(former, doubleIHistogram2D.binHeight(nArray[0], nArray[1])) + ", MaxBinHeight=" + this.form(former, doubleIHistogram2D.binHeight(nArray[2], nArray[3])) + string4 + "   xAxis: " + "Bins=" + this.form(former, doubleIHistogram2D.xAxis().bins()) + ", Min=" + this.form(former, doubleIHistogram2D.xAxis().lowerEdge()) + ", Max=" + this.form(former, doubleIHistogram2D.xAxis().upperEdge()) + string4 + "   yAxis: " + "Bins=" + this.form(former, doubleIHistogram2D.yAxis().bins()) + ", Min=" + this.form(former, doubleIHistogram2D.yAxis().lowerEdge()) + ", Max=" + this.form(former, doubleIHistogram2D.yAxis().upperEdge());
        String[] stringArray = new String[doubleIHistogram2D.xAxis().bins()];
        for (int i = 0; i < doubleIHistogram2D.xAxis().bins(); ++i) {
            stringArray[i] = this.form(former, doubleIHistogram2D.xAxis().binLowerEdge(i));
        }
        Object[] objectArray = new String[doubleIHistogram2D.yAxis().bins()];
        for (int i = 0; i < doubleIHistogram2D.yAxis().bins(); ++i) {
            objectArray[i] = this.form(former, doubleIHistogram2D.yAxis().binLowerEdge(i));
        }
        new ObjectArrayList(objectArray).reverse();
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(this.toArrayHeights(doubleIHistogram2D));
        doubleMatrix2D = doubleMatrix2D.viewDice().viewRowFlip();
        return string5 + string4 + "Heights:" + string4 + new DoubleFormatter().toTitleString(doubleMatrix2D, (String[])objectArray, stringArray, string2, string, null, doubleBinFunction1DArray);
    }

    public String toString(DoubleIHistogram3D doubleIHistogram3D) {
        String string = "X";
        String string2 = "Y";
        String string3 = "Z";
        DoubleBinFunction1D[] doubleBinFunction1DArray = new DoubleBinFunction1D[]{DoubleBinFunctions1D.sum};
        String string4 = "%G";
        Former former = new FormerFactory().create(string4);
        String string5 = System.getProperty("line.separator");
        int[] nArray = doubleIHistogram3D.minMaxBins();
        String string6 = doubleIHistogram3D.title() + ":" + string5 + "   Entries=" + this.form(former, doubleIHistogram3D.entries()) + ", ExtraEntries=" + this.form(former, doubleIHistogram3D.extraEntries()) + string5 + "   MeanX=" + this.form(former, doubleIHistogram3D.meanX()) + ", RmsX=" + this.form(former, doubleIHistogram3D.rmsX()) + string5 + "   MeanY=" + this.form(former, doubleIHistogram3D.meanY()) + ", RmsY=" + this.form(former, doubleIHistogram3D.rmsX()) + string5 + "   MeanZ=" + this.form(former, doubleIHistogram3D.meanZ()) + ", RmsZ=" + this.form(former, doubleIHistogram3D.rmsZ()) + string5 + "   MinBinHeight=" + this.form(former, doubleIHistogram3D.binHeight(nArray[0], nArray[1], nArray[2])) + ", MaxBinHeight=" + this.form(former, doubleIHistogram3D.binHeight(nArray[3], nArray[4], nArray[5])) + string5 + "   xAxis: " + "Bins=" + this.form(former, doubleIHistogram3D.xAxis().bins()) + ", Min=" + this.form(former, doubleIHistogram3D.xAxis().lowerEdge()) + ", Max=" + this.form(former, doubleIHistogram3D.xAxis().upperEdge()) + string5 + "   yAxis: " + "Bins=" + this.form(former, doubleIHistogram3D.yAxis().bins()) + ", Min=" + this.form(former, doubleIHistogram3D.yAxis().lowerEdge()) + ", Max=" + this.form(former, doubleIHistogram3D.yAxis().upperEdge()) + string5 + "   zAxis: " + "Bins=" + this.form(former, doubleIHistogram3D.zAxis().bins()) + ", Min=" + this.form(former, doubleIHistogram3D.zAxis().lowerEdge()) + ", Max=" + this.form(former, doubleIHistogram3D.zAxis().upperEdge());
        String[] stringArray = new String[doubleIHistogram3D.xAxis().bins()];
        for (int i = 0; i < doubleIHistogram3D.xAxis().bins(); ++i) {
            stringArray[i] = this.form(former, doubleIHistogram3D.xAxis().binLowerEdge(i));
        }
        Object[] objectArray = new String[doubleIHistogram3D.yAxis().bins()];
        for (int i = 0; i < doubleIHistogram3D.yAxis().bins(); ++i) {
            objectArray[i] = this.form(former, doubleIHistogram3D.yAxis().binLowerEdge(i));
        }
        new ObjectArrayList(objectArray).reverse();
        Object[] objectArray2 = new String[doubleIHistogram3D.zAxis().bins()];
        for (int i = 0; i < doubleIHistogram3D.zAxis().bins(); ++i) {
            objectArray2[i] = this.form(former, doubleIHistogram3D.zAxis().binLowerEdge(i));
        }
        new ObjectArrayList(objectArray2).reverse();
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(this.toArrayHeights(doubleIHistogram3D));
        doubleMatrix3D = doubleMatrix3D.viewDice(2, 1, 0).viewSliceFlip().viewRowFlip();
        return string6 + string5 + "Heights:" + string5 + new DoubleFormatter().toTitleString(doubleMatrix3D, (String[])objectArray2, (String[])objectArray, stringArray, string3, string2, string, "", doubleBinFunction1DArray);
    }

    public String toXML(DoubleIHistogram1D doubleIHistogram1D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string);
        stringBuffer.append("<plot>");
        stringBuffer.append(string);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("<data1d>");
        stringBuffer.append(string);
        stringBuffer.append("<bins1d title=\"" + doubleIHistogram1D.title() + "\">");
        stringBuffer.append(string);
        for (int i = 0; i < doubleIHistogram1D.xAxis().bins(); ++i) {
            stringBuffer.append(doubleIHistogram1D.binEntries(i) + "," + doubleIHistogram1D.binError(i));
            stringBuffer.append(string);
        }
        stringBuffer.append("</bins1d>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + doubleIHistogram1D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + doubleIHistogram1D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + doubleIHistogram1D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistics>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Entries\" value=\"" + doubleIHistogram1D.entries() + "\"/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Underflow\" value=\"" + doubleIHistogram1D.binEntries(-2) + "\"/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Overflow\" value=\"" + doubleIHistogram1D.binEntries(-1) + "\"/>");
        stringBuffer.append(string);
        if (!Double.isNaN(doubleIHistogram1D.mean())) {
            stringBuffer.append("<statistic name=\"Mean\" value=\"" + doubleIHistogram1D.mean() + "\"/>");
            stringBuffer.append(string);
        }
        if (!Double.isNaN(doubleIHistogram1D.rms())) {
            stringBuffer.append("<statistic name=\"RMS\" value=\"" + doubleIHistogram1D.rms() + "\"/>");
            stringBuffer.append(string);
        }
        stringBuffer.append("</statistics>");
        stringBuffer.append(string);
        stringBuffer.append("</data1d>");
        stringBuffer.append(string);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("</plot>");
        stringBuffer.append(string);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String toXML(DoubleIHistogram2D doubleIHistogram2D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string);
        stringBuffer.append("<plot>");
        stringBuffer.append(string);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("<data2d type=\"xxx\">");
        stringBuffer.append(string);
        stringBuffer.append("<bins2d title=\"" + doubleIHistogram2D.title() + "\" xSize=\"" + doubleIHistogram2D.xAxis().bins() + "\" ySize=\"" + doubleIHistogram2D.yAxis().bins() + "\">");
        stringBuffer.append(string);
        for (int i = 0; i < doubleIHistogram2D.xAxis().bins(); ++i) {
            for (int j = 0; j < doubleIHistogram2D.yAxis().bins(); ++j) {
                stringBuffer.append(doubleIHistogram2D.binEntries(i, j) + "," + doubleIHistogram2D.binError(i, j));
                stringBuffer.append(string);
            }
        }
        stringBuffer.append("</bins2d>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + doubleIHistogram2D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + doubleIHistogram2D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + doubleIHistogram2D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"y0\"");
        stringBuffer.append(" min=\"" + doubleIHistogram2D.yAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + doubleIHistogram2D.yAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + doubleIHistogram2D.yAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("</data2d>");
        stringBuffer.append(string);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("</plot>");
        stringBuffer.append(string);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

