/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.filters;

import com.sosnoski.util.array.IntArray;
import java.util.SortedSet;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.filters.NodeSetFilter;
import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Graph;

public class FluffingFilter
implements NodeSetFilter {
    protected boolean iterative = false;

    public boolean filter(MutableNodeSet nodeSet) {
        IntArray toAdd = new IntArray();
        Graph graph = nodeSet.getGraph();
        if (nodeSet.size() < 5) {
            return true;
        }
        do {
            int minCount = (int)Math.floor(2.0 * (double)nodeSet.size() / 3.0);
            SortedSet<Integer> members = nodeSet.getMembers();
            toAdd.clear();
            for (int i : nodeSet.getExternalBoundaryNodeIterator()) {
                int[] neis = graph.getAdjacentNodeIndicesArray(i, Directedness.ALL);
                int intersectionSize = 0;
                for (int j : neis) {
                    if (!members.contains(j)) continue;
                    ++intersectionSize;
                }
                if (intersectionSize < minCount) continue;
                toAdd.add(i);
            }
            nodeSet.add(toAdd.toArray());
        } while (this.iterative && toAdd.size() > 0);
        return true;
    }
}

