/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

class F2wPoly {
    private int r;
    private F2w.F2wElem[] coeff;
    private int[] noCoeff;
    private F2w f2wBase;
    private F2wPolyElem[] z_i;

    public F2wPoly(int n, F2w.F2wElem[] f2wElemArray, int[] nArray, F2w f2w) {
        int n2;
        this.r = n;
        this.coeff = new F2w.F2wElem[f2wElemArray.length];
        this.noCoeff = new int[nArray.length];
        for (n2 = 0; n2 < f2wElemArray.length; ++n2) {
            this.coeff[n2] = f2wElemArray[n2];
            this.noCoeff[n2] = nArray[n2];
        }
        this.f2wBase = f2w;
        this.z_i = new F2wPolyElem[2 * n];
        this.z_i[0] = new F2wPolyElem();
        for (n2 = 0; n2 < n; ++n2) {
            this.z_i[0].value[n2].value = 0;
        }
        this.z_i[0].value[0].value = Integer.MIN_VALUE;
        for (n2 = 1; n2 < 2 * n; ++n2) {
            this.z_i[n2] = this.z_i[n2 - 1].multiplyZ();
        }
    }

    public F2wPolyElem createElem() {
        return new F2wPolyElem();
    }

    public F2wPolyElem createElem(F2wPolyElem f2wPolyElem) {
        return new F2wPolyElem(f2wPolyElem);
    }

    public F2wPolyElem createElem(int[] nArray) {
        return new F2wPolyElem(nArray);
    }

    public F2wPolyElem createZ() {
        int[] nArray = new int[this.r];
        for (int i = 0; i < this.r; ++i) {
            nArray[i] = 0;
        }
        nArray[1] = Integer.MIN_VALUE;
        return this.createElem(nArray);
    }

    public static void main(String[] stringArray) {
        F2w f2w = new F2w(32, 65538);
        F2w f2w2 = new F2w(32, 270549120);
        F2w.F2wElem f2wElem = f2w.createElem(305419896);
        F2w.F2wElem f2wElem2 = f2w2.createElem(0x19414111);
        F2w.F2wElem f2wElem3 = f2wElem.multiply(f2wElem2);
    }

    public class F2wPolyElem {
        private F2w.F2wElem[] value;

        private F2wPolyElem() {
            this.value = new F2w.F2wElem[F2wPoly.this.r];
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i] = F2wPoly.this.f2wBase.createElem();
            }
        }

        private F2wPolyElem(F2wPolyElem f2wPolyElem) {
            if (this.getBase() != f2wPolyElem.getBase()) {
                throw new IllegalArgumentException("The copied F2wPolyElem must come from the same F2wPoly.");
            }
            this.value = new F2w.F2wElem[F2wPoly.this.r];
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i] = F2wPoly.this.f2wBase.createElem(f2wPolyElem.value[i]);
            }
        }

        private F2wPolyElem(int[] nArray) {
            if (F2wPoly.this.r != nArray.length) {
                throw new IllegalArgumentException("Array length must be equal to r (" + F2wPoly.this.r + ")");
            }
            this.value = new F2w.F2wElem[F2wPoly.this.r];
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i] = F2wPoly.this.f2wBase.createElem(nArray[i]);
            }
        }

        public F2wPoly getBase() {
            return F2wPoly.this;
        }

        public F2wPolyElem multiplyZ() {
            int n;
            F2wPolyElem f2wPolyElem = new F2wPolyElem();
            f2wPolyElem.value[0].value = 0;
            for (n = 1; n < F2wPoly.this.r; ++n) {
                f2wPolyElem.value[n].value = this.value[n - 1].value;
            }
            for (n = 0; n < F2wPoly.this.noCoeff.length; ++n) {
                f2wPolyElem.value[F2wPoly.this.noCoeff[n]].value ^= this.value[F2wPoly.this.r - 1].multiply(F2wPoly.this.coeff[n]).value;
            }
            return f2wPolyElem;
        }

        public F2wPolyElem multiply(F2wPolyElem f2wPolyElem) {
            if (this.getBase() != f2wPolyElem.getBase()) {
                throw new IllegalArgumentException("Both F2wPolyElem must originate from the same F2wPoly.");
            }
            F2wPolyElem f2wPolyElem2 = new F2wPolyElem();
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                for (int j = 0; j < F2wPoly.this.r; ++j) {
                    F2w.F2wElem f2wElem = this.value[i].multiply(f2wPolyElem.value[j]);
                    for (int k = 0; k < F2wPoly.this.r; ++k) {
                        f2wPolyElem2.value[k].value ^= ((F2wPoly)F2wPoly.this).z_i[i + j].value[k].multiply(f2wElem).value;
                    }
                }
            }
            return f2wPolyElem2;
        }

        public F2wPolyElem exponentiateBase2(int n) {
            F2wPolyElem f2wPolyElem = new F2wPolyElem(this);
            F2wPolyElem f2wPolyElem2 = new F2wPolyElem();
            for (int i = 0; i < n; ++i) {
                int n2;
                for (n2 = 0; n2 < F2wPoly.this.r; ++n2) {
                    f2wPolyElem2.value[n2].value = 0;
                }
                for (n2 = 0; n2 < F2wPoly.this.r; ++n2) {
                    F2w.F2wElem f2wElem = f2wPolyElem.value[n2].square();
                    for (int j = 0; j < F2wPoly.this.r; ++j) {
                        f2wPolyElem2.value[j].value ^= ((F2wPoly)F2wPoly.this).z_i[2 * n2].value[j].multiply(f2wElem).value;
                    }
                }
                for (n2 = 0; n2 < F2wPoly.this.r; ++n2) {
                    f2wPolyElem.value[n2].value = f2wPolyElem2.value[n2].value;
                }
            }
            return f2wPolyElem;
        }

        public void copyFrom(F2wPolyElem f2wPolyElem) {
            if (this.getBase() != f2wPolyElem.getBase()) {
                throw new IllegalArgumentException("Both F2wPolyElem must originate from the same F2wPoly.");
            }
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i].value = f2wPolyElem.value[i].value;
            }
        }

        public void copyFrom(int[] nArray) {
            if (F2wPoly.this.r != this.value.length) {
                throw new IllegalArgumentException("Array length must be equal to r (" + F2wPoly.this.r + ")");
            }
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i].value = nArray[i];
            }
        }

        public void copyTo(int[] nArray) {
            if (F2wPoly.this.r != this.value.length) {
                throw new IllegalArgumentException("Array length must be equal to r (" + F2wPoly.this.r + ")");
            }
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                nArray[i] = this.value[i].value;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < F2wPoly.this.r - 1; ++i) {
                stringBuffer.append(this.value[i].toString() + ", \n ");
            }
            if (F2wPoly.this.r > 0) {
                stringBuffer.append(this.value[F2wPoly.this.r - 1].toString());
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public static class F2w {
        private int w;
        private int modQ;
        private F2wElem[] zeta_i;

        public F2w(int n) {
            this(32, n);
        }

        private F2w(int n, int n2) {
            this.w = n;
            this.modQ = n2;
            this.zeta_i = new F2wElem[n];
            this.zeta_i[0] = new F2wElem(Integer.MIN_VALUE);
            for (int i = 1; i < n; ++i) {
                this.zeta_i[i] = this.zeta_i[i - 1].multiplyZeta(2);
            }
        }

        public F2wElem createElem() {
            return new F2wElem();
        }

        public F2wElem createElem(F2wElem f2wElem) {
            return new F2wElem(f2wElem);
        }

        public F2wElem createElem(int n) {
            return new F2wElem(n);
        }

        public int getDim() {
            return this.w;
        }

        public int getModulo() {
            return this.modQ;
        }

        public class F2wElem {
            private int value;

            private F2wElem() {
                this.value = 0;
            }

            private F2wElem(F2wElem f2wElem) {
                if (this.getBase() != f2wElem.getBase()) {
                    throw new IllegalArgumentException("The copied F2wElem must originate from the same F2w.");
                }
                this.value = f2wElem.value;
            }

            private F2wElem(int n) {
                this.value = n;
            }

            public F2w getBase() {
                return F2w.this;
            }

            public int getValue() {
                return this.value;
            }

            public F2wElem multiplyZeta(int n) {
                int n2 = this.value;
                if (n == 0) {
                    return new F2wElem(n2);
                }
                for (int i = 0; i < n; ++i) {
                    if ((1 & n2) != 0) {
                        n2 = n2 >>> 1 ^ F2w.this.modQ;
                        continue;
                    }
                    n2 >>>= 1;
                }
                return new F2wElem(n2);
            }

            public F2wElem multiply(F2wElem f2wElem) {
                if (this.getBase() != f2wElem.getBase()) {
                    throw new IllegalArgumentException("Both F2wElem must originate from the same F2w.");
                }
                int n = 0;
                int n2 = 1;
                for (int i = F2w.this.w - 1; i >= 0; --i) {
                    if ((f2wElem.value & n2) != 0) {
                        n ^= this.multiplyZeta((int)i).value;
                    }
                    n2 <<= 1;
                }
                return new F2wElem(n);
            }

            public F2wElem square() {
                int n = 0;
                for (int i = 0; i < F2w.this.w; ++i) {
                    if ((this.value & Integer.MIN_VALUE >>> i) == 0) continue;
                    n ^= ((F2w)F2w.this).zeta_i[i].value;
                }
                return new F2wElem(n);
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                int n = this.value;
                for (int i = 0; i < 32; ++i) {
                    stringBuffer.append((n & 1) == 1 ? (char)'1' : '0');
                    n >>>= 1;
                }
                return stringBuffer.reverse().toString();
            }
        }
    }
}

