/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.Item;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.Itemset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.myDataset;

public class FuzzyAprioriProcess {
    private double minSupport;
    private double minConfidence;
    private boolean useMaxForOneFrequentItemsets;
    private myDataset dataset;
    private int countOneFrequentItemsets;
    private int countFrequentItemsets;
    private ArrayList<AssociationRule> associationRulesSet;
    private boolean[] coveredRecords;

    public FuzzyAprioriProcess(myDataset dataset, boolean useMaxForOneFrequentItemsets, double minSupport, double minConfidence) {
        this.useMaxForOneFrequentItemsets = useMaxForOneFrequentItemsets;
        this.minSupport = minSupport;
        this.minConfidence = minConfidence;
        this.dataset = dataset;
        this.countOneFrequentItemsets = 0;
        this.countFrequentItemsets = 0;
        this.associationRulesSet = new ArrayList();
        this.coveredRecords = new boolean[dataset.getnTrans()];
        for (int i = 0; i < this.coveredRecords.length; ++i) {
            this.coveredRecords[i] = false;
        }
    }

    public void run() {
        int pass = 0;
        ArrayList<Itemset> current_frequent_itemsets = this.generateOneFrequentItemsets(this.useMaxForOneFrequentItemsets);
        this.countFrequentItemsets = this.countOneFrequentItemsets = current_frequent_itemsets.size();
        System.out.println("\nPass: " + (pass + 1) + "; Total Frequent Itemsets: " + this.countFrequentItemsets);
        for (pass = 1; pass < this.dataset.getnVars() && current_frequent_itemsets.size() > 1; ++pass) {
            current_frequent_itemsets = this.generateCandidateItemsetsAndRules(current_frequent_itemsets);
            this.countFrequentItemsets += current_frequent_itemsets.size();
            System.out.println("Pass: " + (pass + 1) + "; Total Frequent Itemsets: " + this.countFrequentItemsets + "; Total Association Rules: " + this.associationRulesSet.size());
        }
    }

    public ArrayList<AssociationRule> getRulesSet() {
        return this.associationRulesSet;
    }

    public void printReport(ArrayList<AssociationRule> rules) {
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_interest = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_ant_length += (double)ar.getAntecedent().size();
            avg_interest += ar.getInterestingness();
        }
        System.out.println("\nNumber of Frequent Itemsets found: " + this.countFrequentItemsets);
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            System.out.println("Average Support: " + avg_sup / (double)rules.size());
            System.out.println("Average Confidence: " + avg_conf / (double)rules.size());
            System.out.println("Average Antecedents Length: " + avg_ant_length / (double)rules.size());
            System.out.println("Number of Covered Records (%): " + 100.0 * (double)this.countCoveredRecords() / (double)this.dataset.getnTrans());
            System.out.println("Average Interestingness: " + avg_interest / (double)rules.size());
        }
    }

    public int getNumberOfOneFrequentItemsets() {
        return this.countOneFrequentItemsets;
    }

    private ArrayList<Itemset> generateOneFrequentItemsets(boolean use_max_for_one_frequent_itemsets) {
        int[] nLabels = this.dataset.getNLabelsOfAttributes();
        ArrayList<Itemset> one_frequent_itemsets = new ArrayList<Itemset>();
        if (use_max_for_one_frequent_itemsets) {
            for (int id_attr = 0; id_attr < this.dataset.getnVars(); ++id_attr) {
                Itemset best_itemset = new Itemset();
                best_itemset.add(new Item(id_attr, 0));
                best_itemset.calculateSupport(this.dataset);
                double max_support = best_itemset.getSupport();
                for (int id_label = 1; id_label < nLabels[id_attr]; ++id_label) {
                    Itemset itemset = new Itemset();
                    itemset.add(new Item(id_attr, id_label));
                    itemset.calculateSupport(this.dataset);
                    if (!(itemset.getSupport() > max_support)) continue;
                    max_support = itemset.getSupport();
                    best_itemset = itemset;
                }
                if (!(max_support >= this.minSupport)) continue;
                one_frequent_itemsets.add(best_itemset);
            }
        } else {
            for (int id_attr = 0; id_attr < this.dataset.getnVars(); ++id_attr) {
                for (int id_label = 0; id_label < nLabels[id_attr]; ++id_label) {
                    Itemset itemset = new Itemset();
                    itemset.add(new Item(id_attr, id_label));
                    itemset.calculateSupport(this.dataset);
                    if (!(itemset.getSupport() >= this.minSupport)) continue;
                    one_frequent_itemsets.add(itemset);
                }
            }
        }
        return one_frequent_itemsets;
    }

    private ArrayList<Itemset> generateCandidateItemsetsAndRules(ArrayList<Itemset> curr_freq_itemsets) {
        int size = curr_freq_itemsets.size();
        ArrayList<Itemset> next_freq_itemsets = new ArrayList<Itemset>();
        for (int i = 0; i < size - 1; ++i) {
            Itemset i_itemset = curr_freq_itemsets.get(i);
            for (int j = i + 1; j < size; ++j) {
                Itemset j_itemset = curr_freq_itemsets.get(j);
                if (!this.isCombinable(i_itemset, j_itemset, curr_freq_itemsets)) continue;
                Itemset new_itemset = i_itemset.clone();
                new_itemset.add(j_itemset.get(j_itemset.size() - 1).clone());
                ArrayList<Integer> covered_tids = new_itemset.calculateSupport(this.dataset);
                if (!(new_itemset.getSupport() >= this.minSupport)) continue;
                boolean generated_rules = this.generateRulesFromItemset(new_itemset);
                if (generated_rules) {
                    this.markCoveredRecords(covered_tids);
                }
                next_freq_itemsets.add(new_itemset);
            }
        }
        return next_freq_itemsets;
    }

    private boolean generateRulesFromItemset(Itemset curr_itemset) {
        boolean generated_rules = false;
        for (int i = 0; i < curr_itemset.size(); ++i) {
            Itemset antecedent = curr_itemset.clone();
            Item i_item = antecedent.remove(i);
            antecedent.calculateSupport(this.dataset);
            double rule_sup = curr_itemset.getSupport();
            double ant_sup = antecedent.getSupport();
            double rule_conf = rule_sup / ant_sup;
            if (!(rule_conf >= this.minConfidence)) continue;
            Itemset consequent = new Itemset();
            consequent.add(i_item);
            consequent.calculateSupport(this.dataset);
            double cons_sup = consequent.getSupport();
            double interest = rule_conf * (rule_sup / cons_sup) * (1.0 - rule_sup / (double)this.dataset.getnTrans());
            this.associationRulesSet.add(new AssociationRule(antecedent, consequent, rule_sup, ant_sup, rule_conf, cons_sup, interest));
            if (generated_rules) continue;
            generated_rules = true;
        }
        return generated_rules;
    }

    private boolean isCombinable(Itemset i_itemset, Itemset j_itemset, ArrayList<Itemset> curr_freq_itemsets) {
        if (i_itemset.size() != j_itemset.size()) {
            return false;
        }
        Item i_item = i_itemset.get(i_itemset.size() - 1);
        Item j_item = j_itemset.get(i_itemset.size() - 1);
        if (i_item.getIDAttribute() >= j_item.getIDAttribute()) {
            return false;
        }
        for (int i = 0; i < i_itemset.size() - 1; ++i) {
            i_item = i_itemset.get(i);
            if (i_item.equals(j_item = j_itemset.get(i))) continue;
            return false;
        }
        Itemset itemset = i_itemset.clone();
        itemset.add(j_itemset.get(i_itemset.size() - 1).clone());
        return !this.pruning(itemset, curr_freq_itemsets);
    }

    private boolean pruning(Itemset itemset, ArrayList<Itemset> curr_freq_itemsets) {
        for (int i = 0; i < itemset.size() - 2; ++i) {
            Itemset sub = itemset.clone();
            sub.remove(i);
            if (this.existingIntoFrequentItemsets(sub, curr_freq_itemsets)) continue;
            return true;
        }
        return false;
    }

    private boolean existingIntoFrequentItemsets(Itemset itemset, ArrayList<Itemset> curr_freq_itemsets) {
        for (int i = 0; i < curr_freq_itemsets.size(); ++i) {
            Itemset its = curr_freq_itemsets.get(i);
            if (!its.equals(itemset)) continue;
            return true;
        }
        return false;
    }

    private void markCoveredRecords(ArrayList<Integer> covered_tids) {
        for (int i = 0; i < covered_tids.size(); ++i) {
            int t = covered_tids.get(i);
            if (this.coveredRecords[t]) continue;
            this.coveredRecords[t] = true;
        }
    }

    private int countCoveredRecords() {
        int cnt_covered_records = 0;
        for (int i = 0; i < this.coveredRecords.length; ++i) {
            if (!this.coveredRecords[i]) continue;
            ++cnt_covered_records;
        }
        return cnt_covered_records;
    }
}

