/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Missing_Values.MostCommonValue;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import keel.Algorithms.Preprocess.Missing_Values.MostCommonValue.FreqList;
import keel.Algorithms.Preprocess.Missing_Values.MostCommonValue.ValueFreq;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class MostCommonValue {
    double[] mean = null;
    double[] std_dev = null;
    double tempData = 0.0;
    String[][] X = null;
    FreqList[] timesSeen = null;
    String[] mostCommon;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    InstanceSet IS;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public MostCommonValue(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
    }

    private void write_results(String output) {
        try {
            FileWriter file_write = new FileWriter(output);
            file_write.write(this.IS.getHeader());
            file_write.write("@data\n");
            for (int i = 0; i < this.ndatos; ++i) {
                file_write.write(this.X[i][0]);
                for (int j = 1; j < this.nvariables; ++j) {
                    file_write.write("," + this.X[i][j]);
                }
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    public double boundValueToAttributeLimits(double value, Attribute a) {
        if (value < a.getMinAttribute()) {
            value = a.getMinAttribute();
        } else if (value > a.getMaxAttribute()) {
            value = a.getMaxAttribute();
        }
        return value;
    }

    public void process() {
        ValueFreq vf;
        double mean;
        Attribute a;
        int out;
        int in;
        try {
            this.IS.readSet(this.input_train_name, true);
            in = 0;
            out = 0;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][this.nvariables];
            this.timesSeen = new FreqList[this.nvariables];
            this.mostCommon = new String[this.nvariables];
            for (int j = 0; j < this.nvariables; ++j) {
                this.timesSeen[j] = new FreqList();
            }
            for (int i = 0; i < this.ndatos; ++i) {
                Instance inst = this.IS.getInstance(i);
                in = 0;
                out = 0;
                for (int j = 0; j < this.nvariables; ++j) {
                    Attribute a2 = Attributes.getAttribute(j);
                    this.direccion = a2.getDirectionAttribute();
                    this.tipo = a2.getType();
                    if (this.direccion == 1) {
                        if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                            this.timesSeen[j].AddElement(new String(String.valueOf(inst.getInputRealValues(in))));
                        } else if (!inst.getInputMissingValues(in)) {
                            this.timesSeen[j].AddElement(inst.getInputNominalValues(in));
                        }
                        ++in;
                        continue;
                    }
                    if (this.direccion != 2) continue;
                    if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                        this.timesSeen[j].AddElement(new String(String.valueOf(inst.getOutputRealValues(out))));
                    } else if (!inst.getOutputMissingValues(out)) {
                        this.timesSeen[j].AddElement(inst.getOutputNominalValues(out));
                    }
                    ++out;
                }
            }
            ValueFreq elem = null;
            for (int k = 0; k < this.nvariables; ++k) {
                elem = this.timesSeen[k].mostCommon();
                this.mostCommon[k] = elem != null ? elem.getValue() : "?";
            }
            for (int i = 0; i < this.ndatos; ++i) {
                Instance inst = this.IS.getInstance(i);
                in = 0;
                out = 0;
                for (int j = 0; j < this.nvariables; ++j) {
                    a = Attributes.getAttribute(j);
                    this.direccion = a.getDirectionAttribute();
                    this.tipo = a.getType();
                    if (this.direccion == 1) {
                        this.X[i][j] = this.tipo != 0 && !inst.getInputMissingValues(in) ? new String(String.valueOf(inst.getInputRealValues(in))) : (!inst.getInputMissingValues(in) ? inst.getInputNominalValues(in) : new String(this.mostCommon[j]));
                        ++in;
                        continue;
                    }
                    if (this.direccion != 2) continue;
                    if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                        this.X[i][j] = new String(String.valueOf(inst.getOutputRealValues(out)));
                    } else if (!inst.getOutputMissingValues(out)) {
                        this.X[i][j] = inst.getOutputNominalValues(out);
                    } else if (this.tipo == 0) {
                        this.X[i][j] = new String(this.mostCommon[j]);
                    } else {
                        this.timesSeen[j].reset();
                        mean = 0.0;
                        while (!this.timesSeen[j].outOfBounds()) {
                            vf = this.timesSeen[j].getCurrent();
                            mean += new Double(vf.getValue()) * (double)vf.getFreq();
                        }
                        mean /= (double)this.timesSeen[j].totalElems();
                        mean = this.boundValueToAttributeLimits(mean, a);
                        this.X[i][j] = new String(String.valueOf(mean));
                    }
                    ++out;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            System.exit(-1);
        }
        this.write_results(this.output_train_name);
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                this.IS.readSet(this.input_test_name, false);
                in = 0;
                out = 0;
                this.ndatos = this.IS.getNumInstances();
                this.nvariables = Attributes.getNumAttributes();
                this.nentradas = Attributes.getInputNumAttributes();
                this.nsalidas = Attributes.getOutputNumAttributes();
                this.X = new String[this.ndatos][this.nvariables];
                this.timesSeen = new FreqList[this.nvariables];
                this.mostCommon = new String[this.nvariables];
                for (int j = 0; j < this.nvariables; ++j) {
                    this.timesSeen[j] = new FreqList();
                }
                for (int i = 0; i < this.ndatos; ++i) {
                    Instance inst = this.IS.getInstance(i);
                    in = 0;
                    out = 0;
                    for (int j = 0; j < this.nvariables; ++j) {
                        Attribute a3 = Attributes.getAttribute(j);
                        this.direccion = a3.getDirectionAttribute();
                        this.tipo = a3.getType();
                        if (this.direccion == 1) {
                            if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                                this.timesSeen[j].AddElement(new String(String.valueOf(inst.getInputRealValues(in))));
                            } else if (!inst.getInputMissingValues(in)) {
                                this.timesSeen[j].AddElement(inst.getInputNominalValues(in));
                            }
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                            this.timesSeen[j].AddElement(new String(String.valueOf(inst.getOutputRealValues(out))));
                        } else if (!inst.getOutputMissingValues(out)) {
                            this.timesSeen[j].AddElement(inst.getOutputNominalValues(out));
                        }
                        ++out;
                    }
                }
                ValueFreq elem = null;
                for (int k = 0; k < this.nvariables; ++k) {
                    elem = this.timesSeen[k].mostCommon();
                    this.mostCommon[k] = elem != null ? elem.getValue() : "?";
                }
                for (int i = 0; i < this.ndatos; ++i) {
                    Instance inst = this.IS.getInstance(i);
                    in = 0;
                    out = 0;
                    for (int j = 0; j < this.nvariables; ++j) {
                        a = Attributes.getAttribute(j);
                        this.direccion = a.getDirectionAttribute();
                        this.tipo = a.getType();
                        if (this.direccion == 1) {
                            this.X[i][j] = this.tipo != 0 && !inst.getInputMissingValues(in) ? new String(String.valueOf(inst.getInputRealValues(in))) : (!inst.getInputMissingValues(in) ? inst.getInputNominalValues(in) : new String(this.mostCommon[j]));
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                            this.X[i][j] = new String(String.valueOf(inst.getOutputRealValues(out)));
                        } else if (!inst.getOutputMissingValues(out)) {
                            this.X[i][j] = inst.getOutputNominalValues(out);
                        } else if (this.tipo == 0) {
                            this.X[i][j] = new String(this.mostCommon[j]);
                        } else {
                            this.timesSeen[j].reset();
                            mean = 0.0;
                            while (!this.timesSeen[j].outOfBounds()) {
                                vf = this.timesSeen[j].getCurrent();
                                mean += new Double(vf.getValue()) * (double)vf.getFreq();
                            }
                            mean /= (double)this.timesSeen[j].totalElems();
                            mean = this.boundValueToAttributeLimits(mean, a);
                            this.X[i][j] = new String(String.valueOf(mean));
                        }
                        ++out;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Dataset exception = " + e);
                System.exit(-1);
            }
            this.write_results(this.output_test_name);
        }
    }
}

