/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric;

import java.util.Hashtable;
import keel.Algorithms.Neural_Networks.NNEP_Common.NeuralNetIndividual;
import keel.Algorithms.Neural_Networks.NNEP_Common.algorithm.NeuralNetAlgorithm;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.NeuralNetMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.ExpNeuronParametricMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.INeuronParametricMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.LinearNeuronParametricMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.SigmNeuronParametricMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ExpNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuralNet;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinearNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.SigmNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.problem.ProblemEvaluator;
import net.sf.jclec.IConfigure;
import net.sf.jclec.fitness.SimpleValueFitness;
import net.sf.jclec.util.range.Interval;
import org.apache.commons.configuration.Configuration;

public abstract class ParametricMutator<I extends NeuralNetIndividual>
extends NeuralNetMutator<I>
implements IConfigure {
    private static final long serialVersionUID = 4622620840640398781L;
    protected double temperExponent;
    protected double amplitude;
    protected boolean selective;
    protected double initialAlphaInput;
    protected double initialAlphaOutput;
    protected double fitDif;
    protected Hashtable<String, INeuronParametricMutator> neuronParametricMutators = new Hashtable();
    protected double alphaInput;
    protected double alphaOutput;
    double temper;

    public double getTemperExponent() {
        return this.temperExponent;
    }

    public void setTemperExponent(double temperExponent) {
        this.temperExponent = temperExponent;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    public boolean isSelective() {
        return this.selective;
    }

    public void setSelective(boolean selective) {
        this.selective = selective;
    }

    public double getAlphaInput() {
        return this.alphaInput;
    }

    public double getAlphaOutput() {
        return this.alphaOutput;
    }

    public double getInitialAlphaInput() {
        return this.initialAlphaInput;
    }

    public void setInitialAlphaInput(double initialAlphaInput) {
        this.initialAlphaInput = initialAlphaInput;
    }

    public double getInitialAlphaOutput() {
        return this.initialAlphaOutput;
    }

    public void setInitialAlphaOutput(double initialAlphaOutput) {
        this.initialAlphaOutput = initialAlphaOutput;
    }

    public double getFitDif() {
        return this.fitDif;
    }

    public void setFitDif(double fitDif) {
        this.fitDif = fitDif;
    }

    @Override
    protected void prepareMutation() {
        super.prepareMutation();
        this.alphaUpdate(((NeuralNetAlgorithm)this.context).getCurrentBest());
    }

    @Override
    public void mutateNext() {
        int noflayer;
        NeuralNetIndividual lastNnind = (NeuralNetIndividual)this.parentsBuffer.get(this.parentsCounter);
        NeuralNetIndividual result = (NeuralNetIndividual)lastNnind.copy();
        INeuralNet neuralNet = (INeuralNet)result.getGenotype();
        double fitness = ((SimpleValueFitness)result.getFitness()).getValue();
        this.temper = Math.pow(1.0 - fitness, this.temperExponent);
        while (neuralNet.getHlayer(noflayer = this.randgen.choose(0, neuralNet.getNofhlayers())).neuronsEmpty()) {
        }
        int nofneurons = neuralNet.getHlayer(noflayer).getNofneurons();
        LinkedLayer nextLayer = noflayer == neuralNet.getNofhlayers() - 1 ? neuralNet.getOutputLayer() : neuralNet.getHlayer(noflayer + 1);
        if (nextLayer.isBiased()) {
            ++nofneurons;
        }
        if (this.selective) {
            nofneurons = (int)(1.0 + this.randgen.raw() * this.temper * (double)nofneurons);
        }
        for (int i = 0; i < nofneurons; ++i) {
            double fitnessIncrement;
            double acceptValue;
            LinkedLayer layer = neuralNet.getHlayer(noflayer);
            nextLayer = noflayer == neuralNet.getNofhlayers() - 1 ? neuralNet.getOutputLayer() : neuralNet.getHlayer(noflayer + 1);
            int selectedNeuron = this.selective ? (nextLayer.isBiased() ? this.randgen.choose(0, layer.getNofneurons() + 1) : this.randgen.choose(0, layer.getNofneurons())) : i;
            if (selectedNeuron != layer.getNofneurons()) {
                LinkedNeuron neuron = layer.getNeuron(selectedNeuron);
                INeuronParametricMutator neuronParametricMutator = this.neuronParametricMutators.get(neuron.getClass().getCanonicalName());
                if (neuronParametricMutator == null) {
                    neuronParametricMutator = this.addNeuronParametricMutator(neuron);
                }
                if (neuronParametricMutator != null) {
                    neuronParametricMutator.parametricMutation(neuron, layer, nextLayer, selectedNeuron, this.alphaInput, this.alphaOutput, this.temper);
                }
            } else {
                this.mutateBias(nextLayer);
            }
            ((ProblemEvaluator)this.context.getEvaluator()).evaluate(result);
            double newFitness = ((SimpleValueFitness)result.getFitness()).getValue();
            this.alphaControlParametersUpdate(newFitness, fitness);
            if (newFitness < fitness && (acceptValue = Math.exp((fitnessIncrement = newFitness - fitness) / this.temper)) >= this.randgen.raw()) {
                result = lastNnind;
                neuralNet = (INeuralNet)result.getGenotype();
                newFitness = fitness;
            }
            lastNnind = (NeuralNetIndividual)result.copy();
            fitness = newFitness;
            this.temper = Math.pow(1.0 - fitness, this.temperExponent);
        }
        ((INeuralNet)result.getGenotype()).keepRelevantLinks(this.fitDif);
        this.sonsBuffer.add(result);
    }

    public abstract void alphaInit();

    protected abstract void alphaUpdate(double var1);

    protected abstract void alphaControlParametersUpdate(double var1, double var3);

    private INeuronParametricMutator addNeuronParametricMutator(LinkedNeuron neuron) {
        if (neuron instanceof SigmNeuron) {
            SigmNeuronParametricMutator neuronParametricMutator = new SigmNeuronParametricMutator();
            neuronParametricMutator.setRandgen(this.randgen);
            neuronParametricMutator.setAmplitude(this.amplitude);
            this.neuronParametricMutators.put(neuron.getClass().getCanonicalName(), neuronParametricMutator);
            return neuronParametricMutator;
        }
        if (neuron instanceof LinearNeuron) {
            LinearNeuronParametricMutator neuronParametricMutator = new LinearNeuronParametricMutator();
            neuronParametricMutator.setRandgen(this.randgen);
            neuronParametricMutator.setAmplitude(this.amplitude);
            this.neuronParametricMutators.put(neuron.getClass().getCanonicalName(), neuronParametricMutator);
            return neuronParametricMutator;
        }
        if (neuron instanceof ExpNeuron) {
            ExpNeuronParametricMutator neuronParametricMutator = new ExpNeuronParametricMutator();
            neuronParametricMutator.setRandgen(this.randgen);
            neuronParametricMutator.setAmplitude(this.amplitude);
            this.neuronParametricMutators.put(neuron.getClass().getCanonicalName(), neuronParametricMutator);
            return neuronParametricMutator;
        }
        return null;
    }

    private void mutateBias(LinkedLayer nextLayer) {
        for (int i = 0; i < nextLayer.getNofneurons(); ++i) {
            LinkedNeuron linkedNeuron = nextLayer.getNeuron(i);
            Link[] links = linkedNeuron.getLinks();
            double weigthIncrement = this.randgen.gaussian(this.alphaOutput * this.temper);
            links[links.length - 1].setWeight(links[links.length - 1].getWeight() + weigthIncrement);
            if (linkedNeuron.getWeightRange().contains(links[links.length - 1].getWeight())) continue;
            Interval interval = linkedNeuron.getWeightRange();
            if (links[links.length - 1].getWeight() > interval.getRight() * this.amplitude) {
                links[links.length - 1].setWeight(interval.getRight() * this.amplitude);
            }
            if (!(links[links.length - 1].getWeight() < interval.getLeft() * this.amplitude)) continue;
            links[links.length - 1].setWeight(interval.getLeft() * this.amplitude);
        }
    }

    @Override
    public void configure(Configuration settings) {
        this.selective = settings.getBoolean("[@selective]", false);
        this.temperExponent = settings.getDouble("temperature-exponent[@value]", 1.0);
        this.amplitude = settings.getDouble("amplitude[@value]", 5.0);
        this.fitDif = settings.getDouble("fitness-difference[@value]", 1.0E-7);
        this.initialAlphaInput = settings.getDouble("initial-alpha-values[@input]", 0.5);
        this.initialAlphaOutput = settings.getDouble("initial-alpha-values[@output]", 1.0);
    }
}

