/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.functions;

import moa.classifiers.AbstractClassifier;
import moa.classifiers.Regressor;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.options.FlagOption;
import moa.options.FloatOption;
import weka.core.Instance;

public class Perceptron
extends AbstractClassifier
implements Regressor {
    private final double SD_THRESHOLD = 1.0E-7;
    private static final long serialVersionUID = 1L;
    public FlagOption constantLearningRatioDecayOption = new FlagOption("learningRatio_Decay_set_constant", 'd', "Learning Ratio Decay in Perceptron set to be constant. (The next parameter).");
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'l', "Constante Learning Ratio to use for training the Perceptrons in the leaves.", 0.01);
    public FloatOption learningRateDecayOption = new FloatOption("learningRateDecay", 'm', " Learning Rate decay to use for training the Perceptron.", 0.001);
    public FloatOption fadingFactorOption = new FloatOption("fadingFactor", 'e', "Fading factor for the Perceptron accumulated error", 0.99, 0.0, 1.0);
    private double nError;
    protected double fadingFactor;
    protected double learningRatio;
    protected double learningRateDecay;
    protected double[] weightAttribute;
    public DoubleVector perceptronattributeStatistics = new DoubleVector();
    public DoubleVector squaredperceptronattributeStatistics = new DoubleVector();
    protected int perceptronInstancesSeen;
    protected int perceptronYSeen;
    protected double accumulatedError;
    protected boolean initialisePerceptron;
    protected double perceptronsumY;
    protected double squaredperceptronsumY;

    public Perceptron() {
        this.initialisePerceptron = true;
    }

    public Perceptron(Perceptron p) {
        this.constantLearningRatioDecayOption = p.constantLearningRatioDecayOption;
        this.learningRatioOption = p.learningRatioOption;
        this.learningRateDecayOption = p.learningRateDecayOption;
        this.fadingFactorOption = p.fadingFactorOption;
        this.nError = p.nError;
        this.fadingFactor = p.fadingFactor;
        this.learningRatio = p.learningRatio;
        this.learningRateDecay = p.learningRateDecay;
        if (p.weightAttribute != null) {
            this.weightAttribute = (double[])p.weightAttribute.clone();
        }
        this.perceptronattributeStatistics = new DoubleVector(p.perceptronattributeStatistics);
        this.squaredperceptronattributeStatistics = new DoubleVector(p.squaredperceptronattributeStatistics);
        this.perceptronInstancesSeen = p.perceptronInstancesSeen;
        this.initialisePerceptron = p.initialisePerceptron;
        this.perceptronsumY = p.perceptronsumY;
        this.squaredperceptronsumY = p.squaredperceptronsumY;
        this.perceptronYSeen = p.perceptronYSeen;
    }

    public void setWeights(double[] w) {
        this.weightAttribute = w;
    }

    public double[] getWeights() {
        return this.weightAttribute;
    }

    public int getInstancesSeen() {
        return this.perceptronInstancesSeen;
    }

    public void setInstancesSeen(int pInstancesSeen) {
        this.perceptronInstancesSeen = pInstancesSeen;
    }

    public void resetLearningImpl() {
        this.initialisePerceptron = true;
        this.reset();
    }

    public void reset() {
        this.nError = 0.0;
        this.accumulatedError = 0.0;
        this.perceptronInstancesSeen = 0;
        this.perceptronattributeStatistics = new DoubleVector();
        this.squaredperceptronattributeStatistics = new DoubleVector();
        this.perceptronsumY = 0.0;
        this.squaredperceptronsumY = 0.0;
        this.perceptronYSeen = 0;
    }

    public void resetError() {
        this.nError = 0.0;
        this.accumulatedError = 0.0;
    }

    public void trainOnInstanceImpl(Instance inst) {
        int j;
        this.accumulatedError = Math.abs(this.prediction(inst) - inst.classValue()) + this.fadingFactor * this.accumulatedError;
        this.nError = 1.0 + this.fadingFactor * this.nError;
        if (this.initialisePerceptron) {
            this.fadingFactor = this.fadingFactorOption.getValue();
            this.classifierRandom.setSeed(this.randomSeedOption.getValue());
            this.initialisePerceptron = false;
            this.weightAttribute = new double[inst.numAttributes()];
            for (j = 0; j < inst.numAttributes(); ++j) {
                this.weightAttribute[j] = 2.0 * this.classifierRandom.nextDouble() - 1.0;
            }
            this.learningRatio = this.learningRatioOption.getValue();
            this.learningRateDecay = this.learningRateDecayOption.getValue();
        }
        ++this.perceptronInstancesSeen;
        ++this.perceptronYSeen;
        for (j = 0; j < inst.numAttributes() - 1; ++j) {
            this.perceptronattributeStatistics.addToValue(j, inst.value(j));
            this.squaredperceptronattributeStatistics.addToValue(j, inst.value(j) * inst.value(j));
        }
        this.perceptronsumY += inst.classValue();
        this.squaredperceptronsumY += inst.classValue() * inst.classValue();
        if (!this.constantLearningRatioDecayOption.isSet()) {
            this.learningRatio = this.learningRatioOption.getValue() / (1.0 + (double)this.perceptronInstancesSeen * this.learningRateDecay);
        }
        this.updateWeights(inst, this.learningRatio);
    }

    private double prediction(Instance inst) {
        double[] normalizedInstance = this.normalizedInstance(inst);
        double normalizedPrediction = this.prediction(normalizedInstance);
        return this.denormalizedPrediction(normalizedPrediction);
    }

    public double normalizedPrediction(Instance inst) {
        double[] normalizedInstance = this.normalizedInstance(inst);
        double normalizedPrediction = this.prediction(normalizedInstance);
        return normalizedPrediction;
    }

    private double denormalizedPrediction(double normalizedPrediction) {
        if (!this.initialisePerceptron) {
            double meanY = this.perceptronsumY / (double)this.perceptronYSeen;
            double sdY = this.computeSD(this.squaredperceptronsumY, this.perceptronsumY, this.perceptronYSeen);
            if (sdY > 1.0E-7) {
                return normalizedPrediction * sdY + meanY;
            }
            return normalizedPrediction + meanY;
        }
        return normalizedPrediction;
    }

    public double prediction(double[] instanceValues) {
        double prediction = 0.0;
        if (!this.initialisePerceptron) {
            for (int j = 0; j < instanceValues.length - 1; ++j) {
                prediction += this.weightAttribute[j] * instanceValues[j];
            }
            prediction += this.weightAttribute[instanceValues.length - 1];
        }
        return prediction;
    }

    public double[] normalizedInstance(Instance inst) {
        double[] normalizedInstance = new double[inst.numAttributes()];
        for (int j = 0; j < inst.numAttributes() - 1; ++j) {
            int instAttIndex = Perceptron.modelAttIndexToInstanceAttIndex(j, inst);
            double mean = this.perceptronattributeStatistics.getValue(j) / (double)this.perceptronYSeen;
            double sd = this.computeSD(this.squaredperceptronattributeStatistics.getValue(j), this.perceptronattributeStatistics.getValue(j), this.perceptronYSeen);
            normalizedInstance[j] = sd > 1.0E-7 ? (inst.value(instAttIndex) - mean) / sd : inst.value(instAttIndex) - mean;
        }
        return normalizedInstance;
    }

    public double computeSD(double squaredVal, double val, int size) {
        if (size > 1) {
            return Math.sqrt((squaredVal - val * val / (double)size) / ((double)size - 1.0));
        }
        return 0.0;
    }

    public double updateWeights(Instance inst, double learningRatio) {
        int instAttIndex;
        int j;
        double[] normalizedInstance = this.normalizedInstance(inst);
        double normalizedPredict = this.prediction(normalizedInstance);
        double normalizedY = this.normalizeActualClassValue(inst);
        double sumWeights = 0.0;
        double delta = normalizedY - normalizedPredict;
        for (j = 0; j < inst.numAttributes() - 1; ++j) {
            instAttIndex = Perceptron.modelAttIndexToInstanceAttIndex(j, inst);
            if (!inst.attribute(instAttIndex).isNumeric()) continue;
            int n = j;
            this.weightAttribute[n] = this.weightAttribute[n] + learningRatio * delta * normalizedInstance[j];
            sumWeights += Math.abs(this.weightAttribute[j]);
        }
        int n = inst.numAttributes() - 1;
        this.weightAttribute[n] = this.weightAttribute[n] + learningRatio * delta;
        if ((sumWeights += Math.abs(this.weightAttribute[inst.numAttributes() - 1])) > (double)inst.numAttributes()) {
            for (j = 0; j < inst.numAttributes() - 1; ++j) {
                instAttIndex = Perceptron.modelAttIndexToInstanceAttIndex(j, inst);
                if (!inst.attribute(instAttIndex).isNumeric()) continue;
                this.weightAttribute[j] = this.weightAttribute[j] / sumWeights;
            }
            this.weightAttribute[inst.numAttributes() - 1] = this.weightAttribute[inst.numAttributes() - 1] / sumWeights;
        }
        return this.denormalizedPrediction(normalizedPredict);
    }

    public void normalizeWeights() {
        int j;
        double sumWeights = 0.0;
        for (j = 0; j < this.weightAttribute.length; ++j) {
            sumWeights += Math.abs(this.weightAttribute[j]);
        }
        for (j = 0; j < this.weightAttribute.length; ++j) {
            this.weightAttribute[j] = this.weightAttribute[j] / sumWeights;
        }
    }

    private double normalizeActualClassValue(Instance inst) {
        double meanY = this.perceptronsumY / (double)this.perceptronYSeen;
        double sdY = this.computeSD(this.squaredperceptronsumY, this.perceptronsumY, this.perceptronYSeen);
        double normalizedY = 0.0;
        normalizedY = sdY > 1.0E-7 ? (inst.classValue() - meanY) / sdY : inst.classValue() - meanY;
        return normalizedY;
    }

    public boolean isRandomizable() {
        return true;
    }

    public double[] getVotesForInstance(Instance inst) {
        return new double[]{this.prediction(inst)};
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    public void getModelDescription(StringBuilder out, int indent) {
        if (this.weightAttribute != null) {
            for (int i = 0; i < this.weightAttribute.length - 1; ++i) {
                if (this.weightAttribute[i] >= 0.0 && i > 0) {
                    out.append(" +" + (double)Math.round(this.weightAttribute[i] * 1000.0) / 1000.0 + " X" + i);
                    continue;
                }
                out.append(" " + (double)Math.round(this.weightAttribute[i] * 1000.0) / 1000.0 + " X" + i);
            }
            if (this.weightAttribute[this.weightAttribute.length - 1] >= 0.0) {
                out.append(" +" + (double)Math.round(this.weightAttribute[this.weightAttribute.length - 1] * 1000.0) / 1000.0);
            } else {
                out.append(" " + (double)Math.round(this.weightAttribute[this.weightAttribute.length - 1] * 1000.0) / 1000.0);
            }
        }
    }

    public void setLearningRatio(double learningRatio) {
        this.learningRatio = learningRatio;
    }

    public double getCurrentError() {
        if (this.nError > 0.0) {
            return this.accumulatedError / this.nError;
        }
        return Double.MAX_VALUE;
    }
}

