/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.utils.mtree;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import moa.clusterers.outliers.utils.mtree.ComposedSplitFunction;
import moa.clusterers.outliers.utils.mtree.DistanceFunction;
import moa.clusterers.outliers.utils.mtree.DistanceFunctions;
import moa.clusterers.outliers.utils.mtree.MTree;
import moa.clusterers.outliers.utils.mtree.PartitionFunctions;
import moa.clusterers.outliers.utils.mtree.PromotionFunctions;
import moa.clusterers.outliers.utils.mtree.SplitFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTree<DATA> {
    public static final int DEFAULT_MIN_NODE_CAPACITY = 50;
    protected int minNodeCapacity;
    protected int maxNodeCapacity;
    protected DistanceFunction<? super DATA> distanceFunction;
    protected SplitFunction<DATA> splitFunction;
    protected Node root;

    public MTree(DistanceFunction<? super DATA> distanceFunction, SplitFunction<DATA> splitFunction) {
        this(50, distanceFunction, splitFunction);
    }

    public MTree(int minNodeCapacity, DistanceFunction<? super DATA> distanceFunction, SplitFunction<DATA> splitFunction) {
        this(minNodeCapacity, 2 * minNodeCapacity - 1, distanceFunction, splitFunction);
    }

    public MTree(int minNodeCapacity, int maxNodeCapacity, DistanceFunction<? super DATA> distanceFunction, SplitFunction<DATA> splitFunction) {
        if (minNodeCapacity < 2 || maxNodeCapacity <= minNodeCapacity || distanceFunction == null) {
            throw new IllegalArgumentException();
        }
        if (splitFunction == null) {
            splitFunction = new ComposedSplitFunction(new PromotionFunctions.RandomPromotion(), new PartitionFunctions.BalancedPartition());
        }
        this.minNodeCapacity = minNodeCapacity;
        this.maxNodeCapacity = maxNodeCapacity;
        this.distanceFunction = distanceFunction;
        this.splitFunction = splitFunction;
        this.root = null;
    }

    public void add(DATA data) {
        if (this.root == null) {
            this.root = new RootLeafNode(data);
            try {
                this.root.addData(data, 0.0);
            }
            catch (SplitNodeReplacement e) {
                throw new RuntimeException("Should never happen!");
            }
        }
        double distance = this.distanceFunction.calculate(data, this.root.data);
        try {
            this.root.addData(data, distance);
        }
        catch (SplitNodeReplacement e) {
            RootNode newRoot = new RootNode(data);
            this.root = newRoot;
            for (int i = 0; i < e.newNodes.length; ++i) {
                Node newNode = (Node)e.newNodes[i];
                distance = this.distanceFunction.calculate(this.root.data, newNode.data);
                this.root.addChild(newNode, distance);
            }
        }
    }

    public boolean remove(DATA data) {
        if (this.root == null) {
            return false;
        }
        double distanceToRoot = this.distanceFunction.calculate(data, this.root.data);
        try {
            this.root.removeData(data, distanceToRoot);
        }
        catch (RootNodeReplacement e) {
            Node newRoot;
            this.root = newRoot = (Node)e.newRoot;
        }
        catch (DataNotFound e) {
            return false;
        }
        catch (NodeUnderCapacity e) {
            throw new RuntimeException("Should have never happened", e);
        }
        return true;
    }

    public Query getNearestByRange(DATA queryData, double range) {
        return this.getNearest(queryData, range, Integer.MAX_VALUE);
    }

    public Query getNearestByLimit(DATA queryData, int limit) {
        return this.getNearest(queryData, Double.POSITIVE_INFINITY, limit);
    }

    public Query getNearest(DATA queryData, double range, int limit) {
        return new Query(queryData, range, limit);
    }

    public Query getNearest(DATA queryData) {
        return new Query(queryData, Double.POSITIVE_INFINITY, Integer.MAX_VALUE);
    }

    protected void _check() {
        if (this.root != null) {
            this.root._check();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    extends IndexItem {
        private Entry(DATA data) {
            super(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeafNode
    extends Node {
        public LeafNode(DATA data) {
            super(data, new NonRootNodeTrait(), new LeafNodeTrait());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalNode
    extends Node {
        private InternalNode(DATA data) {
            super(data, new NonRootNodeTrait(), new NonLeafNodeTrait());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RootNode
    extends Node {
        private RootNode(DATA data) {
            super(data, new RootNodeTrait(), new NonLeafNodeTrait());
        }

        @Override
        void removeData(DATA data, double distance) throws RootNodeReplacement, NodeUnderCapacity, DataNotFound {
            try {
                super.removeData(data, distance);
            }
            catch (NodeUnderCapacity e) {
                Node newRoot;
                Node theChild = (Node)this.children.values().iterator().next();
                if (theChild instanceof InternalNode) {
                    newRoot = new RootNode(theChild.data);
                } else {
                    assert (theChild instanceof LeafNode);
                    newRoot = new RootLeafNode(theChild.data);
                }
                for (IndexItem grandchild : theChild.children.values()) {
                    distance = MTree.this.distanceFunction.calculate(newRoot.data, grandchild.data);
                    newRoot.addChild(grandchild, distance);
                }
                theChild.children.clear();
                throw new RootNodeReplacement(newRoot);
            }
        }

        @Override
        protected int getMinCapacity() {
            return 2;
        }

        @Override
        void _checkMinCapacity() {
            assert (this.children.size() >= 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RootLeafNode
    extends Node {
        private RootLeafNode(DATA data) {
            super(data, new RootNodeTrait(), new LeafNodeTrait());
        }

        @Override
        void removeData(DATA data, double distance) throws RootNodeReplacement, DataNotFound {
            try {
                super.removeData(data, distance);
            }
            catch (NodeUnderCapacity e) {
                assert (this.children.isEmpty());
                throw new RootNodeReplacement((Object)null);
            }
        }

        @Override
        protected int getMinCapacity() {
            return 1;
        }

        @Override
        void _checkMinCapacity() {
            assert (this.children.size() >= 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NonLeafNodeTrait
    extends NodeTrait
    implements Leafness<DATA> {
        NonLeafNodeTrait() {
        }

        @Override
        public void doAddData(DATA data, double distance) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CandidateChild {
                Node node;
                double distance;
                double metric;

                CandidateChild(Node node, double distance, double metric) {
                    this.node = node;
                    this.distance = distance;
                    this.metric = metric;
                }
            }
            CandidateChild minRadiusIncreaseNeeded = new CandidateChild(null, -1.0, Double.POSITIVE_INFINITY);
            CandidateChild nearestDistance = new CandidateChild(null, -1.0, Double.POSITIVE_INFINITY);
            for (IndexItem item : this.thisNode.children.values()) {
                Node child = (Node)item;
                double childDistance = ((Node)this.thisNode).mtree().distanceFunction.calculate(child.data, data);
                if (childDistance > child.radius) {
                    double radiusIncrease = childDistance - child.radius;
                    if (!(radiusIncrease < minRadiusIncreaseNeeded.metric)) continue;
                    minRadiusIncreaseNeeded = new CandidateChild(child, childDistance, radiusIncrease);
                    continue;
                }
                if (!(childDistance < nearestDistance.metric)) continue;
                nearestDistance = new CandidateChild(child, childDistance, childDistance);
            }
            CandidateChild chosen = nearestDistance.node != null ? nearestDistance : minRadiusIncreaseNeeded;
            Node child = chosen.node;
            try {
                child.addData(data, chosen.distance);
                this.thisNode.updateRadius(child);
            }
            catch (SplitNodeReplacement e) {
                IndexItem _ = this.thisNode.children.remove(child.data);
                assert (_ != null);
                for (int i = 0; i < e.newNodes.length; ++i) {
                    Node newChild = (Node)e.newNodes[i];
                    distance = ((Node)this.thisNode).mtree().distanceFunction.calculate(this.thisNode.data, newChild.data);
                    this.thisNode.addChild(newChild, distance);
                }
            }
        }

        @Override
        public void addChild(IndexItem newChild_, double distance) {
            Node newChild = (Node)newChild_;
            ArrayDeque<ChildWithDistance> newChildren = new ArrayDeque<ChildWithDistance>();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ChildWithDistance {
                Node child;
                double distance;

                ChildWithDistance(Node child, double distance) {
                    this.child = child;
                    this.distance = distance;
                }
            }
            newChildren.addFirst(new ChildWithDistance(newChild, distance));
            while (!newChildren.isEmpty()) {
                ChildWithDistance cwd = (ChildWithDistance)newChildren.removeFirst();
                newChild = cwd.child;
                distance = cwd.distance;
                if (this.thisNode.children.containsKey(newChild.data)) {
                    Node existingChild = (Node)this.thisNode.children.get(newChild.data);
                    assert (existingChild.data.equals(newChild.data));
                    for (IndexItem grandchild : newChild.children.values()) {
                        existingChild.addChild(grandchild, grandchild.distanceToParent);
                    }
                    newChild.children.clear();
                    try {
                        existingChild.checkMaxCapacity();
                        continue;
                    }
                    catch (SplitNodeReplacement e) {
                        IndexItem _ = this.thisNode.children.remove(existingChild.data);
                        assert (_ != null);
                        for (int i = 0; i < e.newNodes.length; ++i) {
                            Node newNode = (Node)e.newNodes[i];
                            distance = ((Node)this.thisNode).mtree().distanceFunction.calculate(this.thisNode.data, newNode.data);
                            newChildren.addFirst(new ChildWithDistance(newNode, distance));
                        }
                        continue;
                    }
                }
                this.thisNode.children.put(newChild.data, newChild);
                this.thisNode.updateMetrics(newChild, distance);
            }
        }

        @Override
        public Node newSplitNodeReplacement(DATA data) {
            return new InternalNode(data);
        }

        @Override
        public void doRemoveData(DATA data, double distance) throws DataNotFound {
            for (IndexItem childItem : this.thisNode.children.values()) {
                double distanceToChild;
                Node child = (Node)childItem;
                if (!(Math.abs(distance - child.distanceToParent) <= child.radius) || !((distanceToChild = ((Node)this.thisNode).mtree().distanceFunction.calculate(data, child.data)) <= child.radius)) continue;
                try {
                    child.removeData(data, distanceToChild);
                    this.thisNode.updateRadius(child);
                    return;
                }
                catch (DataNotFound e) {
                }
                catch (NodeUnderCapacity e) {
                    Node expandedChild = this.balanceChildren(child);
                    this.thisNode.updateRadius(expandedChild);
                    return;
                }
                catch (RootNodeReplacement e) {
                    throw new RuntimeException("Should never happen!");
                }
            }
            throw new DataNotFound();
        }

        private Node balanceChildren(Node theChild) {
            Node nearestDonor = null;
            double distanceNearestDonor = Double.POSITIVE_INFINITY;
            Node nearestMergeCandidate = null;
            double distanceNearestMergeCandidate = Double.POSITIVE_INFINITY;
            for (IndexItem child : this.thisNode.children.values()) {
                Node anotherChild = (Node)child;
                if (anotherChild == theChild) continue;
                double distance = ((Node)this.thisNode).mtree().distanceFunction.calculate(theChild.data, anotherChild.data);
                if (anotherChild.children.size() > anotherChild.getMinCapacity()) {
                    if (!(distance < distanceNearestDonor)) continue;
                    distanceNearestDonor = distance;
                    nearestDonor = anotherChild;
                    continue;
                }
                if (!(distance < distanceNearestMergeCandidate)) continue;
                distanceNearestMergeCandidate = distance;
                nearestMergeCandidate = anotherChild;
            }
            if (nearestDonor == null) {
                for (IndexItem grandchild : theChild.children.values()) {
                    if (nearestMergeCandidate == null) continue;
                    double distance = ((Node)this.thisNode).mtree().distanceFunction.calculate(grandchild.data, nearestMergeCandidate.data);
                    nearestMergeCandidate.addChild(grandchild, distance);
                }
                IndexItem removed = this.thisNode.children.remove(theChild.data);
                assert (removed != null);
                return nearestMergeCandidate;
            }
            IndexItem nearestGrandchild = null;
            double nearestGrandchildDistance = Double.POSITIVE_INFINITY;
            for (IndexItem grandchild : nearestDonor.children.values()) {
                double distance = ((Node)this.thisNode).mtree().distanceFunction.calculate(grandchild.data, theChild.data);
                if (!(distance < nearestGrandchildDistance)) continue;
                nearestGrandchildDistance = distance;
                nearestGrandchild = grandchild;
            }
            IndexItem _ = nearestDonor.children.remove(nearestGrandchild.data);
            assert (_ != null);
            theChild.addChild(nearestGrandchild, nearestGrandchildDistance);
            return theChild;
        }

        @Override
        public void _checkChildClass(IndexItem child) {
            assert (child instanceof InternalNode || child instanceof LeafNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeafNodeTrait
    extends NodeTrait
    implements Leafness<DATA> {
        private LeafNodeTrait() {
        }

        @Override
        public void doAddData(DATA data, double distance) {
            MTree mTree = this.thisNode.mtree();
            mTree.getClass();
            Entry entry = mTree.new Entry(data);
            assert (!this.thisNode.children.containsKey(data));
            this.thisNode.children.put(data, entry);
            assert (this.thisNode.children.containsKey(data));
            this.thisNode.updateMetrics(entry, distance);
        }

        @Override
        public void addChild(IndexItem child, double distance) {
            assert (!this.thisNode.children.containsKey(child.data));
            this.thisNode.children.put(child.data, child);
            assert (this.thisNode.children.containsKey(child.data));
            this.thisNode.updateMetrics(child, distance);
        }

        @Override
        public Node newSplitNodeReplacement(DATA data) {
            MTree mTree = this.thisNode.mtree();
            mTree.getClass();
            return mTree.new LeafNode(data);
        }

        @Override
        public void doRemoveData(DATA data, double distance) throws DataNotFound {
            if (this.thisNode.children.remove(data) == null) {
                throw new DataNotFound();
            }
        }

        @Override
        public void _checkChildClass(IndexItem child) {
            assert (child instanceof Entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NonRootNodeTrait
    extends NodeTrait
    implements Rootness {
        private NonRootNodeTrait() {
        }

        @Override
        public int getMinCapacity() {
            return MTree.this.minNodeCapacity;
        }

        @Override
        public void _checkMinCapacity() {
            assert (this.thisNode.children.size() >= ((Node)this.thisNode).mtree().minNodeCapacity);
        }

        @Override
        public void _checkDistanceToParent() {
            assert (this.thisNode.distanceToParent >= 0.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RootNodeTrait
    extends NodeTrait
    implements Rootness {
        private RootNodeTrait() {
        }

        @Override
        public int getMinCapacity() {
            throw new RuntimeException("Should not be called!");
        }

        @Override
        public void _checkDistanceToParent() {
            assert (this.thisNode.distanceToParent == -1.0);
        }

        @Override
        public void _checkMinCapacity() {
            this.thisNode._checkMinCapacity();
        }
    }

    private static interface Rootness {
        public int getMinCapacity();

        public void _checkDistanceToParent();

        public void _checkMinCapacity();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Leafness<DATA> {
        public void doAddData(DATA var1, double var2);

        public void addChild(IndexItem var1, double var2);

        public void doRemoveData(DATA var1, double var2) throws DataNotFound;

        public Node newSplitNodeReplacement(DATA var1);

        public void _checkChildClass(IndexItem var1);
    }

    private abstract class NodeTrait {
        protected Node thisNode;

        private NodeTrait() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Node
    extends IndexItem {
        protected Map<DATA, IndexItem> children;
        protected Rootness rootness;
        protected Leafness<DATA> leafness;

        private <R extends NodeTrait, L extends NodeTrait> Node(DATA data, R rootness, L leafness) {
            super(data);
            this.children = new HashMap();
            rootness.thisNode = this;
            this.rootness = (Rootness)((Object)rootness);
            leafness.thisNode = this;
            this.leafness = (Leafness)((Object)leafness);
        }

        private final void addData(DATA data, double distance) throws SplitNodeReplacement {
            this.doAddData(data, distance);
            this.checkMaxCapacity();
        }

        @Override
        int _check() {
            super._check();
            this._checkMinCapacity();
            this._checkMaxCapacity();
            int childHeight = -1;
            for (Map.Entry e : this.children.entrySet()) {
                Object data = e.getKey();
                IndexItem child = e.getValue();
                assert (child.data.equals(data));
                this._checkChildClass(child);
                this._checkChildMetrics(child);
                int height = child._check();
                if (childHeight < 0) {
                    childHeight = height;
                    continue;
                }
                assert (childHeight == height);
            }
            return childHeight + 1;
        }

        protected void doAddData(DATA data, double distance) {
            this.leafness.doAddData(data, distance);
        }

        protected void doRemoveData(DATA data, double distance) throws DataNotFound {
            this.leafness.doRemoveData(data, distance);
        }

        private final void checkMaxCapacity() throws SplitNodeReplacement {
            if (this.children.size() > MTree.this.maxNodeCapacity) {
                DistanceFunction cachedDistanceFunction = DistanceFunctions.cached(MTree.this.distanceFunction);
                SplitFunction.SplitResult splitResult = MTree.this.splitFunction.process(this.children.keySet(), cachedDistanceFunction);
                Node newNode0 = null;
                Node newNode1 = null;
                for (int i = 0; i < 2; ++i) {
                    Object promotedData = splitResult.promoted.get(i);
                    Set partition = splitResult.partitions.get(i);
                    Node newNode = this.newSplitNodeReplacement(promotedData);
                    for (Object data : partition) {
                        IndexItem child = this.children.get(data);
                        this.children.remove(data);
                        double distance = cachedDistanceFunction.calculate(promotedData, data);
                        newNode.addChild(child, distance);
                    }
                    if (i == 0) {
                        newNode0 = newNode;
                        continue;
                    }
                    newNode1 = newNode;
                }
                assert (this.children.isEmpty());
                throw new SplitNodeReplacement(new Object[]{newNode0, newNode1});
            }
        }

        protected Node newSplitNodeReplacement(DATA data) {
            return this.leafness.newSplitNodeReplacement(data);
        }

        protected void addChild(IndexItem child, double distance) {
            this.leafness.addChild(child, distance);
        }

        void removeData(DATA data, double distance) throws RootNodeReplacement, NodeUnderCapacity, DataNotFound {
            this.doRemoveData(data, distance);
            if (this.children.size() < this.getMinCapacity()) {
                throw new NodeUnderCapacity();
            }
        }

        protected int getMinCapacity() {
            return this.rootness.getMinCapacity();
        }

        private void updateMetrics(IndexItem child, double distance) {
            child.distanceToParent = distance;
            this.updateRadius(child);
        }

        private void updateRadius(IndexItem child) {
            if (child != null) {
                this.radius = Math.max(this.radius, child.distanceToParent + child.radius);
            }
        }

        void _checkMinCapacity() {
            this.rootness._checkMinCapacity();
        }

        private void _checkMaxCapacity() {
            assert (this.children.size() <= MTree.this.maxNodeCapacity);
        }

        private void _checkChildClass(IndexItem child) {
            this.leafness._checkChildClass(child);
        }

        private void _checkChildMetrics(IndexItem child) {
            double dist = MTree.this.distanceFunction.calculate(child.data, this.data);
            assert (child.distanceToParent == dist);
            double sum = child.distanceToParent + child.radius;
            assert (sum <= this.radius);
        }

        @Override
        protected void _checkDistanceToParent() {
            this.rootness._checkDistanceToParent();
        }

        private MTree<DATA> mtree() {
            return MTree.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexItem {
        DATA data;
        protected double radius;
        double distanceToParent;

        private IndexItem(DATA data) {
            this.data = data;
            this.radius = 0.0;
            this.distanceToParent = -1.0;
        }

        int _check() {
            this._checkRadius();
            this._checkDistanceToParent();
            return 1;
        }

        private void _checkRadius() {
            assert (this.radius >= 0.0);
        }

        protected void _checkDistanceToParent() {
            assert (!(this instanceof RootLeafNode));
            assert (!(this instanceof RootNode));
            assert (this.distanceToParent >= 0.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Query
    implements Iterable<ResultItem> {
        private DATA data;
        private double range;
        private int limit;

        private Query(DATA data, double range, int limit) {
            this.data = data;
            this.range = range;
            this.limit = limit;
        }

        @Override
        public Iterator<ResultItem> iterator() {
            return new ResultsIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ResultsIterator
        implements Iterator<ResultItem> {
            private ResultItem nextResultItem = null;
            private boolean finished = false;
            private PriorityQueue<moa.clusterers.outliers.utils.mtree.MTree$Query.ResultsIterator.ItemWithDistances<Node>> pendingQueue = new PriorityQueue();
            private double nextPendingMinDistance;
            private PriorityQueue<moa.clusterers.outliers.utils.mtree.MTree$Query.ResultsIterator.ItemWithDistances<Entry>> nearestQueue = new PriorityQueue();
            private int yieldedCount;

            private ResultsIterator() {
                if (MTree.this.root == null) {
                    this.finished = true;
                    return;
                }
                double distance = MTree.this.distanceFunction.calculate(Query.this.data, MTree.this.root.data);
                double minDistance = Math.max(distance - MTree.this.root.radius, 0.0);
                this.pendingQueue.add((moa.clusterers.outliers.utils.mtree.MTree$Query.ResultsIterator.ItemWithDistances<Node>)new ItemWithDistances<Node>(MTree.this.root, distance, minDistance));
                this.nextPendingMinDistance = minDistance;
            }

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                if (this.nextResultItem == null) {
                    this.fetchNext();
                }
                if (this.nextResultItem == null) {
                    this.finished = true;
                    return false;
                }
                return true;
            }

            @Override
            public ResultItem next() {
                if (this.hasNext()) {
                    ResultItem next = this.nextResultItem;
                    this.nextResultItem = null;
                    return next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetchNext() {
                assert (!this.finished);
                if (this.finished || this.yieldedCount >= Query.this.limit) {
                    this.finished = true;
                    return;
                }
                while (!this.pendingQueue.isEmpty() || !this.nearestQueue.isEmpty()) {
                    if (this.prepareNextNearest()) {
                        return;
                    }
                    assert (!this.pendingQueue.isEmpty());
                    ItemWithDistances pending = (ItemWithDistances)this.pendingQueue.poll();
                    Node node = (Node)pending.item;
                    for (IndexItem child : node.children.values()) {
                        double childDistance;
                        double childMinDistance;
                        if (!(Math.abs(pending.distance - child.distanceToParent) - child.radius <= Query.this.range) || !((childMinDistance = Math.max((childDistance = MTree.this.distanceFunction.calculate(Query.this.data, child.data)) - child.radius, 0.0)) <= Query.this.range)) continue;
                        if (child instanceof Entry) {
                            Entry entry = (Entry)child;
                            this.nearestQueue.add((moa.clusterers.outliers.utils.mtree.MTree$Query.ResultsIterator.ItemWithDistances<Entry>)new ItemWithDistances<Entry>(entry, childDistance, childMinDistance));
                            continue;
                        }
                        Node childNode = (Node)child;
                        this.pendingQueue.add((moa.clusterers.outliers.utils.mtree.MTree$Query.ResultsIterator.ItemWithDistances<Node>)new ItemWithDistances<Node>(childNode, childDistance, childMinDistance));
                    }
                    if (this.pendingQueue.isEmpty()) {
                        this.nextPendingMinDistance = Double.POSITIVE_INFINITY;
                        continue;
                    }
                    this.nextPendingMinDistance = ((ItemWithDistances)this.pendingQueue.peek()).minDistance;
                }
                this.finished = true;
            }

            private boolean prepareNextNearest() {
                ItemWithDistances nextNearest;
                if (!this.nearestQueue.isEmpty() && (nextNearest = (ItemWithDistances)this.nearestQueue.peek()).distance <= this.nextPendingMinDistance) {
                    this.nearestQueue.poll();
                    this.nextResultItem = new ResultItem(((Entry)((ItemWithDistances)nextNearest).item).data, nextNearest.distance);
                    ++this.yieldedCount;
                    return true;
                }
                return false;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private class ItemWithDistances<U>
            implements Comparable<moa.clusterers.outliers.utils.mtree.MTree$Query.ResultsIterator.ItemWithDistances<U>> {
                private U item;
                private double distance;
                private double minDistance;

                public ItemWithDistances(U item, double distance, double minDistance) {
                    this.item = item;
                    this.distance = distance;
                    this.minDistance = minDistance;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                @Override
                public int compareTo(ItemWithDistances that) {
                    if (this.minDistance < that.minDistance) {
                        return -1;
                    }
                    if (this.minDistance > that.minDistance) {
                        return 1;
                    }
                    return 0;
                }
            }
        }
    }

    private static class DataNotFound
    extends Exception {
        private DataNotFound() {
        }
    }

    private static class NodeUnderCapacity
    extends Exception {
        private NodeUnderCapacity() {
        }
    }

    private static class RootNodeReplacement
    extends Exception {
        private Object newRoot;

        private RootNodeReplacement(Object newRoot) {
            this.newRoot = newRoot;
        }
    }

    private static class SplitNodeReplacement
    extends Exception {
        private Object[] newNodes;

        private SplitNodeReplacement(Object ... newNodes) {
            this.newNodes = newNodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResultItem {
        public DATA data;
        public double distance;

        private ResultItem(DATA data, double distance) {
            this.data = data;
            this.distance = distance;
        }
    }
}

