/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.IteratedSingleClassifierEnhancer;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Utils;

public abstract class RandomizableIteratedSingleClassifierEnhancer
extends IteratedSingleClassifierEnhancer
implements Randomizable {
    private static final long serialVersionUID = 5063351391524938557L;
    protected int m_Seed = 1;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tRandom number seed.\n\t(default 1)", "S", 1, "-S <num>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String seed = Utils.getOption('S', options);
        if (seed.length() != 0) {
            this.setSeed(Integer.parseInt(seed));
        } else {
            this.setSeed(1);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-S");
        options.add("" + this.getSeed());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    @Override
    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    @Override
    public int getSeed() {
        return this.m_Seed;
    }
}

