/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.simplecli;

import java.util.ArrayList;
import java.util.Collections;
import weka.gui.simplecli.AbstractCommand;

public class Set
extends AbstractCommand {
    @Override
    public String getName() {
        return "set";
    }

    @Override
    public String getHelp() {
        return "Sets a variable.\nIf no key=value pair is given all current variables are listed.";
    }

    @Override
    public String getParameterHelp() {
        return "[name=value]";
    }

    @Override
    protected void doExecute(String[] params) throws Exception {
        if (params.length == 0) {
            ArrayList<String> names = new ArrayList<String>(this.m_Owner.getVariables().keySet());
            if (names.size() == 0) {
                System.out.println("No variables stored!");
            } else {
                Collections.sort(names);
                for (String n : names) {
                    System.out.println(n + "=" + this.m_Owner.getVariables().get(n));
                }
            }
            return;
        }
        if (params.length != 1) {
            throw new Exception("Expected exactly one argument: name=value");
        }
        if (!params[0].contains("=")) {
            throw new Exception("Expected format 'name=value', encountered: " + params[0]);
        }
        String name = params[0].substring(0, params[0].indexOf("="));
        String value = params[0].substring(params[0].indexOf("=") + 1);
        this.m_Owner.getVariables().put(name, value);
    }
}

