/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;

public class PowerOptionsPanel
extends JPanel
implements DocumentListener,
ActionListener {
    CreateGraphGUI parent;
    private Configuration conf;
    private JTextField numberOfSimulations;
    private JComboBox randomNumbers;
    private JComboBox upscale;
    private JCheckBox useSeed;
    private JTextField seed;
    private JLabel seedLabel = new JLabel("Seed:");

    public PowerOptionsPanel(CreateGraphGUI parent) {
        this.parent = parent;
        this.conf = Configuration.getInstance();
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.numberOfSimulations = new JTextField(8);
        this.numberOfSimulations.setText("" + this.conf.getGeneralConfig().getNumberOfSimulations());
        this.numberOfSimulations.setToolTipText("<html>The Monte Carlo sample size for power calculations.<br>Default is 10000.</html>");
        this.numberOfSimulations.getDocument().addDocumentListener(this);
        this.randomNumbers = new JComboBox<String>(new String[]{"quasirandom", "pseudorandom"});
        this.randomNumbers.setSelectedIndex(this.conf.getGeneralConfig().getTypeOfRandom().equals("quasirandom") ? 0 : 1);
        this.randomNumbers.setToolTipText("<html>You can select quasirandom or pseudorandom numbers for<br>power calculations. The quasirandom option uses a randomized<br>Lattice rule, and should be more efficient than the<br>pseudorandom option that uses ordinary (pseudo) random numbers.</html>");
        this.randomNumbers.addActionListener(this);
        this.upscale = new JComboBox<String>(new String[]{"Yes", "No"});
        this.upscale.setSelectedIndex(this.conf.getGeneralConfig().getUpscale() ? 0 : 1);
        this.upscale.setToolTipText("<html>If 'No' is selected then for each intersection of hypotheses (i.e. each subgraph)<br>a weighted test is performed at the possibly reduced level alpha of sum(w)*alpha,<br>where sum(w) is the sum of all node weights in this subset.<br>If 'Yes' is selected all weights are upscaled, so that sum(w)=1.<br>Please see the manual for a longer explanation and examples.</html>");
        this.upscale.addActionListener(this);
        this.useSeed = new JCheckBox("Use seed");
        this.useSeed.setSelected(this.conf.getGeneralConfig().useSeed());
        this.useSeed.addActionListener(this);
        this.useSeed.setToolTipText("<html>Should a user specified seed be used<br>for all calculations involving random numbers?</html>");
        this.seed = new JTextField(8);
        this.seed.setEnabled(this.useSeed.isSelected());
        this.seedLabel.setEnabled(this.useSeed.isSelected());
        this.seed.setText("" + this.conf.getGeneralConfig().getSeed());
        this.seed.setToolTipText("<html>Integer seed value to use.</html>");
        this.seed.getDocument().addDocumentListener(this);
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, pref";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        p1.add((Component)new JLabel("Monte Carlo sample size for power:"), cc.xy(1, row));
        p1.add((Component)this.numberOfSimulations, cc.xy(3, row));
        p1.add((Component)new JLabel("Type of random numbers:"), cc.xy(1, row += 2));
        p1.add((Component)this.randomNumbers, cc.xy(3, row));
        p1.add((Component)new JLabel("Weights of subgraphs are upscaled to 1:"), cc.xy(1, row += 2));
        p1.add((Component)this.upscale, cc.xy(3, row));
        this.add(p1);
        p1.add((Component)this.useSeed, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.seedLabel, cc.xy(1, row += 2));
        p1.add((Component)this.seed, cc.xy(3, row));
    }

    public void setProperties() {
        try {
            this.conf.getGeneralConfig().setNumberOfSimulations(Integer.parseInt(this.numberOfSimulations.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.numberOfSimulations.getText() + "\" is not a valid integer.", "Invalid input", 0);
        }
        this.conf.getGeneralConfig().setTypeOfRandom(this.randomNumbers.getSelectedItem().toString());
        this.conf.getGeneralConfig().setUpscale(this.upscale.getSelectedIndex() == 0);
        this.conf.getGeneralConfig().setUseSeed(this.useSeed.isSelected());
        try {
            this.conf.getGeneralConfig().setSeed(Integer.parseInt(this.seed.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.seed.getText() + "\" is not a valid integer.", "Invalid input", 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setProperties();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setProperties();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setProperties();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setProperties();
        if (e.getSource() == this.useSeed) {
            this.seed.setEnabled(this.useSeed.isSelected());
            this.seedLabel.setEnabled(this.useSeed.isSelected());
        }
    }
}

