/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import cern.colt.list.DoubleArrayList;
import java.awt.Dimension;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import umontreal.iro.lecuyer.charts.Axis;
import umontreal.iro.lecuyer.charts.EmpiricalSeriesCollection;
import umontreal.iro.lecuyer.charts.XYChart;
import umontreal.iro.lecuyer.stat.TallyStore;

public class EmpiricalChart
extends XYChart {
    protected void init(String title, String XLabel, String YLabel) {
        this.chart = ChartFactory.createXYLineChart(title, XLabel, YLabel, this.dataset.getSeriesCollection(), PlotOrientation.VERTICAL, true, true, false);
        ((XYPlot)this.chart.getPlot()).setRenderer(this.dataset.getRenderer());
        this.XAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getDomainAxis(), true);
        this.YAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getRangeAxis(), false);
        this.fixZeroPoint();
    }

    private void fixZeroPoint() {
        double xmin = Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition());
        XYSeriesCollection col = (XYSeriesCollection)this.dataset.getSeriesCollection();
        for (int i = 0; i < col.getSeriesCount(); ++i) {
            XYSeries ser = col.getSeries(i);
            ser.remove(0);
            ser.add(xmin, 0.0);
        }
    }

    public EmpiricalChart() {
        this.dataset = new EmpiricalSeriesCollection();
        this.init(null, null, null);
    }

    public EmpiricalChart(String title, String XLabel, String YLabel, double[] ... data) {
        this.dataset = new EmpiricalSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public EmpiricalChart(String title, String XLabel, String YLabel, double[] data, int numPoints) {
        this.dataset = new EmpiricalSeriesCollection(data, numPoints);
        this.init(title, XLabel, YLabel);
    }

    public EmpiricalChart(String title, String XLabel, String YLabel, DoubleArrayList ... data) {
        this.dataset = new EmpiricalSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public EmpiricalChart(String title, String XLabel, String YLabel, TallyStore ... tallies) {
        this.dataset = new EmpiricalSeriesCollection(tallies);
        this.init(title, XLabel, YLabel);
    }

    public EmpiricalChart(String title, String XLabel, String YLabel, XYSeriesCollection data) {
        this.dataset = new EmpiricalSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public EmpiricalSeriesCollection getSeriesCollection() {
        return (EmpiricalSeriesCollection)this.dataset;
    }

    public void setSeriesCollection(EmpiricalSeriesCollection dataset) {
        this.dataset = dataset;
    }

    public void setTicksSynchro(int s) {
        XYSeriesCollection seriesCollection = (XYSeriesCollection)this.dataset.getSeriesCollection();
        double[] values = new double[seriesCollection.getItemCount(s)];
        for (int i = 0; i < seriesCollection.getItemCount(s); ++i) {
            values[i] = seriesCollection.getXValue(s, i);
        }
        this.XAxis.setLabels(values);
    }

    public JFrame view(int width, int height) {
        JFrame myFrame = this.chart.getTitle() != null ? new JFrame("EmpiricalChart from SSJ : " + this.chart.getTitle().getText()) : new JFrame("EmpiricalChart from SSJ");
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(width, height));
        myFrame.setContentPane(chartPanel);
        myFrame.pack();
        myFrame.setDefaultCloseOperation(2);
        myFrame.setLocationRelativeTo(null);
        myFrame.setVisible(true);
        return myFrame;
    }

    public String toLatex(double width, double height) {
        double[] save = new double[4];
        if (this.dataset.getSeriesCollection().getSeriesCount() == 0) {
            throw new IllegalArgumentException("Empty chart");
        }
        double XScale = this.computeXScale(this.XAxis.getTwinAxisPosition());
        double YScale = this.computeYScale(this.YAxis.getTwinAxisPosition());
        double xunit = width / (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) * XScale - Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) * XScale);
        double yunit = height / (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) * YScale - Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) * YScale);
        Formatter formatter = new Formatter(Locale.US);
        if (this.latexDocFlag) {
            formatter.format("\\documentclass[12pt]{article}%n%n", new Object[0]);
            formatter.format("\\usepackage{tikz}%n\\usetikzlibrary{plotmarks}%n\\begin{document}%n%n", new Object[0]);
        }
        if (this.chart.getTitle() != null) {
            formatter.format("%% PGF/TikZ picture from SSJ : %s%n", this.chart.getTitle().getText());
        } else {
            formatter.format("%% PGF/TikZ picture from SSJ %n", new Object[0]);
        }
        formatter.format("%% XScale = %s,  YScale = %s,  XShift = %s,  YShift = %s%n", XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition());
        formatter.format("%% Therefore, thisFileXValue = (originalSeriesXValue+XShift)*XScale%n", new Object[0]);
        formatter.format("%%        and thisFileYValue = (originalSeriesYValue+YShift)*YScale%n%n", new Object[0]);
        if (this.chart.getTitle() != null) {
            formatter.format("\\begin{figure}%n", new Object[0]);
        }
        formatter.format("\\begin{center}%n", new Object[0]);
        formatter.format("\\begin{tikzpicture}[x=%scm, y=%scm]%n", xunit, yunit);
        formatter.format("\\footnotesize%n", new Object[0]);
        if (this.grid) {
            formatter.format("\\draw[color=lightgray] (%s, %s) grid[xstep = %s, ystep=%s] (%s, %s);%n", (Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale, this.xstepGrid * XScale, this.ystepGrid * YScale, (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale);
        }
        this.setTick0Flags();
        formatter.format("%s", this.XAxis.toLatex(XScale));
        formatter.format("%s", this.YAxis.toLatex(YScale));
        formatter.format("%s", this.dataset.toLatex(XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition(), this.XAxis.getAxis().getLowerBound(), this.XAxis.getAxis().getUpperBound(), this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()));
        formatter.format("\\end{tikzpicture}%n", new Object[0]);
        formatter.format("\\end{center}%n", new Object[0]);
        if (this.chart.getTitle() != null) {
            formatter.format("\\caption{", new Object[0]);
            formatter.format(this.chart.getTitle().getText(), new Object[0]);
            formatter.format("}%n\\end{figure}%n", new Object[0]);
        }
        if (this.latexDocFlag) {
            formatter.format("\\end{document}%n", new Object[0]);
        }
        return formatter.toString();
    }
}

