/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import cern.colt.list.DoubleArrayList;
import java.io.PrintWriter;
import umontreal.iro.lecuyer.gof.FDist;
import umontreal.iro.lecuyer.gof.GofStat;
import umontreal.iro.lecuyer.probdist.AndersonDarlingDistQuick;
import umontreal.iro.lecuyer.probdist.ChiSquareDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.CramerVonMisesDist;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovDistQuick;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovPlusDist;
import umontreal.iro.lecuyer.probdist.WatsonGDist;
import umontreal.iro.lecuyer.probdist.WatsonUDist;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class GofFormat {
    public static final int GNUPLOT = 0;
    public static final int MATHEMATICA = 1;
    public static int graphSoft = 0;
    public static double EPSILONP = 1.0E-15;
    public static double SUSPECTP = 0.01;
    public static final int KSP = 0;
    public static final int KSM = 1;
    public static final int KS = 2;
    public static final int AD = 3;
    public static final int CM = 4;
    public static final int WG = 5;
    public static final int WU = 6;
    public static final int MEAN = 7;
    public static final int COR = 8;
    public static final int NTESTTYPES = 9;
    public static final String[] TESTNAMES = new String[]{"KolmogorovSmirnovPlus", "KolmogorovSmirnovMinus", "KolmogorovSmirnov", "Anderson-Darling", "CramerVon-Mises", "Watson G", "Watson U", "Mean", "Correlation"};
    public static boolean[] activeTests = null;

    private GofFormat() {
    }

    private static String formatMath2(double d, double d2) {
        int n;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   { ");
        if (d != 0.0 && (d < 0.1 || d > 1.0)) {
            string = PrintfFormat.E(16, 7, d);
            n = string.indexOf(69);
            if (n != -1) {
                string = string.substring(0, n) + "*10^(" + string.substring(n + 1) + ")";
            }
        } else {
            string = PrintfFormat.g(16, 8, d);
        }
        stringBuffer.append(string + ",     ");
        if (d2 != 0.0 && (d2 < 0.1 || d2 > 1.0)) {
            string = PrintfFormat.E(16, 7, d2);
            n = string.indexOf(69);
            if (n != -1) {
                string = string.substring(0, n) + "*10^(" + string.substring(n + 1) + ")";
            }
        } else {
            string = PrintfFormat.g(16, 8, d2);
        }
        stringBuffer.append(string + " }");
        return stringBuffer.toString();
    }

    private static String graphFunc(ContinuousDistribution continuousDistribution, double d, double d2, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (n2 != 1 && n2 != -1) {
            throw new IllegalArgumentException("mono must be 1 or -1");
        }
        switch (graphSoft) {
            case 0: {
                string2 = "# ";
                string3 = "";
                string4 = "";
                string5 = PrintfFormat.NEWLINE;
                break;
            }
            case 1: {
                string2 = "(* ";
                string3 = " *)";
                string4 = "points = { " + PrintfFormat.NEWLINE;
                string5 = "}" + PrintfFormat.NEWLINE;
            }
        }
        stringBuffer.append(string2 + "----------------------------------" + string3 + PrintfFormat.NEWLINE);
        stringBuffer.append(string2 + PrintfFormat.s(-70, string) + string3 + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        stringBuffer.append(string4);
        double d3 = (d2 - d) / (double)n;
        double d4 = n2 == 1 ? -1.7976931348623157E308 : (n2 == -1 ? Double.MAX_VALUE : 0.0);
        for (int i = 0; i <= n; ++i) {
            double d5 = d + (double)i * d3;
            double d6 = n2 == 1 ? continuousDistribution.cdf(d5) : continuousDistribution.barF(d5);
            switch (graphSoft) {
                case 1: {
                    stringBuffer.append(GofFormat.formatMath2(d5, d6));
                    if (i >= n) break;
                    stringBuffer.append(',');
                    break;
                }
                default: {
                    stringBuffer.append(PrintfFormat.g(20, 14, d5) + "      " + PrintfFormat.g(20, 14, d6));
                }
            }
            switch (n2) {
                case 1: {
                    if (!(d6 < d4)) break;
                    stringBuffer.append("    " + string2 + "  DECREASING" + string3);
                    break;
                }
                case -1: {
                    if (!(d6 > d4)) break;
                    stringBuffer.append("    " + string2 + "  INCREASING" + string3);
                    break;
                }
            }
            stringBuffer.append(PrintfFormat.NEWLINE);
            d4 = d6;
        }
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }

    public static String drawCdf(ContinuousDistribution continuousDistribution, double d, double d2, int n, String string) {
        return GofFormat.graphFunc(continuousDistribution, d, d2, n, 1, string);
    }

    public static String drawDensity(ContinuousDistribution continuousDistribution, double d, double d2, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        switch (graphSoft) {
            case 0: {
                string2 = "# ";
                string3 = "";
                string4 = "";
                string5 = PrintfFormat.NEWLINE;
                break;
            }
            case 1: {
                string2 = "(* ";
                string3 = " *)";
                string4 = "points = { " + PrintfFormat.NEWLINE;
                string5 = "}" + PrintfFormat.NEWLINE;
            }
        }
        stringBuffer.append(string2 + "----------------------------------" + string3 + PrintfFormat.NEWLINE);
        stringBuffer.append(string2 + PrintfFormat.s(-70, string) + string3 + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        stringBuffer.append(string4);
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i <= n; ++i) {
            double d4 = d + (double)i * d3;
            double d5 = continuousDistribution.density(d4);
            switch (graphSoft) {
                case 1: {
                    stringBuffer.append(GofFormat.formatMath2(d4, d5));
                    if (i >= n) break;
                    stringBuffer.append(',');
                    break;
                }
                default: {
                    stringBuffer.append(PrintfFormat.g(16, 8, d4) + "      " + PrintfFormat.g(16, 8, d5));
                }
            }
            stringBuffer.append(PrintfFormat.NEWLINE);
        }
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }

    public static String graphDistUnif(DoubleArrayList doubleArrayList, String string) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d = 1.0 / (double)n;
        StringBuffer stringBuffer = new StringBuffer();
        switch (graphSoft) {
            case 0: {
                stringBuffer.append("#----------------------------------" + PrintfFormat.NEWLINE);
                stringBuffer.append("# " + PrintfFormat.s(-70, string) + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
                stringBuffer.append(PrintfFormat.g(16, 8, 0.0) + "  " + PrintfFormat.g(16, 8, 0.0) + PrintfFormat.NEWLINE);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(PrintfFormat.g(16, 8, dArray[i]) + "  " + PrintfFormat.g(16, 8, (double)(i + 1) * d) + PrintfFormat.NEWLINE);
                }
                stringBuffer.append(PrintfFormat.g(16, 8, 1.0) + "  " + PrintfFormat.g(16, 8, 1.0) + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
                break;
            }
            case 1: {
                stringBuffer.append("(*----------------------------------*)" + PrintfFormat.NEWLINE);
                stringBuffer.append("(* " + PrintfFormat.s(-70, string) + PrintfFormat.NEWLINE + " *)" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE + "points = { " + PrintfFormat.NEWLINE);
                stringBuffer.append(GofFormat.formatMath2(0.0, 0.0) + "," + PrintfFormat.NEWLINE);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(GofFormat.formatMath2(dArray[i], (double)(i + 1) * d) + "," + PrintfFormat.NEWLINE);
                }
                stringBuffer.append(GofFormat.formatMath2(1.0, 1.0) + PrintfFormat.NEWLINE);
                break;
            }
            default: {
                throw new IllegalArgumentException("graphSoft unknown");
            }
        }
        return stringBuffer.toString();
    }

    public static String formatp0(double d) {
        if (d >= 0.01 && d <= 0.99) {
            return PrintfFormat.format(8, 2, 1, d);
        }
        if (d < EPSILONP) {
            return "   eps  ";
        }
        if (d < 0.01) {
            return PrintfFormat.format(8, 2, 2, d);
        }
        if (d >= 1.0 - EPSILONP) {
            return " 1 - eps ";
        }
        return " 1 - " + PrintfFormat.g(8, 2, 1.0 - d);
    }

    public static String formatp1(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("p-value of test                       :" + GofFormat.formatp0(d));
        if (d < SUSPECTP || d > 1.0 - SUSPECTP) {
            stringBuffer.append("    *****");
        }
        stringBuffer.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return stringBuffer.toString();
    }

    public static String formatp2(double d, double d2) {
        return PrintfFormat.format(8, 2, 1, d) + PrintfFormat.NEWLINE + GofFormat.formatp1(d2);
    }

    public static String formatp3(String string, double d, double d2) {
        int n = Math.max("p-value of test".length(), string.length());
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append(-n, string).append(" : ").append(8, 2, 1, d).append(PrintfFormat.NEWLINE);
        printfFormat.append(-n, "p-value of test").append(" : ").append(GofFormat.formatp0(d2));
        if (d2 < SUSPECTP || d2 > 1.0 - SUSPECTP) {
            printfFormat.append("    *****");
        }
        printfFormat.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return printfFormat.toString();
    }

    public static String formatChi2(int n, int n2, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Chi2 statistic                        : " + PrintfFormat.format(8, 2, 1, d));
        stringBuffer.append(PrintfFormat.NEWLINE + "p-value                               : " + GofFormat.formatp0(GofStat.pDisc(ChiSquareDist.cdf(n - 1, n2, d), ChiSquareDist.barF(n - 1, n2, d))));
        stringBuffer.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return stringBuffer.toString();
    }

    public static String formatKS(int n, double d, double d2, double d3) {
        return "Kolmogorov-Smirnov+ statistic = D+    :" + GofFormat.formatp2(d, KolmogorovSmirnovPlusDist.barF(n, d)) + "Kolmogorov-Smirnov- statistic = D-    :" + GofFormat.formatp2(d2, KolmogorovSmirnovPlusDist.barF(n, d2)) + "Kolmogorov-Smirnov statistic = D      :" + GofFormat.formatp2(d3, KolmogorovSmirnovDistQuick.barF(n, d3)) + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE;
    }

    public static String formatKS(DoubleArrayList doubleArrayList, ContinuousDistribution continuousDistribution) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        DoubleArrayList doubleArrayList2 = GofStat.unifTransform(doubleArrayList, continuousDistribution);
        doubleArrayList2.quickSortFromTo(0, doubleArrayList2.size() - 1);
        double[] dArray2 = GofStat.kolmogorovSmirnov(doubleArrayList2);
        return GofFormat.formatKS(n, dArray2[0], dArray2[1], dArray2[2]);
    }

    public static String formatKSJumpOne(int n, double d, double d2) {
        double d3 = 1.0 - FDist.kolmogorovSmirnovPlusJumpOne(n, d, d2);
        return PrintfFormat.NEWLINE + "Kolmogorov-Smirnov+ statistic = D+    : " + PrintfFormat.g(8, 2, d2) + PrintfFormat.NEWLINE + GofFormat.formatp1(d3) + PrintfFormat.NEWLINE;
    }

    public static String formatKSJumpOne(DoubleArrayList doubleArrayList, ContinuousDistribution continuousDistribution, double d) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        DoubleArrayList doubleArrayList2 = GofStat.unifTransform(doubleArrayList, continuousDistribution);
        doubleArrayList2.quickSortFromTo(0, doubleArrayList2.size() - 1);
        double[] dArray2 = GofStat.kolmogorovSmirnovJumpOne(doubleArrayList2, d);
        return GofFormat.formatKSJumpOne(n, d, dArray2[0]);
    }

    private static void initActiveTests() {
        activeTests = new boolean[9];
        for (int i = 0; i < activeTests.length; ++i) {
            GofFormat.activeTests[i] = false;
        }
        GofFormat.activeTests[1] = true;
        GofFormat.activeTests[0] = true;
        GofFormat.activeTests[8] = true;
        GofFormat.activeTests[7] = true;
        GofFormat.activeTests[3] = true;
    }

    public static void tests(DoubleArrayList doubleArrayList, double[] dArray) {
        double[] dArray2 = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (dArray.length != 9) {
            throw new IllegalArgumentException("sVal must be of size NTESTTYPES.");
        }
        if (n == 1) {
            dArray[0] = 1.0 - dArray2[0];
            dArray[7] = dArray2[0];
            return;
        }
        double d4 = 1.0 / (double)n;
        double d5 = d4 / 12.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d7 = dArray2[i] - (double)i * d4;
            double d8 = (double)(i + 1) * d4 - dArray2[i];
            if (d7 > d2) {
                d2 = d7;
            }
            if (d8 > d3) {
                d3 = d8;
            }
            d6 += dArray2[i];
            double d9 = dArray2[i] - ((double)i + 0.5) * d4;
            d5 += d9 * d9;
            double d10 = dArray2[i];
            double d11 = 1.0 - d10;
            if (d10 < GofStat.EPSILONAD) {
                d10 = GofStat.EPSILONAD;
            } else if (d11 < GofStat.EPSILONAD) {
                d11 = GofStat.EPSILONAD;
            }
            d += (double)(2 * i + 1) * Math.log(d10) + (double)(1 + 2 * (n - i - 1)) * Math.log(d11);
        }
        dArray[2] = d2 > d3 ? d2 : d3;
        dArray[1] = d2;
        dArray[0] = d3;
        d6 = d6 * d4 - 0.5;
        dArray[4] = d5;
        dArray[5] = Math.sqrt(n) * (d3 + d6);
        dArray[6] = d5 - d6 * d6 * (double)n;
        dArray[3] = (double)(-n) - d * d4;
        dArray[7] = d6 + 0.5;
    }

    public static void tests(DoubleArrayList doubleArrayList, ContinuousDistribution continuousDistribution, double[] dArray) {
        double[] dArray2 = doubleArrayList.elements();
        int n = doubleArrayList.size();
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        DoubleArrayList doubleArrayList2 = GofStat.unifTransform(doubleArrayList, continuousDistribution);
        doubleArrayList2.quickSortFromTo(0, doubleArrayList2.size() - 1);
        GofFormat.tests(doubleArrayList2, dArray);
        if (n == 1) {
            dArray[7] = dArray2[0];
        }
    }

    public static void activeTests(DoubleArrayList doubleArrayList, double[] dArray, double[] dArray2) {
        double[] dArray3 = doubleArrayList.elements();
        int n = doubleArrayList.size();
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (dArray.length != 9 || dArray2.length != 9) {
            throw new IllegalArgumentException("sVal and pVal must be of length NTESTTYPES.");
        }
        if (n == 1) {
            dArray[0] = 1.0 - dArray3[0];
            dArray2[0] = 1.0 - dArray3[0];
            dArray2[7] = dArray2[0];
            return;
        }
        GofFormat.tests(doubleArrayList, dArray);
        if (activeTests.length != 9) {
            GofFormat.initActiveTests();
            System.err.println("activeTests was invalid, it was reinitialized.");
        }
        if (activeTests[0]) {
            dArray2[0] = KolmogorovSmirnovPlusDist.barF(n, dArray[0]);
        }
        if (activeTests[1]) {
            dArray2[1] = KolmogorovSmirnovPlusDist.barF(n, dArray[1]);
        }
        if (activeTests[2]) {
            dArray2[2] = KolmogorovSmirnovDistQuick.barF(n, dArray[2]);
        }
        if (activeTests[3]) {
            dArray2[3] = AndersonDarlingDistQuick.barF(n, dArray[3]);
        }
        if (activeTests[4]) {
            dArray2[4] = CramerVonMisesDist.barF(n, dArray[4]);
        }
        if (activeTests[5]) {
            dArray2[5] = WatsonGDist.barF(n, dArray[5]);
        }
        if (activeTests[6]) {
            dArray2[6] = WatsonUDist.barF(n, dArray[6]);
        }
    }

    public static void activeTests(DoubleArrayList doubleArrayList, ContinuousDistribution continuousDistribution, double[] dArray, double[] dArray2) {
        double[] dArray3 = doubleArrayList.elements();
        int n = doubleArrayList.size();
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        DoubleArrayList doubleArrayList2 = GofStat.unifTransform(doubleArrayList, continuousDistribution);
        doubleArrayList2.quickSortFromTo(0, doubleArrayList2.size() - 1);
        GofFormat.activeTests(doubleArrayList2, dArray, dArray2);
        if (n == 1) {
            dArray[7] = dArray3[0];
        }
    }

    public static String formatActiveTests(int n, double[] dArray, double[] dArray2) {
        if (activeTests.length != 9) {
            GofFormat.initActiveTests();
            System.err.println("activeTests was invalid, it was reinitialized.");
        }
        if (dArray.length != 9 || dArray2.length != 9) {
            throw new IllegalArgumentException("The length of sVal and pVal must be NTESTTYPES.");
        }
        if (n == 1) {
            return GofFormat.formatp1(dArray2[0]);
        }
        StringBuffer stringBuffer = new StringBuffer(PrintfFormat.NEWLINE);
        if (activeTests[0]) {
            stringBuffer.append("Kolmogorov-Smirnov+ statistic = D+    :" + GofFormat.formatp2(dArray[0], dArray2[0]));
        }
        if (activeTests[1]) {
            stringBuffer.append("Kolmogorov-Smirnov- statistic = D-    :" + GofFormat.formatp2(dArray[1], dArray2[1]));
        }
        if (activeTests[2]) {
            stringBuffer.append("Kolmogorov-Smirnov statistic  = D     :" + GofFormat.formatp2(dArray[2], dArray2[2]));
        }
        if (activeTests[3]) {
            stringBuffer.append("Anderson-Darling statistic = A2       :" + GofFormat.formatp2(dArray[3], dArray2[3]));
        }
        if (activeTests[4]) {
            stringBuffer.append("Cramer-von Mises statistic = W2       :" + GofFormat.formatp2(dArray[4], dArray2[4]));
        }
        if (activeTests[5]) {
            stringBuffer.append("Watson statistic = G                  :" + GofFormat.formatp2(dArray[5], dArray2[5]));
        }
        if (activeTests[6]) {
            stringBuffer.append("Watson statistic = U2                 :" + GofFormat.formatp2(dArray[6], dArray2[6]));
        }
        stringBuffer.append(PrintfFormat.NEWLINE);
        return stringBuffer.toString();
    }

    public static String iterSpacingsTests(DoubleArrayList doubleArrayList, int n, boolean bl, boolean bl2, PrintWriter printWriter) {
        int n2 = doubleArrayList.size();
        DoubleArrayList doubleArrayList2 = (DoubleArrayList)doubleArrayList.clone();
        DoubleArrayList doubleArrayList3 = new DoubleArrayList(doubleArrayList.size() + 2);
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        StringBuffer stringBuffer = new StringBuffer(PrintfFormat.NEWLINE);
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append("-----------------------------------" + PrintfFormat.NEWLINE + "EDF Tests after \"iterateSpacings\", level : " + PrintfFormat.d(2, i) + PrintfFormat.NEWLINE);
            GofStat.diff(doubleArrayList2, doubleArrayList3, 0, n2 - 1, 0.0, 1.0);
            GofStat.iterateSpacings(doubleArrayList2, doubleArrayList3);
            doubleArrayList2.quickSortFromTo(0, doubleArrayList2.size() - 1);
            GofFormat.activeTests(doubleArrayList2, dArray, dArray2);
            stringBuffer.append(GofFormat.formatActiveTests(n2, dArray, dArray2));
            String string = "Values of Uniforms after iterateSpacings, level " + PrintfFormat.d(2, i);
            if (bl) {
                stringBuffer.append(string + PrintfFormat.NEWLINE + "------------------------" + PrintfFormat.NEWLINE);
                stringBuffer.append(doubleArrayList2 + PrintfFormat.NEWLINE);
            }
            if (bl2 && printWriter != null) {
                printWriter.print(GofFormat.graphDistUnif(doubleArrayList2, string));
                continue;
            }
            if (!bl2 || printWriter != null) continue;
            stringBuffer.append(GofFormat.graphDistUnif(doubleArrayList2, string));
        }
        return stringBuffer.toString();
    }

    public static String iterPowRatioTests(DoubleArrayList doubleArrayList, int n, boolean bl, boolean bl2, PrintWriter printWriter) {
        int n2 = doubleArrayList.size();
        DoubleArrayList doubleArrayList2 = (DoubleArrayList)doubleArrayList.clone();
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        StringBuffer stringBuffer = new StringBuffer(PrintfFormat.NEWLINE);
        for (int i = 1; i <= n; ++i) {
            GofStat.powerRatios(doubleArrayList2);
            stringBuffer.append("-----------------------------------" + PrintfFormat.NEWLINE + "EDF Tests after \"powerRatios\", level : " + PrintfFormat.d(2, i) + PrintfFormat.NEWLINE);
            doubleArrayList2.quickSortFromTo(0, doubleArrayList2.size() - 1);
            GofFormat.activeTests(doubleArrayList2, dArray, dArray2);
            stringBuffer.append(GofFormat.formatActiveTests(n2, dArray, dArray2));
            String string = "Values of Uniforms after PowerRatios, level " + PrintfFormat.d(2, i);
            if (bl) {
                stringBuffer.append(string + PrintfFormat.NEWLINE + "--------------------------" + PrintfFormat.NEWLINE);
                stringBuffer.append(doubleArrayList2 + PrintfFormat.NEWLINE);
            }
            if (bl2 && printWriter != null) {
                printWriter.print(GofFormat.graphDistUnif(doubleArrayList2, string));
                continue;
            }
            if (!bl2 || printWriter != null) continue;
            stringBuffer.append(GofFormat.graphDistUnif(doubleArrayList2, string));
        }
        return stringBuffer.toString();
    }

    static {
        GofFormat.initActiveTests();
    }
}

