/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.pipe.iterator.DBInstanceIterator;
import cc.mallet.topics.ParallelTopicModel;
import cc.mallet.topics.TopicAssignment;
import cc.mallet.topics.TopicModelDiagnostics;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetFactory;
import cc.mallet.types.Dirichlet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.IDSorter;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Randoms;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class LabeledLDA
implements Serializable {
    protected static Logger logger = MalletLogger.getLogger(LabeledLDA.class.getName());
    static CommandOption.String inputFile = new CommandOption.String(LabeledLDA.class, "input", "FILENAME", true, null, "The filename from which to read the list of training instances.  Use - for stdin.  The instances must be FeatureSequence, not FeatureVector", null);
    static CommandOption.String outputPrefix = new CommandOption.String(LabeledLDA.class, "output-prefix", "STRING", true, null, "The prefix for output files (sampling states, parameters, etc)  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String inputModelFilename = new CommandOption.String(LabeledLDA.class, "input-model", "FILENAME", true, null, "The filename from which to read the binary topic model. The --input option is ignored. By default this is null, indicating that no file will be read.", null);
    static CommandOption.String inputStateFilename = new CommandOption.String(LabeledLDA.class, "input-state", "FILENAME", true, null, "The filename from which to read the gzipped Gibbs sampling state created by --output-state. The original input file must be included, using --input. By default this is null, indicating that no file will be read.", null);
    static CommandOption.String outputModelFilename = new CommandOption.String(LabeledLDA.class, "output-model", "FILENAME", true, null, "The filename in which to write the binary topic model at the end of the iterations.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String stateFile = new CommandOption.String(LabeledLDA.class, "output-state", "FILENAME", true, null, "The filename in which to write the Gibbs sampling state after at the end of the iterations.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.Integer outputModelInterval = new CommandOption.Integer(LabeledLDA.class, "output-model-interval", "INTEGER", true, 0, "The number of iterations between writing the model (and its Gibbs sampling state) to a binary file.  You must also set the --output-model to use this option, whose argument will be the prefix of the filenames.", null);
    static CommandOption.Integer outputStateInterval = new CommandOption.Integer(LabeledLDA.class, "output-state-interval", "INTEGER", true, 0, "The number of iterations between writing the sampling state to a text file.  You must also set the --output-state to use this option, whose argument will be the prefix of the filenames.", null);
    static CommandOption.String inferencerFilename = new CommandOption.String(LabeledLDA.class, "inferencer-filename", "FILENAME", true, null, "A topic inferencer applies a previously trained topic model to new documents.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String evaluatorFilename = new CommandOption.String(LabeledLDA.class, "evaluator-filename", "FILENAME", true, null, "A held-out likelihood evaluator for new documents.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String topicKeysFile = new CommandOption.String(LabeledLDA.class, "output-topic-keys", "FILENAME", true, null, "The filename in which to write the top words for each topic and any Dirichlet parameters.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.Integer numTopWords = new CommandOption.Integer(LabeledLDA.class, "num-top-words", "INTEGER", true, 20, "The number of most probable words to print for each topic after model estimation.", null);
    static CommandOption.Integer showTopicsIntervalOption = new CommandOption.Integer(LabeledLDA.class, "show-topics-interval", "INTEGER", true, 50, "The number of iterations between printing a brief summary of the topics so far.", null);
    static CommandOption.String topicWordWeightsFile = new CommandOption.String(LabeledLDA.class, "topic-word-weights-file", "FILENAME", true, null, "The filename in which to write unnormalized weights for every topic and word type.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String wordTopicCountsFile = new CommandOption.String(LabeledLDA.class, "word-topic-counts-file", "FILENAME", true, null, "The filename in which to write a sparse representation of topic-word assignments.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String diagnosticsFile = new CommandOption.String(LabeledLDA.class, "diagnostics-file", "FILENAME", true, null, "The filename in which to write measures of topic quality, in XML format.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String topicReportXMLFile = new CommandOption.String(LabeledLDA.class, "xml-topic-report", "FILENAME", true, null, "The filename in which to write the top words for each topic and any Dirichlet parameters in XML format.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String topicPhraseReportXMLFile = new CommandOption.String(LabeledLDA.class, "xml-topic-phrase-report", "FILENAME", true, null, "The filename in which to write the top words and phrases for each topic and any Dirichlet parameters in XML format.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.String topicDocsFile = new CommandOption.String(LabeledLDA.class, "output-topic-docs", "FILENAME", true, null, "The filename in which to write the most prominent documents for each topic, at the end of the iterations.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.Integer numTopDocs = new CommandOption.Integer(LabeledLDA.class, "num-top-docs", "INTEGER", true, 100, "When writing topic documents with --output-topic-docs, report this number of top documents.", null);
    static CommandOption.String docTopicsFile = new CommandOption.String(LabeledLDA.class, "output-doc-topics", "FILENAME", true, null, "The filename in which to write the topic proportions per document, at the end of the iterations.  By default this is null, indicating that no file will be written.", null);
    static CommandOption.Double docTopicsThreshold = new CommandOption.Double(LabeledLDA.class, "doc-topics-threshold", "DECIMAL", true, 0.0, "When writing topic proportions per document with --output-doc-topics, do not print topics with proportions less than this threshold value.", null);
    static CommandOption.Integer docTopicsMax = new CommandOption.Integer(LabeledLDA.class, "doc-topics-max", "INTEGER", true, -1, "When writing topic proportions per document with --output-doc-topics, do not print more than INTEGER number of topics.  A negative value indicates that all topics should be printed.", null);
    static CommandOption.Integer numIterationsOption = new CommandOption.Integer(LabeledLDA.class, "num-iterations", "INTEGER", true, 1000, "The number of iterations of Gibbs sampling.", null);
    static CommandOption.Boolean noInference = new CommandOption.Boolean(LabeledLDA.class, "no-inference", "true|false", false, false, "Do not perform inference, just load a saved model and create a report. Equivalent to --num-iterations 0.", null);
    static CommandOption.Integer randomSeed = new CommandOption.Integer(LabeledLDA.class, "random-seed", "INTEGER", true, 0, "The random seed for the Gibbs sampler.  Default is 0, which will use the clock.", null);
    static CommandOption.Double alphaOption = new CommandOption.Double(LabeledLDA.class, "alpha", "DECIMAL", true, 0.1, "Alpha parameter: smoothing over doc topic distribution (NOT the sum over topics).", null);
    static CommandOption.Double betaOption = new CommandOption.Double(LabeledLDA.class, "beta", "DECIMAL", true, 0.01, "Beta parameter: smoothing over word distributions.", null);
    protected ArrayList<TopicAssignment> data = new ArrayList();
    protected Alphabet alphabet;
    protected Alphabet labelAlphabet;
    protected LabelAlphabet topicAlphabet;
    protected int numTopics;
    protected int numTypes;
    protected double alpha;
    protected double beta;
    protected double betaSum;
    public static final double DEFAULT_BETA = 0.01;
    protected int[] oneDocTopicCounts;
    protected int[][] typeTopicCounts;
    protected int[] tokensPerTopic;
    public int numIterations = 1000;
    public int showTopicsInterval = 50;
    public int wordsPerTopic = 10;
    protected Randoms random;
    protected boolean printLogLikelihood = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public LabeledLDA(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.random = new Randoms();
        logger.info("Labeled LDA");
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public LabelAlphabet getTopicAlphabet() {
        return this.topicAlphabet;
    }

    public ArrayList<TopicAssignment> getData() {
        return this.data;
    }

    public void setTopicDisplay(int interval, int n) {
        this.showTopicsInterval = interval;
        this.wordsPerTopic = n;
    }

    public void setRandomSeed(int seed) {
        this.random = new Randoms(seed);
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public int[][] getTypeTopicCounts() {
        return this.typeTopicCounts;
    }

    public int[] getTopicTotals() {
        return this.tokensPerTopic;
    }

    public void addInstances(InstanceList training) {
        this.alphabet = training.getDataAlphabet();
        this.numTypes = this.alphabet.size();
        this.betaSum = this.beta * (double)this.numTypes;
        this.labelAlphabet = training.getTargetAlphabet();
        this.numTopics = this.labelAlphabet.size();
        this.oneDocTopicCounts = new int[this.numTopics];
        this.tokensPerTopic = new int[this.numTopics];
        this.typeTopicCounts = new int[this.numTypes][this.numTopics];
        this.topicAlphabet = AlphabetFactory.labelAlphabetOfSize(this.numTopics);
        int doc = 0;
        for (Instance instance : training) {
            ++doc;
            FeatureSequence tokens = (FeatureSequence)instance.getData();
            FeatureVector labels = (FeatureVector)instance.getTarget();
            LabelSequence topicSequence = new LabelSequence(this.topicAlphabet, new int[tokens.size()]);
            int[] topics = topicSequence.getFeatures();
            for (int position = 0; position < tokens.size(); ++position) {
                int topic;
                topics[position] = topic = labels.indexAtLocation(this.random.nextInt(labels.numLocations()));
                int n = topic;
                this.tokensPerTopic[n] = this.tokensPerTopic[n] + 1;
                int type = tokens.getIndexAtPosition(position);
                int[] nArray = this.typeTopicCounts[type];
                int n2 = topic;
                nArray[n2] = nArray[n2] + 1;
            }
            TopicAssignment t = new TopicAssignment(instance, topicSequence);
            this.data.add(t);
        }
    }

    public void initializeFromState(File stateFile) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(stateFile))));
        String line = reader.readLine();
        while (line.startsWith("#")) {
            line = reader.readLine();
        }
        String[] fields = line.split(" ");
        for (TopicAssignment document : this.data) {
            FeatureSequence tokens = (FeatureSequence)document.instance.getData();
            LabelSequence topicSequence = document.topicSequence;
            int[] topics = topicSequence.getFeatures();
            for (int position = 0; position < tokens.size(); ++position) {
                int topic;
                int type = tokens.getIndexAtPosition(position);
                if (type != Integer.parseInt(fields[3])) {
                    System.err.println("instance list and state do not match: " + line);
                    throw new IllegalStateException();
                }
                topics[position] = topic = Integer.parseInt(fields[5]);
                int[] nArray = this.typeTopicCounts[type];
                int n = topic;
                nArray[n] = nArray[n] + 1;
                line = reader.readLine();
                if (line == null) continue;
                fields = line.split(" ");
            }
        }
    }

    public void estimate() throws IOException {
        for (int iteration = 1; iteration <= this.numIterations; ++iteration) {
            long iterationStart = System.currentTimeMillis();
            for (int doc = 0; doc < this.data.size(); ++doc) {
                FeatureSequence tokenSequence = (FeatureSequence)this.data.get((int)doc).instance.getData();
                FeatureVector labels = (FeatureVector)this.data.get((int)doc).instance.getTarget();
                LabelSequence topicSequence = this.data.get((int)doc).topicSequence;
                this.sampleTopicsForOneDoc(tokenSequence, labels, topicSequence);
            }
            long elapsedMillis = System.currentTimeMillis() - iterationStart;
            logger.info(iteration + "\t" + elapsedMillis + "ms\t");
            if (this.showTopicsInterval == 0 || iteration % this.showTopicsInterval != 0) continue;
            logger.info("<" + iteration + "> Log Likelihood: " + this.modelLogLikelihood() + "\n" + this.topWords(this.wordsPerTopic));
        }
    }

    protected void sampleTopicsForOneDoc(FeatureSequence tokenSequence, FeatureVector labels, FeatureSequence topicSequence) {
        int[] possibleTopics = labels.getIndices();
        int numLabels = labels.numLocations();
        int[] oneDocTopics = topicSequence.getFeatures();
        int docLength = tokenSequence.getLength();
        int[] localTopicCounts = new int[this.numTopics];
        for (int position = 0; position < docLength; ++position) {
            int n = oneDocTopics[position];
            localTopicCounts[n] = localTopicCounts[n] + 1;
        }
        double[] topicTermScores = new double[numLabels];
        for (int position = 0; position < docLength; ++position) {
            int newTopic;
            int type = tokenSequence.getIndexAtPosition(position);
            int oldTopic = oneDocTopics[position];
            int[] currentTypeTopicCounts = this.typeTopicCounts[type];
            int n = oldTopic;
            localTopicCounts[n] = localTopicCounts[n] - 1;
            int n2 = oldTopic;
            this.tokensPerTopic[n2] = this.tokensPerTopic[n2] - 1;
            assert (this.tokensPerTopic[oldTopic] >= 0) : "old Topic " + oldTopic + " below 0";
            int n3 = oldTopic;
            currentTypeTopicCounts[n3] = currentTypeTopicCounts[n3] - 1;
            double sum = 0.0;
            for (int labelPosition = 0; labelPosition < numLabels; ++labelPosition) {
                int topic = possibleTopics[labelPosition];
                double score = (this.alpha + (double)localTopicCounts[topic]) * ((this.beta + (double)currentTypeTopicCounts[topic]) / (this.betaSum + (double)this.tokensPerTopic[topic]));
                sum += score;
                topicTermScores[labelPosition] = score;
            }
            int labelPosition = -1;
            for (double sample = this.random.nextUniform() * sum; sample > 0.0; sample -= topicTermScores[++labelPosition]) {
            }
            if (labelPosition == -1) {
                throw new IllegalStateException("LabeledLDA: New topic not sampled.");
            }
            oneDocTopics[position] = newTopic = possibleTopics[labelPosition];
            int n4 = newTopic;
            localTopicCounts[n4] = localTopicCounts[n4] + 1;
            int n5 = newTopic;
            this.tokensPerTopic[n5] = this.tokensPerTopic[n5] + 1;
            int n6 = newTopic;
            currentTypeTopicCounts[n6] = currentTypeTopicCounts[n6] + 1;
        }
    }

    public double modelLogLikelihood() {
        double logLikelihood = 0.0;
        int[] topicCounts = new int[this.numTopics];
        double[] topicLogGammas = new double[this.numTopics];
        for (int topic = 0; topic < this.numTopics; ++topic) {
            topicLogGammas[topic] = Dirichlet.logGamma(this.alpha);
        }
        for (int doc = 0; doc < this.data.size(); ++doc) {
            LabelSequence topicSequence = this.data.get((int)doc).topicSequence;
            FeatureVector labels = (FeatureVector)this.data.get((int)doc).instance.getTarget();
            int[] docTopics = topicSequence.getFeatures();
            for (int token = 0; token < docTopics.length; ++token) {
                int n = docTopics[token];
                topicCounts[n] = topicCounts[n] + 1;
            }
            for (int topic = 0; topic < this.numTopics; ++topic) {
                if (topicCounts[topic] <= 0) continue;
                logLikelihood += Dirichlet.logGamma(this.alpha + (double)topicCounts[topic]) - topicLogGammas[topic];
            }
            logLikelihood += Dirichlet.logGamma(this.alpha * (double)labels.numLocations());
            logLikelihood -= Dirichlet.logGamma(this.alpha * (double)labels.numLocations() + (double)docTopics.length);
            Arrays.fill(topicCounts, 0);
        }
        int nonZeroTypeTopics = 0;
        for (int type = 0; type < this.numTypes; ++type) {
            topicCounts = this.typeTopicCounts[type];
            for (int topic = 0; topic < this.numTopics; ++topic) {
                if (topicCounts[topic] == 0) continue;
                ++nonZeroTypeTopics;
                if (!Double.isNaN(logLikelihood += Dirichlet.logGamma(this.beta + (double)topicCounts[topic]))) continue;
                System.out.println(topicCounts[topic]);
                System.exit(1);
            }
        }
        for (int topic = 0; topic < this.numTopics; ++topic) {
            if (!Double.isNaN(logLikelihood -= Dirichlet.logGamma(this.beta * (double)this.numTopics + (double)this.tokensPerTopic[topic]))) continue;
            System.out.println("after topic " + topic + " " + this.tokensPerTopic[topic]);
            System.exit(1);
        }
        if (Double.isNaN(logLikelihood += Dirichlet.logGamma(this.beta * (double)this.numTopics) - Dirichlet.logGamma(this.beta) * (double)nonZeroTypeTopics)) {
            System.out.println("at the end");
            System.exit(1);
        }
        return logLikelihood;
    }

    public String topWords(int numWords) {
        StringBuilder output = new StringBuilder();
        Object[] sortedWords = new IDSorter[this.numTypes];
        for (int topic = 0; topic < this.numTopics; ++topic) {
            if (this.tokensPerTopic[topic] == 0) continue;
            for (int type = 0; type < this.numTypes; ++type) {
                sortedWords[type] = new IDSorter(type, this.typeTopicCounts[type][topic]);
            }
            Arrays.sort(sortedWords);
            output.append(topic + "\t" + this.labelAlphabet.lookupObject(topic) + "\t" + this.tokensPerTopic[topic] + "\t");
            for (int i = 0; i < numWords && ((IDSorter)sortedWords[i]).getWeight() != 0.0; ++i) {
                output.append(this.alphabet.lookupObject(((IDSorter)sortedWords[i]).getID()) + " ");
            }
            output.append("\n");
        }
        return output.toString();
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    public static LabeledLDA read(File f) throws Exception {
        LabeledLDA topicModel = null;
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
        topicModel = (LabeledLDA)ois.readObject();
        ois.close();
        return topicModel;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.data);
        out.writeObject(this.alphabet);
        out.writeObject(this.topicAlphabet);
        out.writeInt(this.numTopics);
        out.writeObject(this.alpha);
        out.writeDouble(this.beta);
        out.writeDouble(this.betaSum);
        out.writeInt(this.showTopicsInterval);
        out.writeInt(this.wordsPerTopic);
        out.writeObject(this.random);
        out.writeBoolean(this.printLogLikelihood);
        out.writeObject(this.typeTopicCounts);
        for (int ti = 0; ti < this.numTopics; ++ti) {
            out.writeInt(this.tokensPerTopic[ti]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.data = (ArrayList)in.readObject();
        this.alphabet = (Alphabet)in.readObject();
        this.topicAlphabet = (LabelAlphabet)in.readObject();
        this.numTopics = in.readInt();
        this.alpha = in.readDouble();
        this.beta = in.readDouble();
        this.betaSum = in.readDouble();
        this.showTopicsInterval = in.readInt();
        this.wordsPerTopic = in.readInt();
        this.random = (Randoms)in.readObject();
        this.printLogLikelihood = in.readBoolean();
        int numDocs = this.data.size();
        this.numTypes = this.alphabet.size();
        this.typeTopicCounts = (int[][])in.readObject();
        this.tokensPerTopic = new int[this.numTopics];
        for (int ti = 0; ti < this.numTopics; ++ti) {
            this.tokensPerTopic[ti] = in.readInt();
        }
    }

    public static void main(String[] args) throws Exception {
        ObjectOutputStream oos;
        PrintWriter out;
        CommandOption.setSummary(LabeledLDA.class, "Sample associations between words and labels");
        CommandOption.process(LabeledLDA.class, args);
        LabeledLDA labeledLDA = LabeledLDA.inputModelFilename.value != null ? LabeledLDA.read(new File(LabeledLDA.inputModelFilename.value)) : new LabeledLDA(LabeledLDA.alphaOption.value, LabeledLDA.betaOption.value);
        if (LabeledLDA.randomSeed.value != 0) {
            labeledLDA.setRandomSeed(LabeledLDA.randomSeed.value);
        }
        if (LabeledLDA.inputFile.value != null) {
            Object data;
            InstanceList training = null;
            try {
                training = LabeledLDA.inputFile.value.startsWith("db:") ? DBInstanceIterator.getInstances(LabeledLDA.inputFile.value.substring(3)) : InstanceList.load(new File(LabeledLDA.inputFile.value));
            }
            catch (Exception e) {
                logger.warning("Unable to restore instance list " + LabeledLDA.inputFile.value + ": " + e);
                System.exit(1);
            }
            logger.info("Data loaded.");
            if (training.size() > 0 && training.get(0) != null && !((data = ((Instance)training.get(0)).getData()) instanceof FeatureSequence)) {
                logger.warning("Topic modeling currently only supports feature sequences: use --keep-sequence option when importing data.");
                System.exit(1);
            }
            labeledLDA.addInstances(training);
        }
        if (LabeledLDA.inputStateFilename.value != null) {
            logger.info("Initializing from saved state.");
            labeledLDA.initializeFromState(new File(LabeledLDA.inputStateFilename.value));
        }
        labeledLDA.setTopicDisplay(LabeledLDA.showTopicsIntervalOption.value, LabeledLDA.numTopWords.value);
        labeledLDA.setNumIterations(LabeledLDA.numIterationsOption.value);
        if (!noInference.value()) {
            labeledLDA.estimate();
        }
        if (LabeledLDA.topicKeysFile.value != null) {
            PrintStream out2 = new PrintStream(new File(LabeledLDA.topicKeysFile.value));
            out2.print(labeledLDA.topWords(LabeledLDA.numTopWords.value));
            out2.close();
        }
        if (LabeledLDA.outputModelFilename.value != null) {
            assert (labeledLDA != null);
            try {
                ObjectOutputStream oos2 = new ObjectOutputStream(new FileOutputStream(LabeledLDA.outputModelFilename.value));
                oos2.writeObject(labeledLDA);
                oos2.close();
            }
            catch (Exception e) {
                logger.warning("Couldn't write topic model to filename " + LabeledLDA.outputModelFilename.value);
            }
        }
        ParallelTopicModel topicModel = new ParallelTopicModel(labeledLDA.topicAlphabet, labeledLDA.alpha * (double)labeledLDA.numTopics, labeledLDA.beta);
        topicModel.data = labeledLDA.data;
        topicModel.alphabet = labeledLDA.alphabet;
        topicModel.numTypes = labeledLDA.numTypes;
        topicModel.betaSum = labeledLDA.betaSum;
        topicModel.buildInitialTypeTopicCounts();
        if (LabeledLDA.diagnosticsFile.value != null) {
            out = new PrintWriter(LabeledLDA.diagnosticsFile.value);
            TopicModelDiagnostics diagnostics = new TopicModelDiagnostics(topicModel, LabeledLDA.numTopWords.value);
            out.println(diagnostics.toXML());
            out.close();
        }
        if (LabeledLDA.topicReportXMLFile.value != null) {
            out = new PrintWriter(LabeledLDA.topicReportXMLFile.value);
            topicModel.topicXMLReport(out, LabeledLDA.numTopWords.value);
            out.close();
        }
        if (LabeledLDA.topicPhraseReportXMLFile.value != null) {
            out = new PrintWriter(LabeledLDA.topicPhraseReportXMLFile.value);
            topicModel.topicPhraseXMLReport(out, LabeledLDA.numTopWords.value);
            out.close();
        }
        if (LabeledLDA.stateFile.value != null && LabeledLDA.outputStateInterval.value == 0) {
            topicModel.printState(new File(LabeledLDA.stateFile.value));
        }
        if (LabeledLDA.topicDocsFile.value != null) {
            out = new PrintWriter(new FileWriter(new File(LabeledLDA.topicDocsFile.value)));
            topicModel.printTopicDocuments(out, LabeledLDA.numTopDocs.value);
            out.close();
        }
        if (LabeledLDA.docTopicsFile.value != null) {
            out = new PrintWriter(new FileWriter(new File(LabeledLDA.docTopicsFile.value)));
            if (LabeledLDA.docTopicsThreshold.value == 0.0) {
                topicModel.printDenseDocumentTopics(out);
            } else {
                topicModel.printDocumentTopics(out, LabeledLDA.docTopicsThreshold.value, LabeledLDA.docTopicsMax.value);
            }
            out.close();
        }
        if (LabeledLDA.topicWordWeightsFile.value != null) {
            topicModel.printTopicWordWeights(new File(LabeledLDA.topicWordWeightsFile.value));
        }
        if (LabeledLDA.wordTopicCountsFile.value != null) {
            topicModel.printTypeTopicCounts(new File(LabeledLDA.wordTopicCountsFile.value));
        }
        if (LabeledLDA.inferencerFilename.value != null) {
            try {
                oos = new ObjectOutputStream(new FileOutputStream(LabeledLDA.inferencerFilename.value));
                oos.writeObject(topicModel.getInferencer());
                oos.close();
            }
            catch (Exception e) {
                logger.warning("Couldn't create inferencer: " + e.getMessage());
            }
        }
        if (LabeledLDA.evaluatorFilename.value != null) {
            try {
                oos = new ObjectOutputStream(new FileOutputStream(LabeledLDA.evaluatorFilename.value));
                oos.writeObject(topicModel.getProbEstimator());
                oos.close();
            }
            catch (Exception e) {
                logger.warning("Couldn't create evaluator: " + e.getMessage());
            }
        }
    }
}

