## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

library(tictoc)
mustashe::clear_stash()

## ----setup--------------------------------------------------------------------
library(mustashe)

## -----------------------------------------------------------------------------
library(mustashe)

## -----------------------------------------------------------------------------
tic("long-running computation")

stash("x", {
  Sys.sleep(5)
  x <- 5
})

toc()

## -----------------------------------------------------------------------------
x

## -----------------------------------------------------------------------------
tic("long-running computation")

stash("x", {
  Sys.sleep(5)
  x <- 5
})

toc()

## -----------------------------------------------------------------------------
tic()
stash("a", {
  Sys.sleep(3)
  a <- runif(5)
})
toc()

## -----------------------------------------------------------------------------
tic()
stash("a", {
  Sys.sleep(3)
  a <- runif(10)
})
toc()

## -----------------------------------------------------------------------------
stash("a", {
  Sys.sleep(3)
  # Here is a new comment.
  a <- runif(10)
})

## -----------------------------------------------------------------------------
stash("a", {
  Sys.sleep(3)

  # Here is a comment.

  a <- runif(10) # Another comment
})

## -----------------------------------------------------------------------------
x <- 1

stash("y", depends_on = "x", {
  y <- x + 1
})

# Value of `y`
y

## -----------------------------------------------------------------------------
stash("y", depends_on = "x", {
  y <- x + 1
})

## -----------------------------------------------------------------------------
x <- 100

stash("y", depends_on = "x", {
  y <- x + 1
})

# Value of `y`
y

## -----------------------------------------------------------------------------
stash("y", depends_on = c("x", "a"), {
  y <- x + a
})

## -----------------------------------------------------------------------------
unstash("a")

## -----------------------------------------------------------------------------
clear_stash()

## -----------------------------------------------------------------------------
use_here()

## -----------------------------------------------------------------------------
dont_use_here()

## ---- echo=FALSE--------------------------------------------------------------
unlink(".mustashe", recursive = TRUE)

