/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.sentdetect.SentenceModelLoader;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public final class SentenceDetectorTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "learnable sentence detector";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
        } else {
            SentenceModel model = (SentenceModel)new SentenceModelLoader().load(new File(args[0]));
            SentenceDetectorME sdetector = new SentenceDetectorME(model);
            ParagraphStream paraStream = new ParagraphStream(new PlainTextByLineStream(new InputStreamReader(System.in)));
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
            perfMon.start();
            try {
                String para;
                while ((para = (String)paraStream.read()) != null) {
                    String[] sents;
                    for (String sentence : sents = sdetector.sentDetect(para)) {
                        System.out.println(sentence);
                    }
                    perfMon.incrementCounter(sents.length);
                    System.out.println();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

