## -----------------------------------------------------------------------------
library(plantecowrap)
Tleaf <- seq(from = 10, to = 35, by = 5)
Tleaf <- sort(rep(Tleaf, 15))

Vcmax_start <- 90 * modarrhenius(Ea = 35, Hd = 220, dS = 0.3, Tleaf = Tleaf)
Jmax_start <- 140 * modarrhenius(Ea = 80, Hd = 220, dS = 0.6, Tleaf = Tleaf)
R_start <- 1.5 * arrhenius(Ea = 20, Tleaf = Tleaf)
GammaStar_start <- 42.75 * arrhenius(Ea = 37.83, Tleaf = Tleaf)
Km_start <- 718.40 * arrhenius(Ea = 65.50828, Tleaf = Tleaf)
Ci <- rep(c(75, 100, 150, 200, 250,
        300, 350, 400, 600, 800,
        1000, 1200, 1400, 1600, 1800), 6)
A <- 1:90
Vc <- 1:90
Vj <- 1:90
for(i in seq_along(A)){
Vc[i] <- (Vcmax_start[i] * (Ci[i] - GammaStar_start[i]) / 
               (Ci[i] + Km_start[i]))
Vj[i] <- (Jmax_start[i] * (Ci[i] - GammaStar_start[i]) / 
            (4 * Ci[i] + 8 * GammaStar_start[i]))
if(Vc[i] < 0){
  Vc[i] <- NA
}
if(Vj[i] < 0){
  Vj[i] <- NA
}
A[i] <- min(Vc[i], Vj[i]) - R_start[i]
}

PPFD <- rep(2000, 90)
Press <- rep(100, 90)

data <- data.frame(cbind(A,
                         Ci,
                         Tleaf,
                         Press,
                         PPFD))

data2 <- data.frame(cbind(A,
                         Ci,
                         Tleaf,
                         Press,
                         PPFD))
data2$A <- data2$A * 2

data$Treat <- as.character(Tleaf)
data2$Treat <- as.character(Tleaf)
data2 <- rbind(data, data2)
data2$Block <- c(rep("a", nrow(data)),
                 rep("b", nrow(data)))
data2 <- unite(data2, col = "Grouping", c("Treat", "Block"), sep = "_")

