/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.Text;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.AttributeFactory;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLNamespace;
import org.xmlcml.cml.base.CMLUtil;

public class CMLNodeFactory
extends NodeFactory
implements CMLConstants {
    private static Logger LOG = Logger.getLogger(CMLNodeFactory.class);
    private Element current;
    private Stack<Element> stack = new Stack();
    private Map<String, CMLElement> factoryElementMap = new HashMap<String, CMLElement>();
    public static final CMLNodeFactory nodeFactory = new CMLNodeFactory();

    private CMLNodeFactory() {
    }

    void init() {
    }

    public static Class<?> makeClass(String base, String name) {
        Class<?> newClass = null;
        String className = null;
        try {
            className = CMLNodeFactory.makeClassName(base, name);
            newClass = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot create class " + className, e);
        }
        return newClass;
    }

    private static String makeClassName(String base, String name) {
        return base + "." + CMLUtil.makeCMLName(name);
    }

    public Nodes finishMakingElement(Element element) {
        Element parent = this.stack.pop();
        if (this.current instanceof CMLElement) {
            ((CMLElement)this.current).finishMakingElement(parent);
        }
        this.current = parent;
        Nodes nodes = new Nodes();
        nodes.append((Node)element);
        return nodes;
    }

    public Nodes makeAttribute(String attributeName, String URI2, String value, Attribute.Type type) {
        Nodes nodes = new Nodes();
        Attribute attribute = null;
        int prefixLoc = attributeName.indexOf(":");
        if (URI2 != null && URI2.trim().length() != 0 && prefixLoc != -1) {
            attribute = new Attribute(attributeName, URI2, value);
        } else if (this.current instanceof CMLElement) {
            CMLElement currentCML = (CMLElement)this.current;
            String attributeGroupName = AttributeFactory.attributeFactory.getAttributeGroupName(attributeName, currentCML.getLocalName());
            if (attributeGroupName == null) {
                attribute = new Attribute(attributeName, value);
            } else {
                attribute = AttributeFactory.attributeFactory.getAttributeByGroupName(attributeGroupName);
                ((CMLAttribute)attribute).setCMLValue(value);
            }
        } else if (prefixLoc == -1) {
            attribute = new Attribute(attributeName, value);
        } else if (prefixLoc != -1) {
            attribute = new Attribute(attributeName, URI2, value);
        }
        if (attribute != null) {
            nodes.append((Node)attribute);
        }
        return nodes;
    }

    public Nodes makeText(String text) {
        Nodes nodes = new Nodes();
        nodes.append((Node)new Text(text));
        return nodes;
    }

    public static void main(String text) {
    }

    public Element startMakingElement(String name, String namespace) {
        Element newElement;
        int idx = name.indexOf(":");
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        if ((namespace = CMLNamespace.guessNamespace(namespace)).equals(null)) {
            newElement = new Element(name);
        } else if (namespace.trim().length() == 0) {
            newElement = new Element(name);
        } else if (!namespace.equals("http://www.xml-cml.org/schema")) {
            newElement = new Element(name, namespace);
        } else {
            CMLElement factoryElement = this.factoryElementMap.get(name);
            if (factoryElement == null) {
                Class<?> newClass = CMLNodeFactory.makeClass("org.xmlcml.cml.element", name);
                if (newClass == null) {
                    throw new RuntimeException("Cannot make class for: " + name);
                }
                try {
                    factoryElement = (CMLElement)newClass.newInstance();
                }
                catch (Exception e) {
                    LOG.error((Object)("CLASS " + newClass));
                    LOG.error((Object)newClass.getName());
                    e.printStackTrace();
                    throw new RuntimeException("Cannot instantiate because: " + name + "[" + e + "]");
                }
                this.factoryElementMap.put(name, factoryElement);
            }
            newElement = factoryElement.makeElementInContext(this.current);
        }
        this.stack.push(this.current);
        this.current = newElement;
        return newElement;
    }

    static {
        nodeFactory.init();
    }
}

