/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestLineStyles
extends TestingPanel {
    static float[] dash1 = new float[2];
    static float[] dash2;
    static float[] dash3;
    static Stroke[][] strokes;

    public TestLineStyles(String[] args) throws Exception {
        super(args);
        this.setName("Line Styles");
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g != null) {
            VectorGraphics vg = VectorGraphics.create((Graphics)g);
            Dimension dim = this.getSize();
            Insets insets = this.getInsets();
            vg.setColor(Color.white);
            vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
            int dw = dim.width / 3;
            int dh = dim.height / 3;
            int size = Math.min(dw, dh) * 2 / 3 / 2;
            vg.setColor(Color.black);
            vg.setStroke((Stroke)new BasicStroke(0.0f));
            vg.drawLine(0, dim.height / 40, dim.width, dim.height / 40);
            GeneralPath sshape = new GeneralPath();
            sshape.moveTo(size, size);
            sshape.lineTo(-size, size);
            sshape.lineTo(-size, size / 2);
            sshape.lineTo(size, size / 2);
            sshape.lineTo(size, -size / 2);
            sshape.lineTo(-size, -size / 2);
            sshape.lineTo(-size, -size);
            sshape.lineTo(size, -size);
            for (int iy = 0; iy < 3; ++iy) {
                int y = iy * dh + dh / 2;
                for (int ix = 0; ix < 3; ++ix) {
                    int x = ix * dw + dw / 2;
                    vg.setStroke(strokes[ix][iy]);
                    AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
                    vg.draw(sshape.createTransformedShape(xform));
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestLineStyles(args).runTest();
    }

    static {
        TestLineStyles.dash1[0] = 5.0f;
        TestLineStyles.dash1[1] = 2.0f;
        dash2 = new float[2];
        TestLineStyles.dash2[0] = 0.0f;
        TestLineStyles.dash2[1] = 7.0f;
        dash3 = new float[4];
        TestLineStyles.dash3[0] = 10.0f;
        TestLineStyles.dash3[1] = 5.0f;
        TestLineStyles.dash3[2] = 2.0f;
        TestLineStyles.dash3[3] = 5.0f;
        strokes = new Stroke[3][3];
        TestLineStyles.strokes[0][0] = new BasicStroke(3.0f, 0, 2, 10.0f, dash1, 0.0f);
        TestLineStyles.strokes[0][1] = new BasicStroke(5.0f, 0, 2, 10.0f, dash1, 0.0f);
        TestLineStyles.strokes[0][2] = new BasicStroke(20.0f, 0, 2, 10.0f);
        TestLineStyles.strokes[1][0] = new BasicStroke(3.0f, 1, 0, 10.0f, dash2, 0.0f);
        TestLineStyles.strokes[1][1] = new BasicStroke(5.0f, 1, 0, 10.0f, dash2, 0.0f);
        TestLineStyles.strokes[1][2] = new BasicStroke(20.0f, 1, 0, 10.0f);
        TestLineStyles.strokes[2][0] = new BasicStroke(3.0f, 2, 1, 10.0f, dash3, 0.0f);
        TestLineStyles.strokes[2][1] = new BasicStroke(5.0f, 2, 1, 10.0f, dash3, 0.0f);
        TestLineStyles.strokes[2][2] = new BasicStroke(20.0f, 2, 1, 10.0f);
    }
}

