/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import org.openscience.cdk.hash.AtomEncoder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;

public enum BasicAtomEncoder implements AtomEncoder
{
    ATOMIC_NUMBER{

        public int encode(IAtom atom, IAtomContainer container) {
            Integer atomicNumber = atom.getAtomicNumber();
            return atomicNumber != null ? atomicNumber : 32451169;
        }
    }
    ,
    MASS_NUMBER{

        public int encode(IAtom atom, IAtomContainer container) {
            Integer massNumber = atom.getMassNumber();
            return massNumber != null ? massNumber : 32451179;
        }
    }
    ,
    FORMAL_CHARGE{

        public int encode(IAtom atom, IAtomContainer container) {
            Integer formalCharge = atom.getFormalCharge();
            return formalCharge != null ? formalCharge : 32451193;
        }
    }
    ,
    N_CONNECTED_ATOMS{

        public int encode(IAtom atom, IAtomContainer container) {
            return container.getConnectedBondsCount(atom);
        }
    }
    ,
    BOND_ORDER_SUM{

        public int encode(IAtom atom, IAtomContainer container) {
            return Double.valueOf(container.getBondOrderSum(atom)).hashCode();
        }
    }
    ,
    ORBITAL_HYBRIDIZATION{

        public int encode(IAtom atom, IAtomContainer container) {
            IAtomType.Hybridization hybridization = atom.getHybridization();
            return hybridization != null ? hybridization.ordinal() : 32451301;
        }
    }
    ,
    FREE_RADICALS{

        public int encode(IAtom atom, IAtomContainer container) {
            return container.getConnectedSingleElectronsCount(atom);
        }
    };

}

