/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    private static boolean ignoreMissingEndBoundary = true;
    private static boolean ignoreMissingBoundaryParameter = true;
    private static boolean bmparse = true;
    protected DataSource ds = null;
    protected boolean parsed = true;
    private boolean complete = true;
    private String preamble = null;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype2) {
        String boundary = UniqueValue.getUniqueBoundaryValue();
        ContentType cType = new ContentType("multipart", subtype2, null);
        cType.setParameter("boundary", boundary);
        this.contentType = cType.toString();
    }

    public MimeMultipart(DataSource ds) throws MessagingException {
        if (ds instanceof MessageAware) {
            MessageContext mc = ((MessageAware)((Object)ds)).getMessageContext();
            this.setParent(mc.getPart());
        }
        if (ds instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)ds);
            return;
        }
        this.parsed = false;
        this.ds = ds;
        this.contentType = ds.getContentType();
    }

    public synchronized void setSubType(String subtype2) throws MessagingException {
        ContentType cType = new ContentType(this.contentType);
        cType.setSubType(subtype2);
        this.contentType = cType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int index2) throws MessagingException {
        this.parse();
        return super.getBodyPart(index2);
    }

    public synchronized BodyPart getBodyPart(String CID) throws MessagingException {
        this.parse();
        int count2 = this.getCount();
        for (int i = 0; i < count2; ++i) {
            MimeBodyPart part = (MimeBodyPart)this.getBodyPart(i);
            String s = part.getContentID();
            if (s == null || !s.equals(CID)) continue;
            return part;
        }
        return null;
    }

    public boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public void setPreamble(String preamble) throws MessagingException {
        this.preamble = preamble;
    }

    protected void updateHeaders() throws MessagingException {
        for (int i = 0; i < this.parts.size(); ++i) {
            ((MimeBodyPart)this.parts.elementAt(i)).updateHeaders();
        }
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.parse();
        String boundary = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream los = new LineOutputStream(os);
        if (this.preamble != null) {
            byte[] pb = ASCIIUtility.getBytes(this.preamble);
            los.write(pb);
            if (pb.length > 0 && pb[pb.length - 1] != 13 && pb[pb.length - 1] != 10) {
                los.writeln();
            }
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            los.writeln(boundary);
            ((MimeBodyPart)this.parts.elementAt(i)).writeTo(os);
            los.writeln();
        }
        los.writeln(boundary + "--");
    }

    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        if (bmparse) {
            this.parsebm();
            return;
        }
        InputStream in = null;
        SharedInputStream sin = null;
        long start = 0L;
        long end = 0L;
        try {
            in = this.ds.getInputStream();
            if (!(in instanceof ByteArrayInputStream || in instanceof BufferedInputStream || in instanceof SharedInputStream)) {
                in = new BufferedInputStream(in);
            }
        }
        catch (Exception ex) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (in instanceof SharedInputStream) {
            sin = (SharedInputStream)((Object)in);
        }
        ContentType cType = new ContentType(this.contentType);
        String boundary = null;
        String bp = cType.getParameter("boundary");
        if (bp != null) {
            boundary = "--" + bp;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            String line;
            LineInputStream lin = new LineInputStream(in);
            String lineSeparator = null;
            while ((line = lin.readLine()) != null) {
                char c;
                int i;
                for (i = line.length() - 1; i >= 0 && ((c = line.charAt(i)) == ' ' || c == '\t'); --i) {
                }
                line = line.substring(0, i + 1);
                if (boundary != null) {
                    if (line.equals(boundary)) {
                        break;
                    }
                } else if (line.startsWith("--")) {
                    boundary = line;
                    break;
                }
                if (line.length() <= 0) continue;
                if (lineSeparator == null) {
                    try {
                        lineSeparator = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException ex) {
                        lineSeparator = "\n";
                    }
                }
                if (this.preamble == null) {
                    this.preamble = line + lineSeparator;
                    continue;
                }
                this.preamble = this.preamble + line + lineSeparator;
            }
            if (line == null) {
                throw new MessagingException("Missing start boundary");
            }
            byte[] bndbytes = ASCIIUtility.getBytes(boundary);
            int bl = bndbytes.length;
            boolean done = false;
            while (!done) {
                InternetHeaders headers = null;
                if (sin != null) {
                    start = sin.getPosition();
                    while ((line = lin.readLine()) != null && line.length() > 0) {
                    }
                    if (line == null) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        break;
                    }
                } else {
                    headers = this.createInternetHeaders(in);
                }
                if (!in.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteArrayOutputStream buf = null;
                if (sin == null) {
                    buf = new ByteArrayOutputStream();
                } else {
                    end = sin.getPosition();
                }
                boolean bol = true;
                int eol1 = -1;
                int eol2 = -1;
                while (true) {
                    int b;
                    if (bol) {
                        int i;
                        in.mark(bl + 4 + 1000);
                        for (i = 0; i < bl && in.read() == (bndbytes[i] & 0xFF); ++i) {
                        }
                        if (i == bl) {
                            int b2 = in.read();
                            if (b2 == 45 && in.read() == 45) {
                                this.complete = true;
                                done = true;
                                break;
                            }
                            while (b2 == 32 || b2 == 9) {
                                b2 = in.read();
                            }
                            if (b2 == 10) break;
                            if (b2 == 13) {
                                in.mark(1);
                                if (in.read() == 10) break;
                                in.reset();
                                break;
                            }
                        }
                        in.reset();
                        if (buf != null && eol1 != -1) {
                            buf.write(eol1);
                            if (eol2 != -1) {
                                buf.write(eol2);
                            }
                            eol2 = -1;
                            eol1 = -1;
                        }
                    }
                    if ((b = in.read()) < 0) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        done = true;
                        break;
                    }
                    if (b == 13 || b == 10) {
                        bol = true;
                        if (sin != null) {
                            end = sin.getPosition() - 1L;
                        }
                        eol1 = b;
                        if (b != 13) continue;
                        in.mark(1);
                        b = in.read();
                        if (b == 10) {
                            eol2 = b;
                            continue;
                        }
                        in.reset();
                        continue;
                    }
                    bol = false;
                    if (buf == null) continue;
                    buf.write(b);
                }
                MimeBodyPart part = sin != null ? this.createMimeBodyPart(sin.newStream(start, end)) : this.createMimeBodyPart(headers, buf.toByteArray());
                this.addBodyPart(part);
            }
        }
        catch (IOException ioex) {
            throw new MessagingException("IO Error", ioex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException cex) {}
        }
        this.parsed = true;
    }

    private synchronized void parsebm() throws MessagingException {
        if (this.parsed) {
            return;
        }
        InputStream in = null;
        SharedInputStream sin = null;
        long start = 0L;
        long end = 0L;
        try {
            in = this.ds.getInputStream();
            if (!(in instanceof ByteArrayInputStream || in instanceof BufferedInputStream || in instanceof SharedInputStream)) {
                in = new BufferedInputStream(in);
            }
        }
        catch (Exception ex) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (in instanceof SharedInputStream) {
            sin = (SharedInputStream)((Object)in);
        }
        ContentType cType = new ContentType(this.contentType);
        String boundary = null;
        String bp = cType.getParameter("boundary");
        if (bp != null) {
            boundary = "--" + bp;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            String line;
            LineInputStream lin = new LineInputStream(in);
            String lineSeparator = null;
            while ((line = lin.readLine()) != null) {
                char c;
                int i;
                for (i = line.length() - 1; i >= 0 && ((c = line.charAt(i)) == ' ' || c == '\t'); --i) {
                }
                line = line.substring(0, i + 1);
                if (boundary != null) {
                    if (line.equals(boundary)) {
                        break;
                    }
                } else if (line.startsWith("--")) {
                    boundary = line;
                    break;
                }
                if (line.length() <= 0) continue;
                if (lineSeparator == null) {
                    try {
                        lineSeparator = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException ex) {
                        lineSeparator = "\n";
                    }
                }
                if (this.preamble == null) {
                    this.preamble = line + lineSeparator;
                    continue;
                }
                this.preamble = this.preamble + line + lineSeparator;
            }
            if (line == null) {
                throw new MessagingException("Missing start boundary");
            }
            byte[] bndbytes = ASCIIUtility.getBytes(boundary);
            int bl = bndbytes.length;
            int[] bcs = new int[256];
            for (int i = 0; i < bl; ++i) {
                bcs[bndbytes[i]] = i + 1;
            }
            int[] gss = new int[bl];
            block16: for (int i = bl; i > 0; --i) {
                int j;
                for (j = bl - 1; j >= i; --j) {
                    if (bndbytes[j] != bndbytes[j - i]) continue block16;
                    gss[j - 1] = i;
                }
                while (j > 0) {
                    gss[--j] = i;
                }
            }
            gss[bl - 1] = 1;
            boolean done = false;
            while (!done) {
                MimeBodyPart part;
                int eolLen;
                InternetHeaders headers = null;
                if (sin != null) {
                    start = sin.getPosition();
                    while ((line = lin.readLine()) != null && line.length() > 0) {
                    }
                    if (line == null) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        break;
                    }
                } else {
                    headers = this.createInternetHeaders(in);
                }
                if (!in.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteArrayOutputStream buf = null;
                if (sin == null) {
                    buf = new ByteArrayOutputStream();
                } else {
                    end = sin.getPosition();
                }
                byte[] inbuf = new byte[bl];
                byte[] previnbuf = new byte[bl];
                int inSize = 0;
                int prevSize = 0;
                boolean first = true;
                while (true) {
                    int skip;
                    int i;
                    in.mark(bl + 4 + 1000);
                    eolLen = 0;
                    inSize = in.read(inbuf, 0, bl);
                    if (inSize < bl) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        if (sin != null) {
                            end = sin.getPosition();
                        }
                        this.complete = false;
                        done = true;
                        break;
                    }
                    for (i = bl - 1; i >= 0 && inbuf[i] == bndbytes[i]; --i) {
                    }
                    if (i < 0) {
                        byte b;
                        eolLen = 0;
                        if (!(first || (b = previnbuf[prevSize - 1]) != 13 && b != 10)) {
                            eolLen = 1;
                            if (b == 10 && prevSize >= 2 && (b = previnbuf[prevSize - 2]) == 13) {
                                eolLen = 2;
                            }
                        }
                        if (first || eolLen > 0) {
                            int b2;
                            if (sin != null) {
                                end = sin.getPosition() - (long)bl - (long)eolLen;
                            }
                            if ((b2 = in.read()) == 45 && in.read() == 45) {
                                this.complete = true;
                                done = true;
                                break;
                            }
                            while (b2 == 32 || b2 == 9) {
                                b2 = in.read();
                            }
                            if (b2 == 10) break;
                            if (b2 == 13) {
                                in.mark(1);
                                if (in.read() == 10) break;
                                in.reset();
                                break;
                            }
                        }
                        i = 0;
                    }
                    if ((skip = Math.max(i + 1 - bcs[inbuf[i] & 0x7F], gss[i])) < 2) {
                        if (sin == null && prevSize > 1) {
                            buf.write(previnbuf, 0, prevSize - 1);
                        }
                        in.reset();
                        in.skip(1L);
                        if (prevSize >= 1) {
                            previnbuf[0] = previnbuf[prevSize - 1];
                            previnbuf[1] = inbuf[0];
                            prevSize = 2;
                        } else {
                            previnbuf[0] = inbuf[0];
                            prevSize = 1;
                        }
                    } else {
                        if (prevSize > 0 && sin == null) {
                            buf.write(previnbuf, 0, prevSize);
                        }
                        prevSize = skip;
                        in.reset();
                        in.skip(prevSize);
                        byte[] tmp = inbuf;
                        inbuf = previnbuf;
                        previnbuf = tmp;
                    }
                    first = false;
                }
                if (sin != null) {
                    part = this.createMimeBodyPart(sin.newStream(start, end));
                } else {
                    if (prevSize - eolLen > 0) {
                        buf.write(previnbuf, 0, prevSize - eolLen);
                    }
                    if (!this.complete && inSize > 0) {
                        buf.write(inbuf, 0, inSize);
                    }
                    part = this.createMimeBodyPart(headers, buf.toByteArray());
                }
                this.addBodyPart(part);
            }
        }
        catch (IOException ioex) {
            throw new MessagingException("IO Error", ioex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException cex) {}
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        return new InternetHeaders(is);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        return new MimeBodyPart(headers, content);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream is) throws MessagingException {
        return new MimeBodyPart(is);
    }

    static {
        try {
            String s = System.getProperty("mail.mime.multipart.ignoremissingendboundary");
            ignoreMissingEndBoundary = s == null || !s.equalsIgnoreCase("false");
            s = System.getProperty("mail.mime.multipart.ignoremissingboundaryparameter");
            ignoreMissingBoundaryParameter = s == null || !s.equalsIgnoreCase("false");
            s = System.getProperty("mail.mime.multipart.bmparse");
            bmparse = s == null || !s.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

