/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Binomial;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;
import jdistlib.util.Bool3;

public class Beta
extends GenericDistribution {
    protected double a;
    protected double b;

    public static final double density(double x, double a, double b, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return x + a + b;
        }
        if (a < 0.0 || b < 0.0) {
            return Double.NaN;
        }
        if (x < 0.0 || x > 1.0) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (a == 0.0 || b == 0.0 || MathFunctions.isInfinite(a) || MathFunctions.isInfinite(b)) {
            if (a == 0.0 && b == 0.0) {
                if (x == 0.0 || x == 1.0) {
                    return Double.POSITIVE_INFINITY;
                }
                return log_p ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (a == 0.0 || a / b == 0.0) {
                if (x == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                return log_p ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (b == 0.0 || b / a == 0.0) {
                if (x == 1.0) {
                    return Double.POSITIVE_INFINITY;
                }
                return log_p ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (x == 0.5) {
                return Double.POSITIVE_INFINITY;
            }
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x == 0.0) {
            if (a > 1.0) {
                return log_p ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (a < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return log_p ? Math.log(b) : b;
        }
        if (x == 1.0) {
            if (b > 1.0) {
                return log_p ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (b < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return log_p ? Math.log(a) : a;
        }
        double lval = a <= 2.0 || b <= 2.0 ? (a - 1.0) * Math.log(x) + (b - 1.0) * Math.log1p(-x) - MathFunctions.lbeta(a, b) : Math.log(a + b - 1.0) + Binomial.density_raw(a - 1.0, a + b - 2.0, x, 1.0 - x, true);
        return log_p ? lval : Math.exp(lval);
    }

    public static final double cumulative_raw(double x, double a, double b, boolean lower_tail, boolean log_p) {
        if (a == 0.0 || b == 0.0 || MathFunctions.isInfinite(a) || MathFunctions.isInfinite(b)) {
            if (a == 0.0 && b == 0.0) {
                return log_p ? -0.6931471805599453 : 0.5;
            }
            if (a == 0.0 || a / b == 0.0) {
                return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
            }
            if (b == 0.0 || b / a == 0.0) {
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            if (x < 0.5) {
                return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
            }
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        double x1 = 0.5 - x + 0.5;
        double[] temp = MathFunctions.bratio(a, b, x, x1, log_p);
        double w = temp[0];
        double wc = temp[1];
        int ierr = (int)temp[2];
        if (ierr > 0 && ierr != 11 && ierr != 14) {
            return Double.NaN;
        }
        return lower_tail ? w : wc;
    }

    public static final double cumulative(double x, double a, double b, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return x + a + b;
        }
        if (a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (x >= 1.0) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        return Beta.cumulative_raw(x, a, b, lower_tail, log_p);
    }

    public static final double quantile(double alpha, double p, double q, boolean lower_tail, boolean log_p) {
        double w;
        double qq;
        double pp;
        double la;
        double a;
        boolean swap_tail;
        boolean give_log_q;
        if (Double.isNaN(p) || Double.isNaN(q) || Double.isNaN(alpha)) {
            return p + q + alpha;
        }
        if (p < 0.0 || q < 0.0) {
            return Double.NaN;
        }
        double USE_LOG_X_CUTOFF = -5.0;
        int n_NEWTON_FREE = 4;
        Bool3 swap_01 = Bool3.NA;
        double log_q_cut = -5.0;
        int n_N = 4;
        double[] qb = new double[]{0.0, 0.0};
        double DBL_very_MIN = 5.562684646268003E-309;
        double DBL_log_v_MIN = -709.0895657128241;
        double DBL_1__eps = 0.9999999999999999;
        double fpu = 3.0E-308;
        double acu_min = 1.0E-300;
        double p_lo = 3.0E-308;
        double p_hi = 0.9999999999999998;
        double const1 = 2.30753;
        double const2 = 0.27061;
        double const3 = 0.99229;
        double const4 = 0.04481;
        boolean swap_choose = swap_01 == Bool3.NA;
        boolean use_log_x = give_log_q = log_q_cut == Double.POSITIVE_INFINITY;
        boolean warned = false;
        boolean add_N_step = true;
        boolean skip_to_return = false;
        double y = -1.0;
        double u = 0.0;
        double u_n = 1.0;
        double xinbta = 0.0;
        if (alpha == (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0))) {
            return give_log_q ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (alpha == (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0))) {
            return !give_log_q ? 1 : 0;
        }
        if (log_p && alpha > 0.0 || !log_p && (alpha < 0.0 || alpha > 1.0)) {
            return Double.NaN;
        }
        if (p == 0.0 || q == 0.0 || MathFunctions.isInfinite(p) || MathFunctions.isInfinite(q)) {
            if (p == 0.0 && q == 0.0) {
                double d = log_p ? -0.6931471805599453 : 0.5;
                if (alpha < d) {
                    return give_log_q ? Double.NEGATIVE_INFINITY : 0.0;
                }
                double d2 = log_p ? -0.6931471805599453 : 0.5;
                if (alpha > d2) {
                    return !give_log_q ? 1 : 0;
                }
                return give_log_q ? -0.6931471805599453 : 0.5;
            }
            if (p == 0.0 || p / q == 0.0) {
                return give_log_q ? Double.NEGATIVE_INFINITY : 0.0;
            }
            if (q == 0.0 || q / p == 0.0) {
                return !give_log_q ? 1 : 0;
            }
            return give_log_q ? -0.6931471805599453 : 0.5;
        }
        double p_ = log_p ? (lower_tail ? Math.exp(alpha) : -Math.expm1(alpha)) : (lower_tail ? alpha : 0.5 - alpha + 0.5);
        double logbeta = MathFunctions.lbeta(p, q);
        boolean bl = swap_choose ? p_ > 0.5 : (swap_tail = swap_01.v());
        if (swap_tail) {
            double d = log_p ? (lower_tail ? -Math.expm1(alpha) : Math.exp(alpha)) : (a = lower_tail ? 0.5 - alpha + 0.5 : alpha);
            la = lower_tail ? (log_p ? (alpha > -0.6931471805599453 ? Math.log(-Math.expm1(alpha)) : Math.log1p(-Math.exp(alpha))) : Math.log1p(-alpha)) : (log_p ? alpha : Math.log(alpha));
            pp = q;
            qq = p;
        } else {
            a = p_;
            la = lower_tail ? (log_p ? alpha : Math.log(alpha)) : (log_p ? (alpha > -0.6931471805599453 ? Math.log(-Math.expm1(alpha)) : Math.log1p(-Math.exp(alpha))) : Math.log1p(-alpha));
            pp = p;
            qq = q;
        }
        double acu = Math.max(1.0E-300, Math.pow(10.0, -13.0 - 2.5 / (pp * pp) - 0.5 / (a * a)));
        double tx = xinbta;
        double u0 = (la + Math.log(pp) + logbeta) / pp;
        double log_eps_c = -36.04365338911715;
        double r = pp * (1.0 - qq) / (pp + 1.0);
        double t = 0.2;
        if (-707.7032713517042 < u0 && u0 < -0.01 && u0 < (t * -36.04365338911715 - Math.log(Math.abs(pp * (1.0 - qq) * (2.0 - qq) / (2.0 * (pp + 2.0))))) / 2.0) {
            u = (r *= Math.exp(u0)) > -1.0 ? u0 - Math.log1p(r) / pp : u0;
            tx = xinbta = Math.exp(u);
            use_log_x = true;
        } else {
            boolean bad_u;
            double s;
            r = Math.sqrt(-2.0 * la);
            y = r - (2.30753 + 0.27061 * r) / (1.0 + (0.99229 + 0.04481 * r) * r);
            if (pp > 1.0 && qq > 1.0) {
                s = 1.0 / (pp + pp - 1.0);
                t = 1.0 / (qq + qq - 1.0);
                double h = 2.0 / (s + t);
                r = (y * y - 3.0) / 6.0;
                w = y * Math.sqrt(h + r) / h - (t - s) * (r + 0.8333333333333334 - 2.0 / (3.0 * h));
                if (w > 300.0) {
                    t = w + w + Math.log(qq) - Math.log(pp);
                    u = t <= 18.0 ? -Math.log1p(Math.exp(t)) : -t - Math.exp(-t);
                    xinbta = Math.exp(u);
                } else {
                    xinbta = pp / (pp + qq * Math.exp(w + w));
                    u = -Math.log1p(qq / pp * Math.exp(w + w));
                }
            } else {
                r = qq + qq;
                t = 1.0 / (3.0 * Math.sqrt(qq));
                t = r * Math.pow(1.0 + t * (-t + y), 3.0);
                s = 4.0 * pp + r - 2.0;
                if (t == 0.0 || t < 0.0 && s >= t) {
                    double l1ma = swap_tail ? (lower_tail ? (log_p ? alpha : Math.log(alpha)) : (log_p ? (alpha > -0.6931471805599453 ? Math.log(-Math.expm1(alpha)) : Math.log1p(-Math.exp(alpha))) : Math.log1p(-alpha))) : (lower_tail ? (log_p ? (alpha > -0.6931471805599453 ? Math.log(-Math.expm1(alpha)) : Math.log1p(-Math.exp(alpha))) : Math.log1p(-alpha)) : (log_p ? alpha : Math.log(alpha)));
                    double xx = (l1ma + Math.log(qq) + logbeta) / qq;
                    if (xx <= 0.0) {
                        xinbta = -Math.expm1(xx);
                        u = xx > -0.6931471805599453 ? Math.log(-Math.expm1(xx)) : Math.log1p(-Math.exp(xx));
                    } else {
                        xinbta = 0.0;
                        u = Double.NEGATIVE_INFINITY;
                    }
                } else if ((t = s / t) <= 1.0) {
                    u = (la + Math.log(pp) + logbeta) / pp;
                    xinbta = Math.exp(u);
                } else {
                    xinbta = 1.0 - 2.0 / (t + 1.0);
                    u = Math.log1p(-2.0 / (t + 1.0));
                }
            }
            if (swap_choose && (swap_tail && u >= -Math.exp(log_q_cut) || !swap_tail && u >= -Math.exp(4.0 * log_q_cut) && pp / qq < 1000.0)) {
                boolean bl2 = swap_tail = !swap_tail;
                if (swap_tail) {
                    double d = log_p ? (lower_tail ? -Math.expm1(alpha) : Math.exp(alpha)) : (a = lower_tail ? 0.5 - alpha + 0.5 : alpha);
                    la = lower_tail ? (log_p ? (alpha > -0.6931471805599453 ? Math.log(-Math.expm1(alpha)) : Math.log1p(-Math.exp(alpha))) : Math.log1p(-alpha)) : (log_p ? alpha : Math.log(alpha));
                    pp = q;
                    qq = p;
                } else {
                    a = p_;
                    la = lower_tail ? (log_p ? alpha : Math.log(alpha)) : (log_p ? (alpha > -0.6931471805599453 ? Math.log(-Math.expm1(alpha)) : Math.log1p(-Math.exp(alpha))) : Math.log1p(-alpha));
                    pp = p;
                    qq = q;
                }
                u = u > -0.6931471805599453 ? Math.log(-Math.expm1(u)) : Math.log1p(-Math.exp(u));
                xinbta = Math.exp(u);
            }
            if (!use_log_x) {
                use_log_x = u < log_q_cut;
            }
            boolean bad_init = (bad_u = Double.isInfinite(u)) || xinbta > 0.9999999999999998;
            u_n = 1.0;
            tx = xinbta;
            if (bad_u || u < log_q_cut) {
                w = Beta.cumulative_raw(DBL_very_MIN, pp, qq, true, log_p);
                double d = log_p ? la : a;
                if (w > d) {
                    if (log_p || Math.abs(w - a) < Math.abs(0.0 - a)) {
                        tx = DBL_very_MIN;
                        u_n = DBL_log_v_MIN;
                    } else {
                        tx = 0.0;
                        u_n = Double.NEGATIVE_INFINITY;
                    }
                    use_log_x = log_p;
                    add_N_step = false;
                    skip_to_return = true;
                } else if (u < DBL_log_v_MIN) {
                    u = DBL_log_v_MIN;
                    xinbta = DBL_very_MIN;
                }
            }
            if (!(skip_to_return || !bad_init || use_log_x && tx > 0.0)) {
                if (u == Double.NEGATIVE_INFINITY) {
                    u = -707.7032713517042;
                    xinbta = Double.MIN_NORMAL;
                } else {
                    double d = xinbta > 1.1 ? 0.5 : (xinbta = xinbta < 3.0E-308 ? Math.exp(u) : 0.9999999999999998);
                    if (bad_u) {
                        u = Math.log(xinbta);
                    }
                }
            }
        }
        if (!skip_to_return) {
            boolean log_;
            boolean converged = false;
            r = 1.0 - pp;
            t = 1.0 - qq;
            double wprev = 0.0;
            double prev = 1.0;
            double adj = 1.0;
            if (use_log_x) {
                int i_pb = 0;
                while (i_pb < 1000) {
                    y = Beta.cumulative_raw(xinbta, pp, qq, true, true);
                    double d = y == Double.NEGATIVE_INFINITY ? 0.0 : (w = (y - la) * Math.exp(y - u + logbeta + r * u + t * (u > -0.6931471805599453 ? Math.log(-Math.expm1(u)) : Math.log1p(-Math.exp(u)))));
                    if (Double.isInfinite(w)) break;
                    if (i_pb >= n_N && w * wprev <= 0.0) {
                        prev = Math.max(Math.abs(adj), 3.0E-308);
                    }
                    double g = 1.0;
                    int i_inn = 0;
                    while (i_inn < 1000) {
                        adj = g * w;
                        if ((i_pb < n_N || Math.abs(adj) < prev) && (u_n = u - adj) <= 0.0) {
                            if (!(prev <= acu) && !(Math.abs(w) <= acu)) break;
                            converged = true;
                            break;
                        }
                        g /= 3.0;
                        ++i_inn;
                    }
                    if (converged) break;
                    double D = Math.min(Math.abs(adj), Math.abs(u_n - u));
                    if (D <= 4.0E-16 * Math.abs(u_n + u)) {
                        converged = true;
                        break;
                    }
                    u = u_n;
                    xinbta = Math.exp(u);
                    wprev = w;
                    ++i_pb;
                }
            } else {
                int i_pb = 0;
                while (i_pb < 1000) {
                    y = Beta.cumulative_raw(xinbta, pp, qq, true, log_p);
                    if (Double.isInfinite(y) && (!log_p || y != Double.NEGATIVE_INFINITY)) {
                        System.err.println("MEDOMAIN on Beta.quantile");
                        return Double.NaN;
                    }
                    double d = w = log_p ? (y - la) * Math.exp(y + logbeta + r * Math.log(xinbta) + t * Math.log1p(-xinbta)) : (y - a) * Math.exp(logbeta + r * Math.log(xinbta) + t * Math.log1p(-xinbta));
                    if (i_pb >= n_N && w * wprev <= 0.0) {
                        prev = Math.max(Math.abs(adj), 3.0E-308);
                    }
                    double g = 1.0;
                    int i_inn = 0;
                    while (i_inn < 1000) {
                        adj = g * w;
                        if ((i_pb < n_N || Math.abs(adj) < prev) && 0.0 <= (tx = xinbta - adj) && tx <= 1.0) {
                            if (prev <= acu || Math.abs(w) <= acu) {
                                converged = true;
                                break;
                            }
                            if (tx != 0.0 && tx != 1.0) break;
                        }
                        g /= 3.0;
                        ++i_inn;
                    }
                    if (converged) break;
                    if (Math.abs(tx - xinbta) <= 4.0E-16 * (tx + xinbta)) {
                        converged = true;
                    } else {
                        xinbta = tx;
                        if (tx != 0.0) {
                            wprev = w;
                            ++i_pb;
                            continue;
                        }
                    }
                    break;
                }
            }
            if (!converged) {
                warned = true;
            }
            boolean bl3 = log_ = log_p || use_log_x;
            if (log_ && y == Double.NEGATIVE_INFINITY || !log_ && y == 0.0) {
                w = Beta.cumulative_raw(DBL_very_MIN, pp, qq, true, log_);
                if (log_ || Math.abs(w - a) <= Math.abs(y - a)) {
                    tx = DBL_very_MIN;
                    u_n = DBL_log_v_MIN;
                }
                add_N_step = false;
            } else if (!(warned || !(log_ ? Math.abs(y - la) > 3.0 : Math.abs(y - a) > 1.0E-4) || log_ && y == Double.NEGATIVE_INFINITY && Beta.cumulative_raw(DBL_1__eps, pp, qq, true, true) > la + 2.0)) {
                System.err.println(String.format("qbeta(a, *) =: x0 with |pbeta(x0,*%s) - alpha| = %.5g is not accurate", log_ ? ", log_" : "", Math.abs(y - (log_ ? la : a))));
            }
        }
        if (give_log_q) {
            double d = r = u_n > -0.6931471805599453 ? Math.log(-Math.expm1(u_n)) : Math.log1p(-Math.exp(u_n));
            if (swap_tail) {
                qb[0] = r;
                qb[1] = u_n;
            } else {
                qb[0] = u_n;
                qb[1] = r;
            }
        } else {
            if (use_log_x) {
                if (add_N_step) {
                    xinbta = Math.exp(u_n);
                    y = Beta.cumulative_raw(xinbta, pp, qq, true, log_p);
                    w = log_p ? (y - la) * Math.exp(y + logbeta + r * Math.log(xinbta) + t * Math.log1p(-xinbta)) : (y - a) * Math.exp(logbeta + r * Math.log(xinbta) + t * Math.log1p(-xinbta));
                    tx = xinbta - w;
                } else {
                    if (swap_tail) {
                        qb[0] = -Math.expm1(u_n);
                        qb[1] = Math.exp(u_n);
                    } else {
                        qb[0] = Math.exp(u_n);
                        qb[1] = -Math.expm1(u_n);
                    }
                    return qb[0];
                }
            }
            if (swap_tail) {
                qb[0] = 1.0 - tx;
                qb[1] = tx;
            } else {
                qb[0] = tx;
                qb[1] = 1.0 - tx;
            }
        }
        return qb[0];
    }

    public static final double random(double aa, double bb, RandomEngine random) {
        double t;
        double u2;
        double u1;
        double z;
        double w;
        double v;
        double r;
        double s;
        double expmax = 709.782712893384;
        if (aa <= 0.0 || bb <= 0.0 || MathFunctions.isInfinite(aa) && MathFunctions.isInfinite(bb)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(aa)) {
            return 1.0;
        }
        if (MathFunctions.isInfinite(bb)) {
            return 0.0;
        }
        double a = Math.min(aa, bb);
        double b = Math.max(aa, bb);
        double alpha = a + b;
        if (a <= 1.0) {
            double w2;
            double beta = 1.0 / a;
            double delta = 1.0 + b - a;
            double k1 = delta * (0.0138889 + 0.0416667 * a) / (b * beta - 0.777778);
            double k2 = 0.25 + (0.5 + 0.25 / delta) * a;
            while (true) {
                double v2;
                double z2;
                double u12 = random.nextDouble();
                double u22 = random.nextDouble();
                if (u12 < 0.5) {
                    double y = u12 * u22;
                    z2 = u12 * y;
                    if (0.25 * u22 + z2 - y >= k1) {
                        continue;
                    }
                } else {
                    z2 = u12 * u12 * u22;
                    if (z2 <= 0.25) {
                        v2 = beta * Math.log(u12 / (1.0 - u12));
                        if (v2 <= 709.782712893384) {
                            w2 = b * Math.exp(v2);
                            if (!MathFunctions.isInfinite(w2)) break;
                            w2 = Double.MAX_VALUE;
                            break;
                        }
                        w2 = Double.MAX_VALUE;
                        break;
                    }
                    if (z2 >= k2) continue;
                }
                if ((v2 = beta * Math.log(u12 / (1.0 - u12))) <= 709.782712893384) {
                    w2 = b * Math.exp(v2);
                    if (MathFunctions.isInfinite(w2)) {
                        w2 = Double.MAX_VALUE;
                    }
                } else {
                    w2 = Double.MAX_VALUE;
                }
                if (alpha * (Math.log(alpha / (a + w2)) + v2) - 1.3862944 >= Math.log(z2)) break;
            }
            return aa == a ? a / (a + w2) : w2 / (a + w2);
        }
        double beta = Math.sqrt((alpha - 2.0) / (2.0 * a * b - alpha));
        double gamma = a + 1.0 / beta;
        do {
            u1 = random.nextDouble();
            u2 = random.nextDouble();
            v = beta * Math.log(u1 / (1.0 - u1));
            if (v <= 709.782712893384) {
                w = a * Math.exp(v);
                if (!MathFunctions.isInfinite(w)) continue;
                w = Double.MAX_VALUE;
                continue;
            }
            w = Double.MAX_VALUE;
        } while (!((s = a + (r = gamma * v - 1.3862944) - w) + 2.609438 >= 5.0 * (z = u1 * u1 * u2)) && !(s > (t = Math.log(z))) && r + alpha * Math.log(alpha / (b + w)) < t);
        return aa != a ? b / (b + w) : w / (b + w);
    }

    public static final double[] random(int n, double aa, double bb, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Beta.random(aa, bb, random);
            ++i;
        }
        return rand;
    }

    public Beta(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public double density(double x, boolean log) {
        return Beta.density(x, this.a, this.b, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Beta.cumulative(p, this.a, this.b, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Beta.quantile(q, this.a, this.b, lower_tail, log_p);
    }

    public double random() {
        return Beta.random(this.a, this.b, this.random);
    }
}

