/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Exponential;
import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class ReverseWeibull
extends GenericDistribution {
    protected double loc;
    protected double scale;
    protected double shape;

    public static final double density(double x, double loc, double scale, double shape, boolean log) {
        if (scale <= 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        if ((x = (x - loc) / scale) >= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        x = Math.log(shape / scale) + (shape - 1.0) * Math.log(-x) - Math.pow(-x, shape);
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, double loc, double scale, double shape, boolean lower_tail) {
        if (scale <= 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        q = Math.exp(-Math.pow(-Math.min((q - loc) / scale, 0.0), shape));
        return !lower_tail ? 1.0 - q : q;
    }

    public static final double quantile(double p, double loc, double scale, double shape, boolean lower_tail) {
        if (p <= 0.0 || p >= 1.0 || scale < 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return loc - scale * Math.pow(-Math.log(p), 1.0 / shape);
    }

    public static final double random(double loc, double scale, double shape, RandomEngine random) {
        if (scale < 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        return loc - scale * Math.pow(Exponential.random_standard(random), 1.0 / shape);
    }

    public static final double[] random(int n, double loc, double scale, double shape, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = ReverseWeibull.random(loc, scale, shape, random);
            ++i;
        }
        return rand;
    }

    public ReverseWeibull(double loc, double scale, double shape) {
        this.loc = loc;
        this.scale = scale;
        this.shape = shape;
    }

    public double density(double x, boolean log) {
        return ReverseWeibull.density(x, this.loc, this.scale, this.shape, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        p = ReverseWeibull.cumulative(p, this.loc, this.scale, this.shape, lower_tail);
        return log_p ? Math.log(p) : p;
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        if (log_p) {
            q = Math.exp(q);
        }
        return ReverseWeibull.quantile(q, this.loc, this.scale, this.shape, lower_tail);
    }

    public double random() {
        return ReverseWeibull.random(this.loc, this.scale, this.shape, this.random);
    }
}

