/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.functions;

import com.yahoo.labs.samoa.instances.Instance;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.MultiClassClassifier;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;

public class MajorityClass
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    protected DoubleVector observedClassDistribution;

    @Override
    public String getPurposeString() {
        return "Majority class classifier: always predicts the class that has been observed most frequently the in the training data.";
    }

    @Override
    public void resetLearningImpl() {
        this.observedClassDistribution = new DoubleVector();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
    }

    @Override
    public double[] getVotesForInstance(Instance i) {
        return this.observedClassDistribution.getArrayCopy();
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent, "Predicted majority ");
        out.append(this.getClassNameString());
        out.append(" = ");
        out.append(this.getClassLabelString(this.observedClassDistribution.maxIndex()));
        StringUtils.appendNewline(out);
        for (int i = 0; i < this.observedClassDistribution.numValues(); ++i) {
            StringUtils.appendIndented(out, indent, "Observed weight of ");
            out.append(this.getClassLabelString(i));
            out.append(": ");
            out.append(this.observedClassDistribution.getValue(i));
            StringUtils.appendNewline(out);
        }
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public ImmutableCapabilities defineImmutableCapabilities() {
        if (this.getClass() == MajorityClass.class) {
            return new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
        }
        return new ImmutableCapabilities(Capability.VIEW_STANDARD);
    }
}

