/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.oneclass;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Collection;
import java.util.Iterator;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.OneClassClassifier;
import moa.classifiers.oneclass.HSTreeNode;
import moa.core.Measurement;

public class HSTrees
extends AbstractClassifier
implements Classifier,
OneClassClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption windowSizeOption = new IntOption("windowSize", 'p', "The size of the landmark windows used.", 250);
    public IntOption numTreesOption = new IntOption("numberOfTrees", 't', "The number of trees in the ensemble.", 25);
    public IntOption maxDepthOption = new IntOption("maxDepth", 'h', "The maximum depth of the trees", 15);
    public FloatOption anomalyThresholdOption = new FloatOption("anomalyThreshold", 'a', "Threshold (as a fraction of the maximum mass value) below which an instance is declared an anomaly.", 0.5, Double.MIN_VALUE, 1.0);
    public FloatOption sizeLimitOption = new FloatOption("sizeLimit", 's', "The minimum mass required in a node (as a fraction of the window size) to calculate the anomaly score.", 0.1, Double.MIN_VALUE, 1.0);
    private int windowSize;
    private int numTrees;
    private int maxDepth;
    private double sizeLimit;
    private int dimensions;
    private int numInstances;
    private double anomalyThreshold;
    private HSTreeNode[] forest;
    private boolean referenceWindow;

    @Override
    public String getPurposeString() {
        return "HSTrees is a forest of Streaming Half-Space Trees.";
    }

    @Override
    public void resetLearningImpl() {
        this.windowSize = this.windowSizeOption.getValue();
        this.numTrees = this.numTreesOption.getValue();
        this.maxDepth = this.maxDepthOption.getValue();
        this.sizeLimit = this.sizeLimitOption.getValue();
        this.numInstances = 0;
        this.forest = new HSTreeNode[this.numTrees];
        this.referenceWindow = true;
        this.anomalyThreshold = this.anomalyThresholdOption.getValue();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        int i;
        if (this.numInstances == 0) {
            this.buildForest(inst);
        }
        for (i = 0; i < this.numTrees; ++i) {
            this.forest[i].updateMass(inst, this.referenceWindow);
        }
        if (this.numInstances > 50) {
            this.referenceWindow = false;
        }
        if (this.numInstances % this.windowSize == 0) {
            for (i = 0; i < this.numTrees; ++i) {
                this.forest[i].updateModel();
            }
        }
        ++this.numInstances;
    }

    private void buildForest(Instance inst) {
        this.dimensions = inst.numAttributes();
        double[] max = new double[this.dimensions];
        double[] min = new double[this.dimensions];
        for (int i = 0; i < this.numTrees; ++i) {
            for (int j = 0; j < this.dimensions; ++j) {
                double sq = this.classifierRandom.nextDouble();
                min[j] = sq - 2.0 * Math.max(sq, 1.0 - sq);
                max[j] = sq + 2.0 * Math.max(sq, 1.0 - sq);
            }
            this.forest[i] = new HSTreeNode(min, max, 1, this.maxDepth);
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[]{0.5, 0.5};
        if (!this.referenceWindow) {
            votes[1] = this.getAnomalyScore(inst) + 0.5 - this.anomalyThreshold;
            votes[0] = 1.0 - votes[1];
        }
        return votes;
    }

    @Override
    public double getAnomalyScore(Instance inst) {
        if (this.referenceWindow) {
            return 0.5;
        }
        double accumulatedScore = 0.0;
        int massLimit = (int)Math.ceil(this.sizeLimit * (double)this.windowSize);
        double maxScore = (double)this.windowSize * Math.pow(2.0, this.maxDepth);
        for (int i = 0; i < this.numTrees; ++i) {
            accumulatedScore += this.forest[i].score(inst, massLimit) / maxScore;
        }
        return 0.5 - (accumulatedScore /= (double)this.numTrees) + this.anomalyThreshold;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public void initialize(Collection<Instance> trainingPoints) {
        Iterator<Instance> trgPtsIterator = trainingPoints.iterator();
        if (trgPtsIterator.hasNext() && this.numInstances == 0) {
            Instance inst = trgPtsIterator.next();
            this.buildForest(inst);
            this.trainOnInstance(inst);
        }
        while (trgPtsIterator.hasNext()) {
            this.trainOnInstance(trgPtsIterator.next());
        }
    }
}

