/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import moa.core.DoubleVector;
import moa.gui.experimentertab.Measure;
import moa.gui.experimentertab.ReadFile;
import moa.gui.experimentertab.Stream;

public class Algorithm {
    public String name;
    public String path;
    public List<Measure> measures = new ArrayList<Measure>();
    public BufferedReader buffer;
    public int measureStdSize = 0;

    public Algorithm(String name, List<Measure> measures, BufferedReader buffer, String path) {
        this.name = name;
        this.path = path;
        this.measureStdSize = measures.size();
        measures.stream().map(measure -> {
            int index = ReadFile.getMeasureIndex(path, measure.getFileName());
            this.measures.add(new Measure(measure.getName(), measure.getFileName(), measure.isType(), index));
            return measure;
        }).filter(measure -> measure.isType()).forEach(_item -> ++this.measureStdSize);
        this.buffer = buffer;
        try {
            this.calculateMeasures();
        }
        catch (IOException ex) {
            Logger.getLogger(Algorithm.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void calculateMeasures() throws IOException {
        int cont = 0;
        DoubleVector[] values = new DoubleVector[this.measures.size()];
        for (int i = 0; i < this.measures.size(); ++i) {
            values[i] = new DoubleVector();
        }
        String lines = this.buffer.readLine();
        while ((lines = this.buffer.readLine()) != null) {
            String[] line = lines.split(",");
            for (int i = 0; i < this.measures.size(); ++i) {
                if (this.measures.get(i).isType()) {
                    try {
                        values[i].setValue(cont, Double.parseDouble(line[this.measures.get(i).getIndex()]));
                    }
                    catch (NumberFormatException exp) {
                        values[i].setValue(cont, 0.0);
                    }
                    continue;
                }
                try {
                    this.measures.get(i).setValue(Double.parseDouble(line[this.measures.get(i).getIndex()]));
                    continue;
                }
                catch (NumberFormatException exp) {
                    this.measures.get(i).setValue(0.0);
                }
            }
            ++cont;
        }
        for (int i = 0; i < this.measures.size(); ++i) {
            this.measures.get(i).computeValue(values[i]);
        }
    }

    public List<Measure>[] getMeasuresPerData(List<Stream> stream) {
        ArrayList[] measures = new ArrayList[stream.size()];
        for (int i = 0; i < stream.size(); ++i) {
            measures[i] = new ArrayList();
            for (int j = 0; j < stream.get((int)i).algorithm.size(); ++j) {
                if (!stream.get((int)i).algorithm.get((int)j).name.equals(this.name)) continue;
                measures[i] = stream.get((int)i).algorithm.get((int)j).measures;
            }
        }
        return measures;
    }

    static String format(double value) {
        return String.format("%.2f", value);
    }

    static String format1(double x) {
        String s = "" + Math.round(x);
        return s;
    }

    static double Round(double x) {
        return Math.floor((x + 0.005) * 100.0) / 100.0;
    }
}

