/*
 * Decompiled with CFR 0.152.
 */
package dr.stats;

import dr.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class FrequencyCounter<T extends Comparable> {
    private final List<T> uniqueValues;
    private final Map<T, Integer> frequencies;
    private final Set<T> credibleSet = new LinkedHashSet<T>();
    private final Set<T> incredibleSet = new LinkedHashSet<T>();
    private final int total;
    private final int min;
    private final int max;
    private final T mode;

    public FrequencyCounter(List<T> list) {
        this(list, 0.0);
    }

    public FrequencyCounter(List<T> list, double d) {
        this.frequencies = new TreeMap<T, Integer>();
        for (Comparable comparable : list) {
            if (this.frequencies.containsKey(comparable)) {
                int n = this.frequencies.get(comparable) + 1;
                this.frequencies.put(comparable, n);
                continue;
            }
            this.frequencies.put(comparable, 1);
        }
        this.uniqueValues = new ArrayList<T>(this.frequencies.keySet());
        this.total = this.calculateTotalFrequency();
        Object object = this.calculateMinMaxFrequency();
        this.min = (int)object[0];
        this.max = (int)object[1];
        this.mode = this.calculateMode();
        if (d > 0.0) {
            this.calculateCredibleSet(d);
        }
    }

    public Map<T, Integer> getFrequencies() {
        return this.frequencies;
    }

    public int getSize() {
        return this.frequencies.size();
    }

    public List<Integer> getOrderByFrequency() {
        ArrayList<Pair<Comparable, Integer>> arrayList = new ArrayList<Pair<Comparable, Integer>>();
        int n = 0;
        for (Object object : this.uniqueValues) {
            arrayList.add(new Pair<Comparable, Integer>((Comparable)object, n));
            ++n;
        }
        Collections.sort(arrayList, new Comparator<Pair<T, Integer>>(){

            @Override
            public int compare(Pair<T, Integer> pair, Pair<T, Integer> pair2) {
                return FrequencyCounter.this.getFrequency((Comparable)pair2.fst) - FrequencyCounter.this.getFrequency((Comparable)pair.fst);
            }
        });
        ArrayList arrayList2 = new ArrayList();
        for (Pair pair : arrayList) {
            arrayList2.add((Integer)pair.snd);
        }
        return arrayList2;
    }

    public List<T> getUniqueValues() {
        ArrayList<T> arrayList = new ArrayList<T>(this.uniqueValues);
        Collections.sort(arrayList);
        return arrayList;
    }

    public int getMinFrequency() {
        return this.min;
    }

    public int getMaxFrequency() {
        return this.max;
    }

    public T getMode() {
        return this.mode;
    }

    public int getFrequency(T t) {
        if (this.frequencies.containsKey(t)) {
            return this.frequencies.get(t);
        }
        return 0;
    }

    public int getTotalFrequency() {
        return this.total;
    }

    public double getProbability(T t) {
        return (double)this.getFrequency(t) / (double)this.total;
    }

    public double getProportionalFrequency(T t) {
        return (double)this.getFrequency(t) / (double)this.max;
    }

    public Set<T> getCredibleSet() {
        return this.credibleSet;
    }

    public Set<T> getIncredibleSet() {
        return this.incredibleSet;
    }

    private int calculateTotalFrequency() {
        int n = 0;
        for (int n2 : this.frequencies.values()) {
            n += n2;
        }
        return n;
    }

    private int[] calculateMinMaxFrequency() {
        int n = Collections.min(this.frequencies.values());
        int n2 = Collections.max(this.frequencies.values());
        return new int[]{n, n2};
    }

    private T calculateMode() {
        int n = 0;
        Comparable comparable = null;
        for (Comparable comparable2 : this.getUniqueValues()) {
            if (this.getFrequency(comparable2) <= n) continue;
            n = this.getFrequency(comparable2);
            comparable = comparable2;
        }
        return (T)comparable;
    }

    private void calculateCredibleSet(double d) {
        double d2 = 0.0;
        for (int n : this.getOrderByFrequency()) {
            Comparable comparable = (Comparable)this.uniqueValues.get(n);
            double d3 = this.getProbability(comparable);
            if (d2 < d) {
                this.credibleSet.add(comparable);
            } else {
                this.incredibleSet.add(comparable);
            }
            d2 += d3;
        }
    }
}

