/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleRowId;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class ROWID
extends Datum
implements OracleRowId {
    static final long serialVersionUID = 5629736369998199486L;
    Object acProxy;

    public ROWID() {
    }

    public ROWID(byte[] byArray) {
        super(byArray);
    }

    public ROWID(String string) throws SQLException {
        this(ROWID.toAsciiBytes(string));
    }

    private static byte[] toAsciiBytes(String string) throws SQLException {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (SQLException)DatabaseError.createSqlException(183).fillInStackTrace();
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0;
    }

    @Override
    public String stringValue() {
        byte[] byArray = null;
        byArray = this.getBytes();
        return new String(byArray);
    }

    @Override
    @DisableTrace
    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new byte[n2][];
    }

    @Override
    public void setACProxy(Object object) {
        this.acProxy = object;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }
}

