/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.value;

import com.amazon.sqlengine.aeprocessor.AEQColumnName;
import com.amazon.sqlengine.aeprocessor.AEQTableName;
import com.amazon.sqlengine.aeprocessor.AEUtils;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.amazon.sqlengine.parser.parsetree.IPTNode;
import com.amazon.sqlengine.parser.parsetree.PTIdentifierNode;
import com.amazon.sqlengine.parser.parsetree.PTNonterminalNode;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.sqlengine.parser.type.PTPositionalType;
import com.amazon.support.exceptions.ErrorException;

public class AEColumnReferenceBuilder
extends AEBuilderBase<AEColumnReference> {
    public AEColumnReferenceBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
    }

    @Override
    public AEColumnReference visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        return this.buildColumnReference(pTNonterminalNode);
    }

    @Override
    public AEColumnReference visit(PTIdentifierNode pTIdentifierNode) throws ErrorException {
        return this.buildColumnReference(pTIdentifierNode);
    }

    public static AEQColumnName buildQualifiedColumnName(SqlDataEngineContext sqlDataEngineContext, IPTNode iPTNode) throws ErrorException {
        AEBuilderCheck.checkThat(iPTNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.COLUMN_REFERENCE)).withExactChildren(PTPositionalType.CATALOG_IDENT, AEBuilderCheck.optional(AEBuilderCheck.identifier()), PTPositionalType.SCHEMA_IDENT, AEBuilderCheck.optional(AEBuilderCheck.identifier()), PTPositionalType.TABLE_IDENT, AEBuilderCheck.optional(AEBuilderCheck.identifier()), PTPositionalType.COLUMN_NAME, AEBuilderCheck.identifier()));
        PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.CATALOG_IDENT);
        IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.SCHEMA_IDENT);
        IPTNode iPTNode4 = pTNonterminalNode.getChild(PTPositionalType.TABLE_IDENT);
        IPTNode iPTNode5 = pTNonterminalNode.getChild(PTPositionalType.COLUMN_NAME);
        String string = ((PTIdentifierNode)iPTNode5).getIdentifier();
        String string2 = AEUtils.getIdentifierString(iPTNode2);
        String string3 = AEUtils.getIdentifierString(iPTNode3);
        String string4 = AEUtils.getIdentifierString(iPTNode4);
        AEQTableName aEQTableName = AEUtils.adjustCatalogAndSchema(new AEQTableName(string2, string3, string4), sqlDataEngineContext, false);
        return new AEQColumnName(aEQTableName, string);
    }

    private AEColumnReference buildColumnReference(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEQColumnName aEQColumnName = AEColumnReferenceBuilder.buildQualifiedColumnName(this.getQueryScope().getDataEngine().getContext(), pTNonterminalNode);
        return new AEColumnReference(this.getQueryScope().resolveColumn(aEQColumnName));
    }

    private AEColumnReference buildColumnReference(PTIdentifierNode pTIdentifierNode) throws ErrorException {
        String string = pTIdentifierNode.getIdentifier();
        AEQColumnName aEQColumnName = new AEQColumnName(AEQTableName.empty(), string);
        return new AEColumnReference(this.getQueryScope().resolveColumn(aEQColumnName));
    }
}

