/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.value.ETAggregateFn;
import com.amazon.sqlengine.executor.etree.value.ETDistinctValueStore;
import com.amazon.sqlengine.executor.etree.value.ETValueExprList;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.IAggregator;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

public class ETDistinctAggregateFn
extends ETAggregateFn {
    private final IAggregator.IUpdateParameters m_distinctUpdateParameters;
    private final ETDistinctValueStore m_valueStore;
    private final int m_nCols;
    private boolean m_isAgggregationDone;

    public ETDistinctAggregateFn(AEAggrFn.AggrFnId aggrFnId, ETValueExprList eTValueExprList, List<IColumn> list, IAggregator iAggregator, MaterializerContext materializerContext) throws ErrorException {
        super(aggrFnId, eTValueExprList, list, iAggregator);
        boolean[] blArray = new boolean[list.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        this.m_valueStore = new ETDistinctValueStore(list, materializerContext.getCancelState(), materializerContext.getDataEngineContext().getDataEngine(), materializerContext.getExternalAlgorithmProperties(), blArray);
        this.m_distinctUpdateParameters = new ETDistinctValueUpdateParameters(this.m_valueStore, list.toArray(new IColumn[0]));
        this.m_nCols = eTValueExprList.getNumChildren();
        this.m_isAgggregationDone = false;
    }

    @Override
    public void update() throws ErrorException {
        this.m_valueStore.appendCell();
        for (int i = 0; i < this.m_nCols; ++i) {
            this.m_valueStore.writeFromDataWrapper(i, this.getValueUpdateParameters().getData(i));
        }
        this.m_valueStore.finishAppending();
        this.m_isAgggregationDone = false;
    }

    @Override
    public void reset() throws ErrorException {
        super.reset();
        this.m_isAgggregationDone = false;
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        if (!this.m_isAgggregationDone) {
            this.getAggregator().reset();
            this.m_valueStore.open(CursorType.FORWARD_ONLY);
            while (this.m_valueStore.move()) {
                this.getAggregator().update(this.m_distinctUpdateParameters);
            }
            this.m_valueStore.close(true);
            this.m_isAgggregationDone = true;
        }
        return this.getAggregator().retrieveData(eTDataRequest);
    }

    @Override
    public int getNumChildren() {
        return super.getNumChildren() + 1;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (n < super.getNumChildren()) {
            return super.getChild(n);
        }
        switch (n - super.getNumChildren()) {
            case 0: {
                return this.m_valueStore;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private static class ETDistinctValueUpdateParameters
    implements IAggregator.IUpdateParameters {
        private boolean[] m_hasMoreData;
        private ETDataRequest[] m_dataRequest;
        private ETDistinctValueStore m_valueStore;
        private IColumn[] m_inputMetadata;

        public ETDistinctValueUpdateParameters(ETDistinctValueStore eTDistinctValueStore, IColumn[] iColumnArray) {
            this.m_valueStore = eTDistinctValueStore;
            this.m_inputMetadata = iColumnArray;
            this.m_dataRequest = new ETDataRequest[iColumnArray.length];
            for (int i = 0; i < iColumnArray.length; ++i) {
                this.m_dataRequest[i] = new ETDataRequest(iColumnArray[i]);
            }
            this.m_hasMoreData = new boolean[iColumnArray.length];
        }

        @Override
        public ISqlDataWrapper getData(int n) throws ErrorException {
            ETDataRequest eTDataRequest = this.m_dataRequest[n];
            eTDataRequest.setOffset(0L);
            eTDataRequest.setMaxBytes(-1L);
            eTDataRequest.getData().setNull();
            this.m_hasMoreData[n] = this.m_valueStore.retrieveData(n, eTDataRequest);
            return eTDataRequest.getData();
        }

        @Override
        public ISqlDataWrapper getData(int n, long l, long l2) throws ErrorException {
            ETDataRequest eTDataRequest = this.m_dataRequest[n];
            eTDataRequest.setOffset(l);
            eTDataRequest.setMaxBytes(l2);
            eTDataRequest.getData().setNull();
            this.m_hasMoreData[n] = this.m_valueStore.retrieveData(n, eTDataRequest);
            return eTDataRequest.getData();
        }

        @Override
        public IColumn getMetadata(int n) {
            return this.m_inputMetadata[n];
        }

        @Override
        public boolean hasMoreData(int n) {
            return this.m_hasMoreData[n];
        }
    }
}

