/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.Encoding;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSPacket;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSReader {
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Reader");
    private final String traceID;
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private final TDSCommand command;
    private TDSPacket currentPacket;
    private TDSPacket lastPacket;
    private int payloadOffset;
    private int packetNum;
    private boolean isStreaming;
    private final byte[] valueBytes;
    private static int lastReaderID = 0;
    private static final int[] SCALED_MULTIPLIERS = new int[]{10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    static final String guidTemplate = "NNNNNNNN-NNNN-NNNN-NNNN-NNNNNNNNNNNN";

    public final String toString() {
        return this.traceID;
    }

    final TDSCommand getCommand() {
        assert (null != this.command);
        return this.command;
    }

    final SQLServerConnection getConnection() {
        return this.con;
    }

    private static synchronized int nextReaderID() {
        return ++lastReaderID;
    }

    TDSReader(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection, TDSCommand tDSCommand) {
        this.lastPacket = this.currentPacket = new TDSPacket(0);
        this.payloadOffset = 0;
        this.packetNum = 0;
        this.isStreaming = true;
        this.valueBytes = new byte[256];
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
        this.command = tDSCommand;
        this.traceID = logger.isLoggable(Level.FINE) ? "TDSReader@" + TDSReader.nextReaderID() + " (" + sQLServerConnection.toString() + ")" : sQLServerConnection.toString();
    }

    final void throwInvalidTDS() throws SQLServerException {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe(this.toString() + " got unexpected value in TDS response at offset:" + this.payloadOffset);
        }
        this.con.throwInvalidTDS();
    }

    final void throwInvalidTDSToken(String string) throws SQLServerException {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe(this.toString() + " got unexpected value in TDS response at offset:" + this.payloadOffset);
        }
        this.con.throwInvalidTDSToken(string);
    }

    private final boolean ensurePayload() throws SQLServerException {
        if (this.payloadOffset == this.currentPacket.payloadLength && !this.nextPacket()) {
            return false;
        }
        assert (this.payloadOffset < this.currentPacket.payloadLength);
        return true;
    }

    private final boolean nextPacket() throws SQLServerException {
        assert (null != this.currentPacket);
        TDSPacket tDSPacket = this.currentPacket;
        assert (this.payloadOffset == tDSPacket.payloadLength);
        if (null == tDSPacket.next) {
            this.readPacket();
            if (null == tDSPacket.next) {
                return false;
            }
        }
        TDSPacket tDSPacket2 = tDSPacket.next;
        if (this.isStreaming) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Moving to next packet -- unlinking consumed packet");
            }
            tDSPacket.next = null;
        }
        this.currentPacket = tDSPacket2;
        this.payloadOffset = 0;
        return true;
    }

    final synchronized boolean readPacket() throws SQLServerException {
        int n;
        int n2;
        int n3;
        if (null != this.command && !this.command.readingResponse()) {
            return false;
        }
        assert (this.tdsChannel.numMsgsRcvd < this.tdsChannel.numMsgsSent) : "numMsgsRcvd:" + this.tdsChannel.numMsgsRcvd + " should be less than numMsgsSent:" + this.tdsChannel.numMsgsSent;
        TDSPacket tDSPacket = new TDSPacket(this.con.getTDSPacketSize());
        for (n2 = 0; n2 < 8; n2 += n3) {
            n3 = this.tdsChannel.read(tDSPacket.header, n2, 8 - n2);
            if (n3 >= 0) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Premature EOS in response. packetNum:" + this.packetNum + " headerBytesRead:" + n2);
            }
            this.con.terminate(3, 0 == this.packetNum && 0 == n2 ? SQLServerException.getErrString("R_noServerResponse") : SQLServerException.getErrString("R_truncatedServerResponse"));
        }
        n2 = Util.readUnsignedShortBigEndian(tDSPacket.header, 2);
        if (n2 < 8 || n2 > this.con.getTDSPacketSize()) {
            logger.warning(this.toString() + " TDS header contained invalid packet length:" + n2 + "; packet size:" + this.con.getTDSPacketSize());
            this.throwInvalidTDS();
        }
        tDSPacket.payloadLength = n2 - 8;
        this.tdsChannel.setSPID(Util.readUnsignedShortBigEndian(tDSPacket.header, 4));
        byte[] byArray = null;
        if (this.tdsChannel.isLoggingPackets()) {
            byArray = new byte[n2];
            System.arraycopy(tDSPacket.header, 0, byArray, 0, 8);
        }
        for (int i = 0; i < tDSPacket.payloadLength; i += n) {
            n = this.tdsChannel.read(tDSPacket.payload, i, tDSPacket.payloadLength - i);
            if (n >= 0) continue;
            this.con.terminate(3, SQLServerException.getErrString("R_truncatedServerResponse"));
        }
        ++this.packetNum;
        this.lastPacket.next = tDSPacket;
        this.lastPacket = tDSPacket;
        if (this.tdsChannel.isLoggingPackets()) {
            System.arraycopy(tDSPacket.payload, 0, byArray, 8, tDSPacket.payloadLength);
            this.tdsChannel.logPacket(byArray, 0, n2, this.toString() + " received Packet:" + this.packetNum + " (" + tDSPacket.payloadLength + " bytes)");
        }
        if (tDSPacket.isEOM()) {
            ++this.tdsChannel.numMsgsRcvd;
            if (null != this.command) {
                this.command.onResponseEOM();
            }
        }
        return true;
    }

    final TDSReaderMark mark() {
        TDSReaderMark tDSReaderMark = new TDSReaderMark(this.currentPacket, this.payloadOffset);
        this.isStreaming = false;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Buffering from: " + tDSReaderMark.toString());
        }
        return tDSReaderMark;
    }

    final void reset(TDSReaderMark tDSReaderMark) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Resetting to: " + tDSReaderMark.toString());
        }
        this.currentPacket = tDSReaderMark.packet;
        this.payloadOffset = tDSReaderMark.payloadOffset;
    }

    final void stream() {
        this.isStreaming = true;
    }

    final int available() {
        int n = this.currentPacket.payloadLength - this.payloadOffset;
        TDSPacket tDSPacket = this.currentPacket.next;
        while (null != tDSPacket) {
            n += tDSPacket.payloadLength;
            tDSPacket = tDSPacket.next;
        }
        return n;
    }

    final int peekTokenType() throws SQLServerException {
        if (!this.ensurePayload()) {
            return -1;
        }
        return this.currentPacket.payload[this.payloadOffset] & 0xFF;
    }

    final int readUnsignedByte() throws SQLServerException {
        if (!this.ensurePayload()) {
            this.throwInvalidTDS();
        }
        return this.currentPacket.payload[this.payloadOffset++] & 0xFF;
    }

    final short readShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            short s = Util.readShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return s;
        }
        return Util.readShort(this.readWrappedBytes(2), 0);
    }

    final int readUnsignedShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            int n = Util.readUnsignedShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return n;
        }
        return Util.readUnsignedShort(this.readWrappedBytes(2), 0);
    }

    final String readUnicodeString(int n) throws SQLServerException {
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        this.readBytes(byArray, 0, n2);
        return Util.readUnicodeString(byArray, 0, n2, this.con);
    }

    final char readChar() throws SQLServerException {
        return (char)this.readShort();
    }

    final int readInt() throws SQLServerException {
        if (this.payloadOffset + 4 <= this.currentPacket.payloadLength) {
            int n = Util.readInt(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 4;
            return n;
        }
        return Util.readInt(this.readWrappedBytes(4), 0);
    }

    final int readIntBigEndian() throws SQLServerException {
        if (this.payloadOffset + 4 <= this.currentPacket.payloadLength) {
            int n = Util.readIntBigEndian(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 4;
            return n;
        }
        return Util.readIntBigEndian(this.readWrappedBytes(4), 0);
    }

    final long readUnsignedInt() throws SQLServerException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    final long readLong() throws SQLServerException {
        if (this.payloadOffset + 8 <= this.currentPacket.payloadLength) {
            long l = Util.readLong(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 8;
            return l;
        }
        return Util.readLong(this.readWrappedBytes(8), 0);
    }

    final void readBytes(byte[] byArray, int n, int n2) throws SQLServerException {
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (!this.ensurePayload()) {
                this.throwInvalidTDS();
            }
            if ((n4 = n2 - n3) > this.currentPacket.payloadLength - this.payloadOffset) {
                n4 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Reading " + n4 + " bytes from offset " + this.payloadOffset);
            }
            System.arraycopy(this.currentPacket.payload, this.payloadOffset, byArray, n + n3, n4);
            n3 += n4;
            this.payloadOffset += n4;
        }
    }

    final byte[] readWrappedBytes(int n) throws SQLServerException {
        assert (n <= this.valueBytes.length);
        this.readBytes(this.valueBytes, 0, n);
        return this.valueBytes;
    }

    final Object readDecimal(int n, TypeInfo typeInfo, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (n > this.valueBytes.length) {
            logger.warning(this.toString() + " Invalid value length:" + n);
            this.throwInvalidTDS();
        }
        this.readBytes(this.valueBytes, 0, n);
        int n2 = 0 == this.valueBytes[0] ? -1 : 1;
        byte[] byArray = new byte[n - 1];
        for (int i = 1; i <= byArray.length; ++i) {
            byArray[byArray.length - i] = this.valueBytes[i];
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(n2, byArray), typeInfo.getScale());
        return DDC.convertBigDecimalToObject(bigDecimal, jDBCType, streamType);
    }

    final Object readMoney(int n, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        BigInteger bigInteger;
        switch (n) {
            case 8: {
                int n2 = this.readInt();
                int n3 = this.readInt();
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n2, byArray, 0);
                    Util.writeIntBigEndian(n3, byArray, 4);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf((long)n2 << 32 | (long)n3 & 0xFFFFFFFFL);
                break;
            }
            case 4: {
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[4];
                    Util.writeIntBigEndian(this.readInt(), byArray, 0);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf(this.readInt());
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        return DDC.convertBigDecimalToObject(new BigDecimal(bigInteger, 4), jDBCType, streamType);
    }

    final Object readReal(int n, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (4 != n) {
            this.throwInvalidTDS();
        }
        return DDC.convertFloatToObject(Float.intBitsToFloat(this.readInt()), jDBCType, streamType);
    }

    final Object readFloat(int n, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (8 != n) {
            this.throwInvalidTDS();
        }
        return DDC.convertDoubleToObject(Double.longBitsToDouble(this.readLong()), jDBCType, streamType);
    }

    final Object readDateTime(int n, Calendar calendar, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        int n2;
        int n3;
        switch (n) {
            case 8: {
                n3 = this.readInt();
                int n4 = this.readInt();
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n3, byArray, 0);
                    Util.writeIntBigEndian(n4, byArray, 4);
                    return byArray;
                }
                n2 = (n4 * 10 + 1) / 3;
                break;
            }
            case 4: {
                n3 = this.readUnsignedShort();
                int n5 = this.readUnsignedShort();
                if (JDBCType.BINARY == jDBCType) {
                    byte[] byArray = new byte[4];
                    Util.writeShortBigEndian((short)n3, byArray, 0);
                    Util.writeShortBigEndian((short)n5, byArray, 2);
                    return byArray;
                }
                n2 = n5 * 60 * 1000;
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        return DDC.convertTemporalToObject(jDBCType, SSType.DATETIME, calendar, n3, n2, 0);
    }

    final Object readDate(int n, Calendar calendar, JDBCType jDBCType) throws SQLServerException {
        if (3 != n) {
            this.throwInvalidTDS();
        }
        int n2 = this.readDaysIntoCE();
        return DDC.convertTemporalToObject(jDBCType, SSType.DATE, calendar, n2, 0L, 0);
    }

    final Object readTime(int n, TypeInfo typeInfo, Calendar calendar, JDBCType jDBCType) throws SQLServerException {
        if (TDS.timeValueLength(typeInfo.getScale()) != n) {
            this.throwInvalidTDS();
        }
        long l = this.readNanosSinceMidnight(typeInfo.getScale());
        return DDC.convertTemporalToObject(jDBCType, SSType.TIME, calendar, 0, l, typeInfo.getScale());
    }

    final Object readDateTime2(int n, TypeInfo typeInfo, Calendar calendar, JDBCType jDBCType) throws SQLServerException {
        if (TDS.datetime2ValueLength(typeInfo.getScale()) != n) {
            this.throwInvalidTDS();
        }
        long l = this.readNanosSinceMidnight(typeInfo.getScale());
        int n2 = this.readDaysIntoCE();
        return DDC.convertTemporalToObject(jDBCType, SSType.DATETIME2, calendar, n2, l, typeInfo.getScale());
    }

    final Object readDateTimeOffset(int n, TypeInfo typeInfo, JDBCType jDBCType) throws SQLServerException {
        if (TDS.datetimeoffsetValueLength(typeInfo.getScale()) != n) {
            this.throwInvalidTDS();
        }
        long l = this.readNanosSinceMidnight(typeInfo.getScale());
        int n2 = this.readDaysIntoCE();
        short s = this.readShort();
        return DDC.convertTemporalToObject(jDBCType, SSType.DATETIMEOFFSET, new GregorianCalendar(new SimpleTimeZone(s * 60 * 1000, ""), Locale.US), n2, l, typeInfo.getScale());
    }

    private int readDaysIntoCE() throws SQLServerException {
        byte[] byArray = new byte[3];
        this.readBytes(byArray, 0, byArray.length);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= (byArray[i] & 0xFF) << 8 * i;
        }
        if (n < 0) {
            this.throwInvalidTDS();
        }
        return n;
    }

    private long readNanosSinceMidnight(int n) throws SQLServerException {
        assert (0 <= n && n <= 7);
        byte[] byArray = new byte[TDS.nanosSinceMidnightLength(n)];
        this.readBytes(byArray, 0, byArray.length);
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l |= ((long)byArray[i] & 0xFFL) << 8 * i;
        }
        if (0L > (l *= (long)SCALED_MULTIPLIERS[n]) || l >= 864000000000L) {
            this.throwInvalidTDS();
        }
        return 100L * l;
    }

    final Object readGUID(int n, JDBCType jDBCType, StreamType streamType) throws SQLServerException {
        if (16 != n) {
            this.throwInvalidTDS();
        }
        byte[] byArray = new byte[16];
        this.readBytes(byArray, 0, 16);
        switch (jDBCType) {
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                int n2;
                StringBuilder stringBuilder = new StringBuilder(guidTemplate.length());
                for (n2 = 0; n2 < 4; ++n2) {
                    stringBuilder.append(Util.hexChars[(byArray[3 - n2] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[3 - n2] & 0xF]);
                }
                stringBuilder.append('-');
                for (n2 = 0; n2 < 2; ++n2) {
                    stringBuilder.append(Util.hexChars[(byArray[5 - n2] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[5 - n2] & 0xF]);
                }
                stringBuilder.append('-');
                for (n2 = 0; n2 < 2; ++n2) {
                    stringBuilder.append(Util.hexChars[(byArray[7 - n2] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[7 - n2] & 0xF]);
                }
                stringBuilder.append('-');
                for (n2 = 0; n2 < 2; ++n2) {
                    stringBuilder.append(Util.hexChars[(byArray[8 + n2] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[8 + n2] & 0xF]);
                }
                stringBuilder.append('-');
                for (n2 = 0; n2 < 6; ++n2) {
                    stringBuilder.append(Util.hexChars[(byArray[10 + n2] & 0xF0) >> 4]);
                    stringBuilder.append(Util.hexChars[byArray[10 + n2] & 0xF]);
                }
                try {
                    return DDC.convertStringToObject(stringBuilder.toString(), Encoding.UNICODE.charsetName(), jDBCType, streamType);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
                    throw new SQLServerException(messageFormat.format(new Object[]{"UNIQUEIDENTIFIER", jDBCType}), null, 0, (Throwable)unsupportedEncodingException);
                }
            }
        }
        if (StreamType.BINARY == streamType || StreamType.ASCII == streamType) {
            return new ByteArrayInputStream(byArray);
        }
        return byArray;
    }

    final SQLIdentifier readSQLIdentifier() throws SQLServerException {
        int n = this.readUnsignedByte();
        if (1 > n || n > 4) {
            this.throwInvalidTDS();
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readUnicodeString(this.readUnsignedShort());
        }
        SQLIdentifier sQLIdentifier = new SQLIdentifier();
        sQLIdentifier.setObjectName(stringArray[n - 1]);
        if (n >= 2) {
            sQLIdentifier.setSchemaName(stringArray[n - 2]);
        }
        if (n >= 3) {
            sQLIdentifier.setDatabaseName(stringArray[n - 3]);
        }
        if (4 == n) {
            sQLIdentifier.setServerName(stringArray[n - 4]);
        }
        return sQLIdentifier;
    }

    final SQLCollation readCollation() throws SQLServerException {
        SQLCollation sQLCollation = null;
        try {
            sQLCollation = new SQLCollation(this);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.con.terminate(4, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        return sQLCollation;
    }

    final void skip(int n) throws SQLServerException {
        assert (n >= 0);
        while (n > 0) {
            int n2;
            if (!this.ensurePayload()) {
                this.throwInvalidTDS();
            }
            if ((n2 = n) > this.currentPacket.payloadLength - this.payloadOffset) {
                n2 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            n -= n2;
            this.payloadOffset += n2;
        }
    }
}

