/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.serializer;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Scalar;
import org.openfast.template.Sequence;
import org.openfast.template.serializer.ComposedDecimalSerializer;
import org.openfast.template.serializer.DynamicTemplateReferenceSerializer;
import org.openfast.template.serializer.GroupSerializer;
import org.openfast.template.serializer.MessageTemplateSerializer;
import org.openfast.template.serializer.ScalarSerializer;
import org.openfast.template.serializer.SequenceSerializer;
import org.openfast.template.serializer.SerializerRegistry;
import org.openfast.template.serializer.SerializingContext;
import org.openfast.template.serializer.StaticTemplateReferenceSerializer;
import org.openfast.template.serializer.TemplateSerializer;
import org.openfast.template.serializer.VariableLengthScalarSerializer;
import org.openfast.util.XmlWriter;

public class XMLMessageTemplateSerializer
implements MessageTemplateSerializer {
    private SerializingContext initialContext = XMLMessageTemplateSerializer.createInitialContext();

    public static SerializingContext createInitialContext() {
        SerializerRegistry registry = new SerializerRegistry();
        registry.addFieldSerializer(new ScalarSerializer());
        registry.addFieldSerializer(new DynamicTemplateReferenceSerializer());
        registry.addFieldSerializer(new StaticTemplateReferenceSerializer());
        registry.addFieldSerializer(new ComposedDecimalSerializer());
        registry.addFieldSerializer(new GroupSerializer());
        registry.addFieldSerializer(new SequenceSerializer());
        registry.addFieldSerializer(new TemplateSerializer());
        registry.addFieldSerializer(new VariableLengthScalarSerializer());
        SerializingContext context = SerializingContext.createInitialContext(registry);
        return context;
    }

    public void serialize(MessageTemplate[] templates, OutputStream destination) {
        XmlWriter writer = new XmlWriter(destination);
        writer.setEnableProcessingInstructions(true);
        SerializingContext context = new SerializingContext(this.initialContext);
        writer.start("templates");
        String templateNamespace = this.whichTemplateNamespaceIsUsedMost(templates);
        String childNamespace = this.whichNamespaceIsUsedMode(templates);
        if (!"".equals(childNamespace)) {
            writer.addAttribute("ns", childNamespace);
        }
        if (!"".equals(templateNamespace)) {
            writer.addAttribute("templateNs", templateNamespace);
        }
        writer.addAttribute("xmlns", "http://www.fixprotocol.org/ns/fast/td/1.1");
        context.setTemplateNamespace(templateNamespace);
        context.setNamespace(childNamespace);
        int i = 0;
        while (i < templates.length) {
            context.serialize(writer, templates[i]);
            ++i;
        }
        writer.end();
    }

    private String whichNamespaceIsUsedMode(MessageTemplate[] templates) {
        HashMap namespaces = new HashMap();
        int i = 0;
        while (i < templates.length) {
            this.tallyNamespaceReferences(templates[i], namespaces);
            ++i;
        }
        Iterator iter = namespaces.keySet().iterator();
        int champion = 0;
        String championNs = "";
        while (iter.hasNext()) {
            String contender = (String)iter.next();
            int contenderCount = (Integer)namespaces.get(contender);
            if (contenderCount <= champion) continue;
            champion = contenderCount;
            championNs = contender;
        }
        return championNs;
    }

    private void tallyNamespaceReferences(Group group, Map namespaces) {
        int start = 0;
        if (group instanceof MessageTemplate) {
            start = 1;
        }
        int i = start;
        while (i < group.getFieldCount()) {
            if (group.getField(i) instanceof Scalar) {
                String ns = group.getField(i).getQName().getNamespace();
                if (!namespaces.containsKey(ns)) {
                    namespaces.put(ns, new Integer(1));
                } else {
                    namespaces.put(ns, new Integer((Integer)namespaces.get(ns) + 1));
                }
            } else if (group.getField(i) instanceof Group) {
                this.tallyNamespaceReferences((Group)group.getField(i), namespaces);
            } else if (group.getField(i) instanceof Sequence) {
                this.tallyNamespaceReferences(((Sequence)group.getField(i)).getGroup(), namespaces);
            }
            ++i;
        }
    }

    private String whichTemplateNamespaceIsUsedMost(MessageTemplate[] templates) {
        HashMap<String, Integer> namespaces = new HashMap<String, Integer>();
        int i = 0;
        while (i < templates.length) {
            String ns = templates[i].getQName().getNamespace();
            if (!namespaces.containsKey(ns)) {
                namespaces.put(ns, new Integer(1));
            } else {
                namespaces.put(ns, new Integer((Integer)namespaces.get(ns) + 1));
            }
            ++i;
        }
        Iterator iter = namespaces.keySet().iterator();
        int champion = 0;
        String championNs = "";
        while (iter.hasNext()) {
            String contender = (String)iter.next();
            int contenderCount = (Integer)namespaces.get(contender);
            if (contenderCount <= champion) continue;
            champion = contenderCount;
            championNs = contender;
        }
        return championNs;
    }
}

